/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.concurrency;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import net.anotheria.util.concurrency.IdBasedLockManager;

public class IdBasedLock<K>
implements Serializable {
    private static final long serialVersionUID = 6517735561182643502L;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final ReentrantLock lock = new ReentrantLock();
    private final IdBasedLockManager<K> parent;
    private final K id;

    IdBasedLock(K anId, IdBasedLockManager<K> aParent) {
        this.id = anId;
        this.parent = aParent;
    }

    void increaseRefCount() {
        this.refCount.incrementAndGet();
    }

    void decreaseRefCount() {
        this.refCount.decrementAndGet();
    }

    public int getReferenceCount() {
        return this.refCount.get();
    }

    AtomicInteger getRefCount() {
        return this.refCount;
    }

    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        return this.lock.tryLock(timeout, unit);
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlockWithoutRelease() {
        this.lock.unlock();
    }

    public void unlock() {
        this.lock.unlock();
        this.parent.releaseLock(this);
    }

    public String toString() {
        return "(" + this.id + ", " + this.refCount + ")";
    }

    K getId() {
        return this.id;
    }
}

