/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.concurrency;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.anotheria.util.concurrency.AbstractIdBasedLockManager;
import net.anotheria.util.concurrency.IdBasedLock;
import net.anotheria.util.concurrency.IdBasedLockManager;

public class UnsafeIdBasedLockManager<K>
extends AbstractIdBasedLockManager<K>
implements IdBasedLockManager<K> {
    private static final long serialVersionUID = -4257919838109398407L;
    private ConcurrentMap<K, IdBasedLock<K>> locks = new ConcurrentHashMap<K, IdBasedLock<K>>();

    @Override
    public IdBasedLock<K> obtainLock(K id) {
        IdBasedLock<K> lock = new IdBasedLock<K>(id, this);
        IdBasedLock<K> myLock = this.locks.putIfAbsent(id, lock);
        if (myLock == null) {
            return lock;
        }
        myLock.lock();
        myLock.increaseRefCount();
        if (myLock.getRefCount().get() == 1) {
            IdBasedLock<K> raceCond = this.locks.put(id, myLock);
        }
        myLock.unlockWithoutRelease();
        return myLock;
    }

    @Override
    public void releaseLock(IdBasedLock<K> lock) {
        K id = lock.getId();
        lock.lock();
        if (lock.getRefCount().get() == 1) {
            IdBasedLock idBasedLock = (IdBasedLock)this.locks.remove(id);
        }
        lock.decreaseRefCount();
        lock.unlockWithoutRelease();
    }

    @Override
    protected Map<K, IdBasedLock<K>> getLockMap() {
        return this.locks;
    }
}

