/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.content.template.configs;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.anotheria.util.StringUtils;
import net.anotheria.util.content.template.configs.CustomConstantVariableConfig;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.configureme.annotations.DontConfigure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigureMe(name="ano-util-template-processor-config")
public final class TemplateProcessorConfig
implements Serializable {
    @DontConfigure
    private static final long serialVersionUID = -4135549619855269472L;
    @DontConfigure
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateProcessorConfig.class);
    @DontConfigure
    private static TemplateProcessorConfig instance;
    @DontConfigure
    private static final Object LOCK;
    @Configure
    private CustomConstantVariableConfig[] customConstantVariables;

    private TemplateProcessorConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TemplateProcessorConfig getInstance() {
        if (instance != null) {
            return instance;
        }
        Object object = LOCK;
        synchronized (object) {
            if (instance != null) {
                return instance;
            }
            instance = new TemplateProcessorConfig();
            try {
                ConfigurationManager.INSTANCE.configure((Object)instance);
                LOGGER.info("getInstance() configured with[" + instance.toString() + "].");
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("getInstance() configuration fail. Relaying on defaults[" + instance.toString() + "].");
            }
            return instance;
        }
    }

    public CustomConstantVariableConfig[] getCustomConstantVariables() {
        return this.customConstantVariables;
    }

    public void setCustomConstantVariables(CustomConstantVariableConfig[] customConstantVariables) {
        this.customConstantVariables = customConstantVariables;
    }

    public Map<String, String> getCustomConstantVariablesMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.customConstantVariables == null || this.customConstantVariables.length == 0) {
            return result;
        }
        for (CustomConstantVariableConfig customConstantVariable : this.customConstantVariables) {
            if (StringUtils.isEmpty(customConstantVariable.getKey())) continue;
            result.put(customConstantVariable.getKey(), customConstantVariable.getValue());
        }
        return result;
    }

    public String toString() {
        return "TemplateProcessorConfig{customConstantVariables=" + Arrays.toString(this.customConstantVariables) + '}';
    }

    static {
        LOCK = new Object();
    }
}

