/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.content.template.processors.variables;

import net.anotheria.util.StringUtils;

public enum ConditionProcessorNames {
    iF("if"){

        @Override
        public String executeReplacement(String variable, String defVal) {
            String[] ret = StringUtils.tokenize(defVal, ';');
            return Boolean.TRUE.toString().equals(variable) ? ret[0] : (ret.length > 1 ? ret[1] : "");
        }
    }
    ,
    ifNot("ifNot"){

        @Override
        public String executeReplacement(String variable, String defVal) {
            return !Boolean.TRUE.toString().equals(variable) ? defVal : "";
        }
    }
    ,
    present("present"){

        @Override
        public String executeReplacement(String variable, String defVal) {
            return variable.length() > 0 ? defVal : "";
        }
    }
    ,
    notPresent("notPresent"){

        @Override
        public String executeReplacement(String variable, String defVal) {
            return variable.length() <= 0 ? defVal : "";
        }
    }
    ,
    equals("equals"){

        @Override
        public String executeReplacement(String variable, String defVal) {
            return String.valueOf(variable != null && defVal != null && variable.equals(defVal));
        }
    }
    ,
    notEquals("notEquals"){

        @Override
        public String executeReplacement(String variable, String defVal) {
            return String.valueOf(variable == null || defVal == null || !variable.equals(defVal));
        }
    }
    ,
    inRange("inRange"){

        @Override
        public String executeReplacement(String variable, String defVal) {
            return String.valueOf(ConditionProcessorNames.inRange(variable, defVal));
        }
    }
    ,
    greaterThan("greaterThan"){

        @Override
        public String executeReplacement(String variable, String defVal) {
            return String.valueOf(ConditionProcessorNames.checkRelations(variable, defVal, Relations.greaterThanRelation));
        }
    }
    ,
    greaterEqual("greaterEqual"){

        @Override
        public String executeReplacement(String variable, String defVal) {
            return String.valueOf(ConditionProcessorNames.checkRelations(variable, defVal, Relations.greaterEqualRelation));
        }
    }
    ,
    lessThan("lessThan"){

        @Override
        public String executeReplacement(String variable, String defVal) {
            return String.valueOf(ConditionProcessorNames.checkRelations(variable, defVal, Relations.lessThanRelation));
        }
    }
    ,
    lessEqual("lessEqual"){

        @Override
        public String executeReplacement(String variable, String defVal) {
            return String.valueOf(ConditionProcessorNames.checkRelations(variable, defVal, Relations.lessEqualRelation));
        }
    };

    private String prefixName;

    private ConditionProcessorNames(String stringValue) {
        this.prefixName = stringValue;
    }

    public String getPrefixName() {
        return this.prefixName;
    }

    public abstract String executeReplacement(String var1, String var2);

    private static boolean inRange(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        String[] rangeTokens = StringUtils.tokenize(s1, '-');
        if (rangeTokens.length != 2) {
            return false;
        }
        try {
            int rangeMin = Integer.parseInt(rangeTokens[0]);
            int rangeMax = Integer.parseInt(rangeTokens[1]);
            int value = Integer.parseInt(s2);
            return rangeMin <= value && value <= rangeMax;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    private static boolean checkRelations(String var, String var2, Relations option) {
        if (option == null) {
            throw new IllegalArgumentException("option can't be null");
        }
        if (!(var != null && var2 != null || var.isEmpty() && var2.isEmpty())) {
            return false;
        }
        try {
            int value = Integer.valueOf(var);
            int value2 = Integer.valueOf(var2);
            boolean result = false;
            switch (option) {
                case greaterThanRelation: {
                    result = value > value2;
                    break;
                }
                case greaterEqualRelation: {
                    result = value >= value2;
                    break;
                }
                case lessThanRelation: {
                    result = value < value2;
                    break;
                }
                case lessEqualRelation: {
                    result = value <= value2;
                }
            }
            return result;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    private static enum Relations {
        greaterThanRelation,
        greaterEqualRelation,
        lessThanRelation,
        lessEqualRelation;

    }
}

