/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.csv;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.util.StringUtils;
import net.anotheria.util.datatable.DataCell;
import net.anotheria.util.datatable.DataHeader;
import net.anotheria.util.datatable.DataRow;
import net.anotheria.util.datatable.DataTable;

public class CSVParser {
    public static final char DEFAULT_VALUES_SEPARATOR = ',';
    public static final char DEFAULT_ROWS_SEPARATOR = '\n';

    private static String normalize(String csvSource) {
        return StringUtils.removeChar(csvSource, '\r');
    }

    public static DataTable parse(String csvSource) {
        return CSVParser.parse(csvSource, true);
    }

    public static DataTable parse(String csvSource, boolean hasHeader) {
        return CSVParser.parse(CSVParser.normalize(csvSource), ',', hasHeader);
    }

    public static DataTable parse(String csvSource, char valuesSeparator, boolean hasHeader) {
        return CSVParser.parse(CSVParser.normalize(csvSource), valuesSeparator, '\n', hasHeader);
    }

    public static DataTable parse(String csvSource, char valuesSeparator, char rowsSeparator, boolean hasHeader) {
        int i;
        String[] rows = StringUtils.tokenize(csvSource, rowsSeparator);
        if (rows.length == 0) {
            throw new RuntimeException("No rows found!");
        }
        rows = CSVParser.normalizeEscapedNewlines(rows);
        DataTable ret = new DataTable(rows.length);
        if (hasHeader) {
            ret.setHeader(CSVParser.toDataHeader(CSVParser.parseRow(rows[0], valuesSeparator, true)));
        }
        int n = i = hasHeader ? 1 : 0;
        while (i < rows.length) {
            ret.addRow(CSVParser.parseRow(rows[i], valuesSeparator, true));
            ++i;
        }
        return ret;
    }

    private static DataRow parseRow(String row, char valuesSeparator, boolean unescape) {
        try {
            List<String> tokens = StringUtils._tokenize(row, '\"', '\"', false, valuesSeparator);
            DataRow ret = new DataRow();
            for (String t : tokens) {
                if (unescape && t.indexOf(34) >= 0) {
                    t = CSVParser.unescape(t);
                }
                ret.addCell(new DataCell(t));
            }
            return ret;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Could not parse CSV Row: " + row, e);
        }
    }

    private static String unescape(String t) {
        int index = 0;
        while ((index = t.indexOf("\"\"", index)) >= 0) {
            t = t.substring(0, index) + t.substring(index + 1);
            ++index;
        }
        if (StringUtils.isSurroundedWith(t, '\"', '\"') && (t.indexOf(44) >= 0 || t.indexOf(34) >= 0 || t.indexOf(10) >= 0)) {
            t = StringUtils.removeSurround(t);
        }
        return t;
    }

    private static boolean hasOddNumberOfQuotes(String text) {
        boolean isOddCount = false;
        int i = 0;
        while (i >= 0) {
            if ((i = text.indexOf(34, i)) < 0) continue;
            isOddCount = !isOddCount;
            ++i;
        }
        return isOddCount;
    }

    private static String[] normalizeEscapedNewlines(String[] rows) {
        ArrayList<String> result = new ArrayList<String>(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            String row = rows[i];
            if (CSVParser.hasOddNumberOfQuotes(row)) {
                boolean endFound = false;
                int j = i + 1;
                while (j < rows.length && !endFound) {
                    row = row + '\n' + rows[j];
                    endFound = CSVParser.hasOddNumberOfQuotes(rows[j]);
                    ++j;
                    ++i;
                }
            }
            result.add(row);
        }
        return result.toArray(new String[result.size()]);
    }

    private static DataHeader toDataHeader(DataRow headerRow) {
        DataHeader ret = new DataHeader();
        for (DataCell cell : headerRow) {
            ret.addHeader(cell.getValueAsString());
        }
        return ret;
    }
}

