/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.datatable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.anotheria.util.datatable.DataHeader;
import net.anotheria.util.datatable.DataRow;

public class DataTable
implements Iterable<DataRow> {
    private DataHeader header;
    private List<DataRow> rows;

    public DataTable() {
        this(10);
    }

    public DataTable(int aInitialCapacity) {
        this.rows = new ArrayList<DataRow>(aInitialCapacity);
    }

    public DataHeader getHeader() {
        return this.header;
    }

    public void setHeader(DataHeader aHeader) {
        this.header = aHeader;
    }

    public DataRow getRow(int aIndex) {
        return this.rows.get(aIndex);
    }

    public void setRow(int aIndex, DataRow aRow) {
        this.rows.set(aIndex, aRow);
    }

    public void addRow(DataRow aRow) {
        this.rows.add(aRow);
    }

    public void removeRow(int aIndex) {
        this.rows.remove(aIndex);
    }

    public void removeRow(DataRow aRow) {
        this.rows.remove(aRow);
    }

    public int getRowIndex(DataRow aRow) {
        return this.rows.indexOf(aRow);
    }

    public int getRowsSize() {
        return this.rows.size();
    }

    @Override
    public Iterator<DataRow> iterator() {
        return this.rows.iterator();
    }

    public String toString() {
        String ret = "";
        ret = ret + "HEADER:";
        ret = ret + "\n";
        ret = ret + this.header.toString();
        ret = ret + "\n";
        ret = ret + "ROWS:";
        ret = ret + "\n";
        for (DataRow r : this) {
            ret = ret + r.toString();
            ret = ret + "\n";
        }
        return ret;
    }
}

