/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.charset.Charset;

public class UnicodeReader
extends Reader {
    PushbackInputStream internalIn;
    InputStreamReader internalIn2 = null;
    private Charset charset;
    private static final int BOM_SIZE = 4;

    public UnicodeReader(InputStream in) {
        this(in, Charset.defaultCharset());
    }

    public UnicodeReader(InputStream in, String charsetName) {
        this(in, Charset.forName(charsetName));
    }

    public UnicodeReader(InputStream aIn, Charset aCharset) {
        this.internalIn = new PushbackInputStream(aIn, 4);
        this.charset = aCharset;
    }

    public String getEncoding() {
        if (this.internalIn2 == null) {
            return null;
        }
        return this.internalIn2.getEncoding();
    }

    protected void init() throws IOException {
        int unread;
        Charset preciseCharset;
        if (this.internalIn2 != null) {
            return;
        }
        byte[] bom = new byte[4];
        int n = this.internalIn.read(bom, 0, bom.length);
        if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            preciseCharset = Charset.forName("UTF-32BE");
            unread = n - 4;
        } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            preciseCharset = Charset.forName("UTF-32LE");
            unread = n - 4;
        } else if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            preciseCharset = Charset.forName("UTF-8");
            unread = n - 3;
        } else if (bom[0] == -2 && bom[1] == -1) {
            preciseCharset = Charset.forName("UTF-16BE");
            unread = n - 2;
        } else if (bom[0] == -1 && bom[1] == -2) {
            preciseCharset = Charset.forName("UTF-16LE");
            unread = n - 2;
        } else {
            preciseCharset = this.charset;
            unread = n;
        }
        if (unread > 0) {
            this.internalIn.unread(bom, n - unread, unread);
        }
        this.internalIn2 = preciseCharset == null ? new InputStreamReader(this.internalIn) : new InputStreamReader((InputStream)this.internalIn, preciseCharset);
    }

    @Override
    public void close() throws IOException {
        this.init();
        this.internalIn2.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.init();
        return this.internalIn2.read(cbuf, off, len);
    }
}

