/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.mapper;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.anotheria.util.mapper.DontPopulate;
import net.anotheria.util.mapper.PopulateMe;
import net.anotheria.util.mapper.PopulateWith;
import org.dozer.DozerBeanMapper;
import org.dozer.Mapper;
import org.dozer.MappingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValueObjectMapperUtil {
    private static final Mapper mapper = new DozerBeanMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueObjectMapperUtil.class);

    private ValueObjectMapperUtil() {
    }

    public static void map(Object source, Object destination) {
        Field[] fields;
        boolean isMap = source instanceof Map;
        Class<?> destinationClass = destination.getClass();
        PopulateMe populateMe = destinationClass.getAnnotation(PopulateMe.class);
        boolean populateAll = false;
        if (populateMe != null && !(populateAll = populateMe.all())) {
            return;
        }
        HashMap<String, Object> populateAllFields = new HashMap<String, Object>();
        for (Field field : fields = destinationClass.getDeclaredFields()) {
            PopulateWith populateWith = field.getAnnotation(PopulateWith.class);
            if (populateWith != null) {
                if (isMap) {
                    Map sourceMap = (Map)source;
                    sourceMap.put(field.getName(), sourceMap.get(populateWith.value()));
                } else {
                    ValueObjectMapperUtil.setFieldValue(destination, field, ValueObjectMapperUtil.getFieldValue(source, populateWith.value()));
                }
            }
            DontPopulate dontPopulate = field.getAnnotation(DontPopulate.class);
            if (!populateAll || dontPopulate != null) continue;
            populateAllFields.put(field.getName(), ValueObjectMapperUtil.getFieldValue(source, field.getName()));
        }
        if (populateAll) {
            ValueObjectMapperUtil.mapDozer(populateAllFields, destination);
        } else {
            ValueObjectMapperUtil.mapDozer(source, destination);
        }
    }

    private static void mapDozer(Object source, Object destination) {
        try {
            mapper.map(source, destination);
        }
        catch (MappingException e) {
            LOGGER.debug("mapDozer", (Throwable)e);
        }
    }

    private static Object getFieldValue(Object source, String key) {
        try {
            Field sourceField = source.getClass().getDeclaredField(key);
            if (sourceField == null) {
                throw new NoSuchFieldException("Source class field not found by " + key);
            }
            sourceField.setAccessible(true);
            return sourceField.get(source);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("getFieldField", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            LOGGER.error("getFieldField", (Throwable)e);
        }
        return null;
    }

    private static void setFieldValue(Object destination, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(destination, value);
        }
        catch (IllegalAccessException e) {
            LOGGER.debug("setFieldValue", (Throwable)e);
        }
    }
}

