/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.queue;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.anotheria.util.queue.IQueue;
import net.anotheria.util.queue.IQueueFactory;
import net.anotheria.util.queue.IQueueWorker;
import net.anotheria.util.queue.QueueOverflowException;
import net.anotheria.util.queue.StandardQueueFactory;
import net.anotheria.util.queue.UnrecoverableQueueOverflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuedProcessor<T>
extends Thread {
    private String name;
    private int counter;
    private Logger log;
    private static Logger defaultLog = LoggerFactory.getLogger(QueuedProcessor.class);
    private IQueue<T> queue;
    private IQueueWorker<T> worker;
    public static final long DEF_SLEEP_TIME = 50L;
    public static final int DEF_QUEUE_SIZE = 1000;
    private int queueSize;
    private long sleepTime;
    private int overflowCount;
    private AtomicInteger throwAwayCount = new AtomicInteger(0);
    private AtomicLong waitingTime = new AtomicLong(0L);
    private final IQueueFactory<T> DEF_QUEUE_FACTORY = new StandardQueueFactory();
    private IQueueFactory<T> queueFactory;
    private AtomicBoolean stopImmediately;

    public QueuedProcessor(String aName, IQueueWorker<T> aWorker, IQueueFactory<T> aQueueFactory, int aQueueSize, long aSleepTime, Logger aLog) {
        super(aName);
        this.setDaemon(true);
        this.queueSize = aQueueSize;
        this.sleepTime = aSleepTime;
        this.worker = aWorker;
        this.queueFactory = aQueueFactory == null ? this.DEF_QUEUE_FACTORY : aQueueFactory;
        this.log = aLog;
        if (this.log == null) {
            defaultLog.warn("Tried to assign null logger, switching to defLogger");
            this.log = defaultLog;
        }
        this.init();
    }

    public QueuedProcessor(String aName, IQueueWorker<T> aWorker, IQueueFactory<T> aQueueFactory, Logger aLog) {
        this(aName, aWorker, aQueueFactory, 1000, 50L, aLog);
    }

    public QueuedProcessor(String aName, IQueueWorker<T> aWorker, int aQueueSize, long aSleepTime, Logger aLog) {
        this(aName, aWorker, null, aQueueSize, aSleepTime, aLog);
    }

    public QueuedProcessor(String aName, IQueueWorker<T> aWorker, int aQueueSize, Logger aLog) {
        this(aName, aWorker, aQueueSize, 50L, aLog);
    }

    public QueuedProcessor(String aName, IQueueWorker<T> aWorker, Logger aLog) {
        this(aName, aWorker, 1000, 50L, aLog);
    }

    public QueuedProcessor(String aName, IQueueWorker<T> aWorker, IQueueFactory<T> aQueueFactory) {
        this(aName, aWorker, aQueueFactory, defaultLog);
    }

    public QueuedProcessor(String aName, IQueueWorker<T> aWorker) {
        this(aName, aWorker, null, defaultLog);
    }

    private void init() {
        this.queue = this.queueFactory.createQueue(this.queueSize);
        this.stopImmediately = new AtomicBoolean(false);
    }

    public void reset() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueueAndWait(T element) {
        while (true) {
            try {
                this.queue.putElement(element);
                return;
            }
            catch (QueueOverflowException e) {
                ++this.overflowCount;
                try {
                    IQueue<T> iQueue = this.queue;
                    synchronized (iQueue) {
                        long waitStart = System.currentTimeMillis();
                        this.queue.wait();
                        this.waitingTime.addAndGet(System.currentTimeMillis() - waitStart);
                        continue;
                    }
                }
                catch (InterruptedException ignored) {
                    this.log.warn("Ignored exception: " + ignored.getMessage(), (Throwable)ignored);
                    continue;
                }
            }
            break;
        }
    }

    public void addToQueue(T aElement) throws UnrecoverableQueueOverflowException {
        this.addToQueueDontWait(aElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueueDontWait(T aElement) throws UnrecoverableQueueOverflowException {
        try {
            this.queue.putElement(aElement);
        }
        catch (QueueOverflowException e1) {
            ++this.overflowCount;
            QueuedProcessor queuedProcessor = this;
            synchronized (queuedProcessor) {
                try {
                    long waitStart = System.currentTimeMillis();
                    Thread.sleep(100L);
                    this.waitingTime.addAndGet(System.currentTimeMillis() - waitStart);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            try {
                this.queue.putElement(aElement);
            }
            catch (QueueOverflowException e2) {
                this.throwAwayCount.incrementAndGet();
                this.log.error("couldn't recover from queue overflow, throwing away " + aElement);
                throw new UnrecoverableQueueOverflowException("Element: " + aElement + ", stats:" + this.getStatsString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        final AtomicBoolean shutdown = new AtomicBoolean(false);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                QueuedProcessor.this.log.info("Shutting down processor!");
                shutdown.set(true);
                try {
                    AtomicBoolean atomicBoolean = shutdown;
                    synchronized (atomicBoolean) {
                        QueuedProcessor.this.log.info("Wait while queue processing complete...");
                        shutdown.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                QueuedProcessor.this.log.info("Processor is shutted down!");
                QueuedProcessor.this.log.info("Stats: " + QueuedProcessor.this.getStatsString());
            }
        });
        try {
            this.counter = 0;
            while (!this.stopImmediately.get()) {
                if (this.queue.hasElements()) {
                    ++this.counter;
                    try {
                        Object element = null;
                        IQueue<T> iQueue = this.queue;
                        synchronized (iQueue) {
                            element = this.queue.nextElement();
                            this.queue.notify();
                        }
                        this.worker.doWork(element);
                    }
                    catch (Exception e) {
                        this.log.error("Failure while working under element: ", (Throwable)e);
                    }
                    continue;
                }
                if (shutdown.get()) {
                    this.log.info("Queue is empty. Processing completed!");
                    AtomicBoolean e = shutdown;
                    synchronized (e) {
                        shutdown.notify();
                        break;
                    }
                }
                try {
                    QueuedProcessor.sleep(this.sleepTime);
                }
                catch (InterruptedException ignored) {}
            }
        }
        catch (Throwable ttt) {
            try {
                this.log.error("run ", ttt);
            }
            catch (Exception e) {
                System.out.println(QueuedProcessor.class + " Can't log!!!");
                ttt.printStackTrace();
            }
        }
    }

    public void stopImmediately() {
        this.stopImmediately.set(true);
    }

    public boolean isStopped() {
        return this.stopImmediately.get();
    }

    public int getQueueOverflowCount() {
        return this.overflowCount;
    }

    public int getQueueSize() {
        return this.queue.getElementCount();
    }

    public int getThrowAwayCount() {
        return this.throwAwayCount.intValue();
    }

    public String getStatsString() {
        return "QueuedProcessor " + this.name + ": " + this.counter + " elements worked, queue: " + this.queue.toString() + ", OC:" + this.overflowCount + ", WT:" + this.waitingTime + ", TAC:" + this.throwAwayCount;
    }

    public void logOutInfo() {
        this.log.info("QueuedProcessor " + this.name + ": " + this.counter + " elements worked, stat: " + this.queue.toString() + ", OC:" + this.overflowCount + ", WT:" + this.waitingTime + ", TAC:" + this.throwAwayCount);
    }

    public IQueueFactory<T> getQueueFactory() {
        return this.queueFactory;
    }

    public void setQueueFactory(IQueueFactory<T> queueFactory) {
        this.queueFactory = queueFactory;
    }
}

