/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import net.anotheria.util.IOUtils;
import net.anotheria.util.NumberUtils;
import net.anotheria.util.resource.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathResourceLoader
implements ResourceLoader {
    private static Logger log = LoggerFactory.getLogger(ClassPathResourceLoader.class);

    private ClassLoader getClassPathLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    public boolean isAvailable(String fileName) {
        ClassLoader myLoader = this.getClassPathLoader();
        URL u = myLoader.getResource(fileName);
        return u != null;
    }

    @Override
    public long getLastChangeTimestamp(String fileName) {
        ClassLoader myLoader = this.getClassPathLoader();
        URL u = myLoader.getResource(fileName);
        if (u == null) {
            throw new IllegalArgumentException("File: " + fileName + " doesn't exists (URL is null)");
        }
        File f = new File(u.getFile());
        log.debug("Checking timestamp for file: " + f.getAbsolutePath());
        long ret = f.lastModified();
        log.debug("file " + f.getAbsolutePath() + " last modified is: " + NumberUtils.makeISO8601TimestampString(ret));
        return ret;
    }

    @Override
    public String getContent(String fileName) {
        String string;
        ClassLoader myLoader = this.getClassPathLoader();
        URL u = myLoader.getResource(fileName);
        if (u == null) {
            throw new IllegalArgumentException("File: " + fileName + " doesn't exists (URL is null)");
        }
        BufferedReader reader = null;
        try {
            int c;
            File f = new File(u.getFile());
            reader = new BufferedReader(new FileReader(f));
            StringBuilder ret = new StringBuilder();
            while ((c = ((Reader)reader).read()) != -1) {
                ret.append((char)c);
            }
            string = ret.toString();
        }
        catch (IOException e) {
            try {
                log.error("getContent(" + fileName + ")", (Throwable)e);
                throw new RuntimeException("can't read source: " + fileName, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeIgnoringException(reader);
                throw throwable;
            }
        }
        IOUtils.closeIgnoringException(reader);
        return string;
    }
}

