/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.resource;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.anotheria.util.NumberUtils;
import net.anotheria.util.resource.Resource;
import net.anotheria.util.resource.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum WatchDog {
    INSTANCE(10000L);

    private static Logger log;
    private Map<String, Resource> watchingRegistry = new ConcurrentHashMap<String, Resource>();
    private volatile long pause;

    private WatchDog(long aPause) {
        this.pause = aPause;
        new WatcherThread().start();
    }

    public long getPause() {
        return this.pause;
    }

    public void addResourceToWatch(Resource resource) {
        this.watchingRegistry.put(resource.getName(), resource);
    }

    public void removeResourceFromWatch(Resource resource) {
        this.watchingRegistry.remove(resource.getName());
    }

    static {
        log = LoggerFactory.getLogger(WatchDog.class);
    }

    private final class WatcherThread
    extends Thread {
        private WatcherThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (!Thread.interrupted()) {
                    Thread.sleep(WatchDog.this.getPause());
                    HashSet watchedResources = new HashSet(WatchDog.this.watchingRegistry.values());
                    for (Resource source : watchedResources) {
                        ResourceLoader loader = source.getResourceLoader();
                        try {
                            long lastUpdate = loader.getLastChangeTimestamp(source.getName());
                            log.debug("Checking source: " + source + ", lastUpdateFromLoader= " + NumberUtils.makeISO8601TimestampString(lastUpdate) + ", storedLastUpdate=" + NumberUtils.makeISO8601TimestampString(source.getLastChangeTimestamp()));
                            if (!source.isOlderAs(lastUpdate)) continue;
                            log.debug("firing update event: " + source);
                            source.fireUpdateEvent(lastUpdate);
                        }
                        catch (IllegalArgumentException e) {
                            log.warn("Apparently checking for non existing source, how did it came into the registry anyway?", (Throwable)e);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

