/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.slicer;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slice;

public class Slicer {
    public static <T> Slice<T> slice(Segment segment, List<T> data) {
        int totalElements = data.size();
        Slice<Object> ret = new Slice<Object>(segment);
        ret.setTotalNumberOfItems(totalElements);
        double pageCount = (double)totalElements / (double)segment.getElementsPerSlice();
        int showedPageCount = (int)pageCount;
        if ((double)showedPageCount < pageCount) {
            ++showedPageCount;
        }
        ret.setTotalNumberOfSlices(showedPageCount);
        int startIndex = segment.getElementsPerSlice() * (segment.getSliceNumber() - 1);
        int endIndex = segment.getElementsPerSlice() * segment.getSliceNumber();
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (startIndex > totalElements) {
            ret.setSliceData(new ArrayList());
            return ret;
        }
        if (endIndex > totalElements) {
            endIndex = totalElements;
        }
        if (endIndex < startIndex) {
            throw new AssertionError((Object)("EndIndex greater as StartIndex: " + endIndex + " > " + startIndex));
        }
        List<T> sliced = data.subList(startIndex, endIndex);
        ret.setSliceData(sliced);
        return ret;
    }
}

