/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.sorter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import net.anotheria.util.sorter.AbstractSorter;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.sorter.SortType;

public class BubbleSorter<T extends IComparable>
extends AbstractSorter<T> {
    @Override
    public List<T> sort(Enumeration<T> source, SortType method) {
        ArrayList<T> toSort = new ArrayList<T>();
        while (source.hasMoreElements()) {
            toSort.add(source.nextElement());
        }
        return this.sort(toSort, method);
    }

    @Override
    public List<T> sort(List<T> source, SortType method) {
        boolean changed;
        boolean sortOrder = method.getSortOrder();
        int sortAfter = method.getSortBy();
        if (source == null || source.size() == 0) {
            return source;
        }
        Object[] data = BubbleSorter.list2array(source);
        boolean wanted = sortOrder;
        int l = Array.getLength(data);
        do {
            changed = false;
            for (int i = 0; i < l - 1; ++i) {
                if (!(wanted ? data[i].compareTo(data[i + 1], sortAfter) > 0 : data[i].compareTo(data[i + 1], sortAfter) < 0)) continue;
                this.swap(data, i, i + 1);
                changed = true;
            }
        } while (changed);
        return BubbleSorter.array2list((IComparable[])data);
    }

    private void swap(Object[] data, int first, int second) {
        Object tmp = data[first];
        data[first] = data[second];
        data[second] = tmp;
    }
}

