/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.sorter;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.util.sorter.AbstractSorter;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.sorter.SortType;

public class InsertSorter<T extends IComparable>
extends AbstractSorter<T> {
    @Override
    public List<T> sort(List<T> toSort, SortType how) {
        ListEntry<IComparable<IComparable>> list = null;
        int method = how.getSortBy();
        for (IComparable c : toSort) {
            if (list == null) {
                list = new ListEntry<IComparable>(c);
                continue;
            }
            ListEntry<IComparable> le = new ListEntry<IComparable>(c);
            if (((ListEntry)list).value.compareTo(((ListEntry)le).value, method) >= 0) {
                le.next = list;
                list = le;
                continue;
            }
            list.insert(le, method);
        }
        ArrayList<IComparable> v = new ArrayList<IComparable>(list.length());
        do {
            v.add(((ListEntry)list).value);
        } while ((list = list.next) != null);
        return v;
    }

    private static class ListEntry<T extends IComparable> {
        private T value;
        public ListEntry<T> next;

        public ListEntry() {
            this.next = null;
            this.value = null;
        }

        public ListEntry(T aValue) {
            this.value = aValue;
        }

        public int length() {
            if (this.next == null) {
                return 1;
            }
            return 1 + this.next.length();
        }

        public void insert(ListEntry<T> aNewEntry, int aMethod) {
            if (this.next == null) {
                this.next = aNewEntry;
                return;
            }
            if (this.next.value.compareTo(aNewEntry.value, aMethod) >= 0) {
                aNewEntry.next = this.next;
                this.next = aNewEntry;
                return;
            }
            this.next.insert(aNewEntry, aMethod);
        }
    }
}

