/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.sorter;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.anotheria.util.sorter.AbstractSorter;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.sorter.SortType;

public class QuickSorter<T extends IComparable>
extends AbstractSorter<T> {
    @Override
    public List<T> sort(Enumeration<T> source, SortType sType) {
        ArrayList<T> ret = new ArrayList<T>();
        while (source.hasMoreElements()) {
            ret.add(source.nextElement());
        }
        return this.sort(ret, sType);
    }

    @Override
    public List<T> sort(List<T> source, SortType sType) {
        boolean sortOrder = sType.getSortOrder();
        int sortAfter = sType.getSortBy();
        SortType tmp = new SortType(sType.getSortBy(), !sType.getSortOrder());
        if (this.isSorted(source, sType)) {
            return source;
        }
        if (this.isSorted(source, tmp)) {
            return this.upsideDown(source);
        }
        boolean wanted = sortOrder;
        this.sort(source, 0, source.size() - 1, wanted, sortAfter);
        return source;
    }

    private void sort(List<T> source, int start, int end, boolean wanted, int sortAfter) {
        if (start < end) {
            int mid = this.partition(source, start, end, wanted, sortAfter);
            this.sort(source, start, mid - 1, wanted, sortAfter);
            this.sort(source, mid + 1, end, wanted, sortAfter);
        }
    }

    private List<T> upsideDown(List<T> src) {
        if (src == null) {
            return null;
        }
        ArrayList<T> ret = new ArrayList<T>(src.size());
        for (int i = src.size() - 1; i >= 0; --i) {
            ret.add(src.get(i));
        }
        return ret;
    }

    private boolean isSorted(List<T> src, SortType type) {
        IComparable comp;
        boolean wanted = type.getSortOrder();
        int sortAfter = type.getSortBy();
        Iterator<T> elements = src.iterator();
        if (elements.hasNext()) {
            comp = (IComparable)elements.next();
        } else {
            return true;
        }
        while (elements.hasNext()) {
            IComparable comp2 = (IComparable)elements.next();
            if (wanted ? this.compare(comp, comp2, sortAfter) > 0 : this.compare(comp, comp2, sortAfter) < 0) {
                return false;
            }
            comp = comp2;
        }
        return true;
    }

    private int partition(List<T> source, int start, int end, boolean wanted, int sortAfter) {
        IComparable partElement = (IComparable)source.get(end);
        int left = start - 1;
        int right = end;
        while (true) {
            if ((wanted ? this.compare(partElement, (IComparable)source.get(++left), sortAfter) > 0 : this.compare(partElement, (IComparable)source.get(++left), sortAfter) < 0) && left != end) {
                continue;
            }
            while ((wanted ? this.compare(partElement, (IComparable)source.get(--right), sortAfter) < 0 : this.compare(partElement, (IComparable)source.get(--right), sortAfter) > 0) && right != start) {
            }
            if (left >= right) break;
            this.swap(source, left, right);
        }
        this.swap(source, left, end);
        return left;
    }

    private void swap(List<T> source, int i, int j) {
        IComparable tmp = (IComparable)source.get(i);
        source.set(i, source.get(j));
        source.set(j, tmp);
    }

    private int compare(T a, T b, int sortAfter) {
        return a.compareTo(b, sortAfter);
    }
}

