/*
 * Decompiled with CFR 0.152.
 */
package org.configureme.environments;

import org.configureme.Environment;
import org.configureme.GlobalEnvironment;

public class ApplicationEnvironment
implements Environment {
    private String system;
    private String app;
    private String service;
    private String host;

    public ApplicationEnvironment(String aSystem, String anApp, String aService, String aHost) {
        this.system = aSystem;
        this.app = anApp;
        this.service = aService;
        this.host = aHost;
    }

    private ApplicationEnvironment(Builder builder) {
        this.system = builder.system;
        this.app = builder.app;
        this.service = builder.service;
        this.host = builder.host;
    }

    @Override
    public String expandedStringForm() {
        return this.toString();
    }

    @Override
    public boolean isReduceable() {
        return this.system != null && this.system.length() > 0;
    }

    @Override
    public Environment reduce() {
        if (this.host != null && this.host.length() > 0) {
            return new ApplicationEnvironment(this.system, this.app, this.service, "");
        }
        if (this.service != null && this.service.length() > 0) {
            return new ApplicationEnvironment(this.system, this.app, "", "");
        }
        if (this.app != null && this.app.length() > 0) {
            return new ApplicationEnvironment(this.system, "", "", "");
        }
        if (this.system != null && this.system.length() > 0) {
            return GlobalEnvironment.INSTANCE;
        }
        throw new AssertionError((Object)"Environment isn't reduceable, have you called isReduceable() prior to reduce()?");
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        if (this.system != null && this.system.length() > 0) {
            ret.append(this.system);
            if (this.app != null && this.app.length() > 0) {
                ret.append("_").append(this.app);
                if (this.service != null && this.service.length() > 0) {
                    ret.append("_").append(this.service);
                    if (this.host != null && this.host.length() > 0) {
                        ret.append("_").append(this.host);
                    }
                }
            }
        }
        return ret.toString();
    }

    public String getSystem() {
        return this.system;
    }

    public String getApp() {
        return this.app;
    }

    public String getService() {
        return this.service;
    }

    public String getHost() {
        return this.host;
    }

    private static boolean stringEquals(String a, String b) {
        return a == b || a != null && b != null && a.equals(b);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.app == null ? 0 : this.app.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
        result = 31 * result + (this.system == null ? 0 : this.system.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ApplicationEnvironment)) {
            return false;
        }
        ApplicationEnvironment anotherEnvironment = (ApplicationEnvironment)o;
        return ApplicationEnvironment.stringEquals(this.system, anotherEnvironment.system) && ApplicationEnvironment.stringEquals(this.app, anotherEnvironment.app) && ApplicationEnvironment.stringEquals(this.host, anotherEnvironment.host) && ApplicationEnvironment.stringEquals(this.service, anotherEnvironment.service);
    }

    public static class Builder {
        private String system = "";
        private String app = "";
        private String service = "";
        private String host = "";

        public Builder system(String value) {
            this.system = value;
            return this;
        }

        public Builder app(String value) {
            this.app = value;
            return this;
        }

        public Builder service(String value) {
            this.service = value;
            return this;
        }

        public Builder host(String value) {
            this.host = value;
            return this;
        }

        public ApplicationEnvironment build() {
            return new ApplicationEnvironment(this);
        }
    }
}

