/*
 * Decompiled with CFR 0.152.
 */
package org.configureme.parser.properties;

import net.anotheria.util.StringUtils;
import org.configureme.Environment;
import org.configureme.environments.DynamicEnvironment;
import org.configureme.parser.ConfigurationParser;
import org.configureme.parser.ConfigurationParserException;
import org.configureme.parser.ParsedConfiguration;
import org.configureme.parser.PlainParsedAttribute;

public class PropertiesParser
implements ConfigurationParser {
    @Override
    public ParsedConfiguration parseConfiguration(String name, String content) throws ConfigurationParserException {
        content = StringUtils.removeBashComments((String)content);
        String[] lines = StringUtils.tokenize((String)content, (char)'\n');
        ParsedConfiguration configuration = new ParsedConfiguration(name);
        for (String line : lines) {
            if (line == null || line.trim().length() == 0) continue;
            String[] tokensQL = StringUtils.tokenize((String)line, (char)'=');
            if (tokensQL.length != 2) {
                throw new IllegalArgumentException("Unparseable content, can't find = in line: " + line);
            }
            String propertyNameLine = tokensQL[0];
            String[] tokensDot = StringUtils.tokenize((String)propertyNameLine, (char)'.');
            if (tokensDot.length == 0) {
                throw new IllegalArgumentException("Unparseable content, can't find property name in line: " + line);
            }
            DynamicEnvironment env = new DynamicEnvironment();
            String propertyName = tokensDot[tokensDot.length - 1];
            String propertyValue = tokensQL[1];
            for (int i = 0; i < tokensDot.length - 1; ++i) {
                env.add(tokensDot[i]);
            }
            PlainParsedAttribute pa = new PlainParsedAttribute(propertyName, (Environment)env, propertyValue);
            configuration.addAttribute(pa);
        }
        return configuration;
    }
}

