/*
 * Decompiled with CFR 0.152.
 */
package org.configureme.repository;

import org.configureme.Environment;
import org.configureme.GlobalEnvironment;
import org.configureme.repository.AttributeValue;
import org.configureme.repository.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Attribute {
    private static Logger log = LoggerFactory.getLogger(Attribute.class);
    private String name;
    private AttributeValue attributeValue;

    public Attribute(String aName) {
        this.name = aName;
        this.attributeValue = new AttributeValue();
    }

    public Value getValue() {
        return this.getValue(GlobalEnvironment.INSTANCE);
    }

    public Value getValue(Environment in) {
        log.debug("looking up value for " + this.name + " in " + in);
        return this.attributeValue.get(in);
    }

    public String getName() {
        return this.name;
    }

    public void addValue(Value value, Environment in) {
        this.attributeValue.set(value, in);
    }

    public String toString() {
        return this.getName() + "=" + this.attributeValue;
    }
}

