/*
 * Decompiled with CFR 0.152.
 */
package org.configureme.repository;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.configureme.Configuration;
import org.configureme.Environment;
import org.configureme.GlobalEnvironment;
import org.configureme.repository.Artefact;
import org.configureme.repository.ConfigurationImpl;
import org.configureme.repository.Value;
import org.configureme.sources.ConfigurationSource;
import org.configureme.sources.ConfigurationSourceKey;
import org.configureme.sources.ConfigurationSourceListener;

public enum ConfigurationRepository implements ConfigurationSourceListener
{
    INSTANCE;

    private Map<String, Artefact> artefacts = new ConcurrentHashMap<String, Artefact>();

    public Artefact createArtefact(String name) {
        Artefact old = this.artefacts.get(name);
        if (old != null) {
            throw new IllegalArgumentException("Artefact '" + name + "' already exists: " + old);
        }
        Artefact a = new Artefact(name);
        this.artefacts.put(a.getName(), a);
        return a;
    }

    public void updateArtefact(Artefact toUpdate) {
        Artefact old = this.artefacts.get(toUpdate.getName());
        if (old == null) {
            throw new IllegalArgumentException("Artefact = " + toUpdate + " doesn't exists.");
        }
        this.artefacts.put(toUpdate.getName(), toUpdate);
    }

    public Artefact getArtefact(String name) {
        return this.artefacts.get(name);
    }

    public boolean hasConfiguration(String name) {
        return this.getArtefact(name) != null;
    }

    public Configuration getConfiguration(String name, Environment environment) {
        Artefact a;
        if (environment == null) {
            environment = GlobalEnvironment.INSTANCE;
        }
        if ((a = this.getArtefact(name)) == null) {
            throw new IllegalArgumentException("No such artefact: " + name);
        }
        ConfigurationImpl configurationImpl = new ConfigurationImpl(a.getName());
        List<String> attributeNames = a.getAttributeNames();
        configurationImpl.clearExternalConfigurations();
        for (ConfigurationSourceKey include : a.getExternalConfigurations()) {
            configurationImpl.addExternalConfiguration(include);
        }
        for (String attributeName : attributeNames) {
            Value attributeValue = a.getAttribute(attributeName).getValue(environment);
            if (attributeValue == null) continue;
            configurationImpl.setAttribute(attributeName, attributeValue);
        }
        return configurationImpl;
    }

    @Override
    public void configurationSourceUpdated(ConfigurationSource target) {
        this.artefacts.remove(target.getKey().getName());
    }

    public void resetForUnitTests() {
        this.artefacts.clear();
    }
}

