/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.generator;

import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import net.anotheria.util.StringUtils;
import org.distributeme.annotation.ConcurrencyControlClientSideLimit;
import org.distributeme.annotation.ConcurrencyControlLimit;
import org.distributeme.annotation.ConcurrencyControlServerSideLimit;
import org.distributeme.annotation.Route;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.Defaults;
import org.distributeme.core.interceptor.InterceptionPhase;
import org.distributeme.core.routing.Router;
import org.distributeme.generator.TranslatedAnnotation;

public class AbstractGenerator {
    private PrintWriter writer;
    private final ProcessingEnvironment environment;
    private static AtomicInteger ccOrders = new AtomicInteger();
    private static AtomicInteger routerOrders = new AtomicInteger();
    public static final String CRLF = "\n";
    private int ident = 0;
    private static char[] toRemove = new char[]{'.', '[', ']', '<', '>'};

    public AbstractGenerator(ProcessingEnvironment environment) {
        this.environment = environment;
    }

    protected void setWriter(Writer aWriter) {
        this.writer = new PrintWriter(aWriter);
        this.resetIdent();
    }

    protected Writer getWriter() {
        return this.writer;
    }

    protected static String getRemoteInterfaceName(TypeElement type) {
        return "Remote" + type.getSimpleName().toString();
    }

    protected static String getAsynchInterfaceName(TypeElement type) {
        return "Asynch" + type.getSimpleName().toString();
    }

    protected static String getStubName(TypeElement type) {
        return "Remote" + type.getSimpleName().toString() + "Stub";
    }

    protected static String getJaxRsStubName(TypeElement type) {
        return type.getSimpleName().toString() + "JaxRsStub";
    }

    protected static String getAsynchStubName(TypeElement type) {
        return "Asynch" + type.getSimpleName().toString() + "Stub";
    }

    public static final String getDefaultImplFactoryName(TypeElement type) {
        return type.getQualifiedName() + "Factory";
    }

    protected static String getSkeletonName(TypeElement type) {
        return "Remote" + type.getSimpleName().toString() + "Skeleton";
    }

    protected static String getResourceName(TypeElement type) {
        return type.getSimpleName().toString() + "Resource";
    }

    protected static String getConstantsName(TypeElement type) {
        return type.getSimpleName().toString() + "Constants";
    }

    protected static String getFactoryName(TypeElement type) {
        return "Remote" + type.getSimpleName().toString() + "Factory";
    }

    protected static String getAsynchFactoryName(TypeElement type) {
        return "Asynch" + type.getSimpleName().toString() + "Factory";
    }

    protected static String getServerName(TypeElement type) {
        String name = type.getSimpleName().toString().toString();
        return AbstractGenerator.getServerName(name);
    }

    protected static String getFullyQualifiedServerName(String interfaceName) {
        int indexOfDot = interfaceName.lastIndexOf(46);
        String packageName = "";
        if (indexOfDot != -1) {
            packageName = interfaceName.substring(0, indexOfDot);
            interfaceName = interfaceName.substring(indexOfDot + 1);
        }
        packageName = packageName + ".generated.";
        if (interfaceName.endsWith("Service")) {
            interfaceName = interfaceName.substring(0, interfaceName.length() - "Service".length());
        }
        return packageName + interfaceName + "Server";
    }

    protected static String getServerName(String interfaceName) {
        int indexOfDot = interfaceName.lastIndexOf(46);
        if (indexOfDot != -1) {
            interfaceName = interfaceName.substring(indexOfDot + 1);
        }
        if (interfaceName.endsWith("Service")) {
            interfaceName = interfaceName.substring(0, interfaceName.length() - "Service".length());
        }
        return interfaceName + "Server";
    }

    protected static String getInterfaceName(TypeElement type) {
        return type.getSimpleName().toString().toString();
    }

    protected PackageElement getPackageOf(Element type) {
        Elements elements = this.environment.getElementUtils();
        return elements.getPackageOf(type);
    }

    protected String getPackageName(TypeElement element) {
        return this.getPackageOf(element).getQualifiedName() + ".generated";
    }

    protected void writePackage(TypeElement type) {
        this.writeString("package " + this.getPackageName(type) + ";");
    }

    protected void writeAnalyzerComments(TypeElement type) {
        this.writeString("//CHECKSTYLE:OFF");
    }

    protected String quote(String s) {
        return "\"" + s + "\"";
    }

    protected String quote(Object o) {
        return "\"" + o + "\"";
    }

    protected String quote(StringBuilder s) {
        return "\"" + s.toString() + "\"";
    }

    protected String quote(int a) {
        return this.quote("" + a);
    }

    protected void writeIncreasedString(String s) {
        this.increaseIdent();
        this.writeString(s);
        this.decreaseIdent();
    }

    protected void writeIncreasedStatement(String s) {
        this.writeIncreasedString(s + ";");
    }

    protected void writeString(String s) {
        StringBuilder ret = this.getIdent();
        ret.append(s).append(CRLF);
        this.writer.write(ret.toString());
    }

    protected void openTry() {
        this.writeString("try{");
        this.increaseIdent();
    }

    protected void openFun(String s) {
        if (!s.endsWith("{")) {
            s = s + " {";
        }
        this.writeString(s);
        this.increaseIdent();
    }

    protected void writeStatement(String s) {
        StringBuilder ret = this.getIdent();
        ret.append(s).append(";").append(CRLF);
        this.writer.write(ret.toString());
    }

    private StringBuilder getIdent() {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < this.ident; ++i) {
            ret.append("\t");
        }
        return ret;
    }

    protected void increaseIdent() {
        ++this.ident;
    }

    protected void decreaseIdent() {
        --this.ident;
        if (this.ident < 0) {
            this.ident = 0;
        }
    }

    protected void resetIdent() {
        this.ident = 0;
    }

    public void emptyline() {
        this.writer.write(CRLF);
    }

    protected void writeImport(String imp) {
        this.writeString("import " + imp + ";");
    }

    protected void writeImport(Class<?> clazz) {
        this.writeImport(clazz.getName());
    }

    protected void writeImport(String packagename, String classname) {
        this.writeString("import " + packagename + "." + classname + ";");
    }

    protected void closeBlock() {
        this.decreaseIdent();
        this.writeString("}");
    }

    protected void closeBlockWithoutIdent() {
        this.writeString("}");
    }

    protected void closeBlock(String comment) {
        this.decreaseIdent();
        this.writeString("} //..." + comment);
    }

    protected void closeBlockWithoutIdent(String comment) {
        this.writeString("} //..." + comment);
    }

    protected void appendMark(int markNumber) {
    }

    protected void writeCommentLine(String commentline) {
        String[] tokens = StringUtils.tokenize((String)commentline, (char)'\n');
        if (tokens.length != 1) {
            this.writeComment(commentline);
        } else {
            this.writeString("// " + commentline);
        }
    }

    protected void writeComment(String commentline) {
        String[] tokens = StringUtils.tokenize((String)commentline, (char)'\n');
        this.writeString("/**");
        for (int i = 0; i < tokens.length; ++i) {
            this.writeString(" * " + tokens[i]);
        }
        this.writeString(" */");
    }

    protected void startClassBody() {
        this.ident = 1;
    }

    private String getFormalTypeDeclaration(ExecutableElement method) {
        StringBuilder formalTypeDeclaration = new StringBuilder("");
        List<? extends TypeParameterElement> formalTypeParameters = method.getTypeParameters();
        for (TypeParameterElement typeParameterElement : formalTypeParameters) {
            if (formalTypeDeclaration.length() > 0) {
                formalTypeDeclaration.append(", ");
            }
            formalTypeDeclaration.append(typeParameterElement.toString());
            List<? extends TypeMirror> bounds = typeParameterElement.getBounds();
            if (!bounds.isEmpty()) {
                formalTypeDeclaration.append(" extends ");
            }
            Iterator<? extends TypeMirror> it = bounds.iterator();
            while (it.hasNext()) {
                formalTypeDeclaration.append(it.next().toString());
                if (!it.hasNext()) continue;
                formalTypeDeclaration.append(" & ");
            }
        }
        String ret = formalTypeDeclaration.length() > 0 ? "<" + formalTypeDeclaration.toString() + ">" : formalTypeDeclaration.toString();
        return ret;
    }

    protected String getMethodDeclaration(ExecutableElement method) {
        StringBuilder methodDecl = new StringBuilder();
        methodDecl.append(this.getFormalTypeDeclaration(method)).append("List<?>").append(" ");
        methodDecl.append(method.getSimpleName()).append("(");
        List<? extends VariableElement> parameters = method.getParameters();
        boolean first = true;
        for (VariableElement variableElement : parameters) {
            if (!first) {
                methodDecl.append(", ");
            }
            methodDecl.append(variableElement.asType().toString() + " " + variableElement.getSimpleName());
            first = false;
        }
        methodDecl.append(")");
        return methodDecl.toString();
    }

    protected String getInterfaceMethodDeclaration(ExecutableElement method, boolean includeTransportableContext) {
        StringBuilder methodDecl = new StringBuilder();
        methodDecl.append(this.getFormalTypeDeclaration(method)).append("List").append(" ");
        methodDecl.append(method.getSimpleName()).append("(");
        List<? extends VariableElement> parameters = method.getParameters();
        boolean first = true;
        for (VariableElement variableElement : parameters) {
            if (!first) {
                methodDecl.append(", ");
            }
            methodDecl.append(variableElement.asType().toString() + " " + variableElement.getSimpleName());
            first = false;
        }
        if (includeTransportableContext) {
            methodDecl.append((first ? "" : ", ") + "Map<?,?> __transportableCallContext");
        }
        methodDecl.append(")");
        return methodDecl.toString();
    }

    protected String getAsynchInterfaceMethodDeclaration(ExecutableElement method) {
        StringBuilder methodDecl = new StringBuilder();
        methodDecl.append(this.getFormalTypeDeclaration(method)).append("void").append(" ");
        methodDecl.append(this.getAsynchMethodName(method)).append("(");
        List<? extends VariableElement> parameters = method.getParameters();
        boolean first = true;
        for (VariableElement variableElement : parameters) {
            if (!first) {
                methodDecl.append(", ");
            }
            methodDecl.append(variableElement.asType().toString() + " " + variableElement.getSimpleName());
            first = false;
        }
        methodDecl.append((first ? "" : ", ") + "CallBackHandler ... diMeCallBackHandlers");
        methodDecl.append(")");
        return methodDecl.toString();
    }

    protected String getResourceSkeletonMethodDeclaration(ExecutableElement method) {
        StringBuilder Element2 = new StringBuilder();
        Element2.append(this.getInterfaceMethodDeclaration(method, false));
        if (method.getThrownTypes().size() > 0) {
            StringBuilder exceptions = new StringBuilder();
            for (TypeMirror typeMirror : method.getThrownTypes()) {
                if (exceptions.length() > 0) {
                    exceptions.append(", ");
                }
                exceptions.append(typeMirror.toString());
            }
            Element2.append(" throws ").append((CharSequence)exceptions);
        }
        return Element2.toString();
    }

    protected String getSkeletonMethodDeclaration(ExecutableElement method) {
        StringBuilder Element2 = new StringBuilder();
        Element2.append(this.getInterfaceMethodDeclaration(method, true));
        if (method.getThrownTypes().size() > 0) {
            StringBuilder exceptions = new StringBuilder();
            for (TypeMirror typeMirror : method.getThrownTypes()) {
                if (exceptions.length() > 0) {
                    exceptions.append(", ");
                }
                exceptions.append(typeMirror.toString());
            }
            Element2.append(" throws ").append((CharSequence)exceptions);
        }
        return Element2.toString();
    }

    protected String getStubParametersDeclaration(ExecutableElement method) {
        return this.getStubParametersDeclaration(method, false);
    }

    protected String getStubParametersDeclaration(ExecutableElement method, boolean declareFinal) {
        StringBuilder ret = new StringBuilder();
        List<? extends VariableElement> parameters = method.getParameters();
        boolean first = true;
        for (VariableElement variableElement : parameters) {
            if (!first) {
                ret.append(", ");
            }
            ret.append((declareFinal ? "final " : "") + variableElement.asType().toString() + " " + variableElement.getSimpleName());
            first = false;
        }
        return ret.toString();
    }

    protected String getStubParametersCall(ExecutableElement method) {
        StringBuilder ret = new StringBuilder();
        List<? extends VariableElement> parameters = method.getParameters();
        boolean first = true;
        for (VariableElement variableElement : parameters) {
            if (!first) {
                ret.append(", ");
            }
            ret.append(variableElement.getSimpleName());
            first = false;
        }
        return ret.toString();
    }

    protected String getStubMethodDeclaration(ExecutableElement method) {
        StringBuilder methodDecl = new StringBuilder();
        methodDecl.append(this.getFormalTypeDeclaration(method)).append(method.getReturnType()).append(" ");
        methodDecl.append(method.getSimpleName()).append("(");
        methodDecl.append(this.getStubParametersDeclaration(method));
        methodDecl.append(")");
        if (method.getThrownTypes().size() > 0) {
            StringBuilder exceptions = new StringBuilder();
            for (TypeMirror typeMirror : method.getThrownTypes()) {
                if (exceptions.length() > 0) {
                    exceptions.append(", ");
                }
                exceptions.append(typeMirror.toString());
            }
            methodDecl.append(" throws " + exceptions.toString());
        }
        return methodDecl.toString();
    }

    protected String getStubAsynchMethodDeclaration(ExecutableElement method) {
        StringBuilder methodDecl = new StringBuilder();
        methodDecl.append(this.getFormalTypeDeclaration(method)).append(" void ");
        methodDecl.append(this.getAsynchMethodName(method)).append("(");
        String parameters = this.getStubParametersDeclaration(method, true);
        methodDecl.append(parameters);
        if (parameters.length() > 0) {
            methodDecl.append(", ");
        }
        methodDecl.append("final CallBackHandler... diMeHandlers");
        methodDecl.append(")");
        return methodDecl.toString();
    }

    protected String getAsynchMethodName(ExecutableElement method) {
        return "asynch" + StringUtils.capitalize((String)method.getSimpleName().toString());
    }

    protected String getInternalStubMethodDeclaration(ExecutableElement method) {
        StringBuilder methodDecl = new StringBuilder();
        methodDecl.append(this.getFormalTypeDeclaration(method)).append(method.getReturnType()).append(" ");
        methodDecl.append(method.getSimpleName()).append("(");
        String parameters = this.getStubParametersDeclaration(method);
        methodDecl.append(parameters);
        if (parameters.length() > 0) {
            methodDecl.append(", ");
        }
        methodDecl.append(ClientSideCallContext.class.getName() + " diMeCallContext");
        methodDecl.append(")");
        if (method.getThrownTypes().size() > 0) {
            StringBuilder exceptions = new StringBuilder();
            for (TypeMirror typeMirror : method.getThrownTypes()) {
                if (exceptions.length() > 0) {
                    exceptions.append(", ");
                }
                exceptions.append(typeMirror.toString());
            }
            methodDecl.append(" throws " + exceptions.toString());
        }
        return methodDecl.toString();
    }

    protected Collection<? extends ExecutableElement> getAllDeclaredMethods(TypeElement type) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(type.getEnclosedElements());
        Types types = this.environment.getTypeUtils();
        List<? extends TypeMirror> superinterfaces = type.getInterfaces();
        for (TypeMirror typeMirror : superinterfaces) {
            Element element = types.asElement(typeMirror);
            if (!(element instanceof TypeElement)) continue;
            methods.addAll(this.getAllDeclaredMethods((TypeElement)element));
        }
        return methods;
    }

    protected List<TypeElement> getAllDeclaredTypes(TypeElement type) {
        ArrayList<TypeElement> typesList = new ArrayList<TypeElement>();
        Types types = this.environment.getTypeUtils();
        typesList.add(type);
        List<? extends TypeMirror> superinterfaces = type.getInterfaces();
        for (TypeMirror typeMirror : superinterfaces) {
            Element element = types.asElement(typeMirror);
            typesList.addAll(this.getAllDeclaredTypes((TypeElement)element));
        }
        return typesList;
    }

    protected String getImplementedInterfacesAsString(TypeElement type) {
        List<TypeElement> implementedInterfaces = this.getAllDeclaredTypes(type);
        StringBuilder interfaceAsString = new StringBuilder();
        for (TypeElement in : implementedInterfaces) {
            if (interfaceAsString.length() > 0) {
                interfaceAsString.append(", ");
            }
            interfaceAsString.append(in.getQualifiedName()).append(".class");
        }
        return interfaceAsString.toString();
    }

    protected AnnotationMirror findMirror(Element type, Class<? extends Annotation> ann) {
        List<? extends AnnotationMirror> mirros = type.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirros) {
            Element Element2 = annotationMirror.getAnnotationType().asElement();
            if (!Element2.getSimpleName().toString().equals(ann.getSimpleName())) continue;
            return annotationMirror;
        }
        return null;
    }

    protected List<AnnotationMirror> findMirrors(Element type, Class<? extends Annotation> ann) {
        ArrayList<AnnotationMirror> ret = new ArrayList<AnnotationMirror>();
        List<? extends AnnotationMirror> mirrors = type.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            Element Element2 = annotationMirror.getAnnotationType().asElement();
            if (!Element2.getSimpleName().equals(ann.getSimpleName())) continue;
            ret.add(annotationMirror);
        }
        return ret;
    }

    protected ExecutableElement findMirrorMethod(AnnotationMirror mirror, String methodName) {
        Element executableElement = mirror.getAnnotationType().asElement();
        List<ExecutableElement> methods = ElementFilter.methodsIn(executableElement.getEnclosedElements());
        for (ExecutableElement element : methods) {
            if (!element.getSimpleName().toString().equals(methodName)) continue;
            return element;
        }
        return null;
    }

    protected AnnotationValue findLogWriterValue(AnnotationMirror mirror) {
        return this.findMethodValue(mirror, "logWriterClazz");
    }

    protected AnnotationValue findRouterClassValue(AnnotationMirror mirror) {
        return this.findMethodValue(mirror, "routerClass");
    }

    protected AnnotationValue findRouterParameterValue(AnnotationMirror mirror) {
        return this.findMethodValue(mirror, "routerParameter");
    }

    protected AnnotationValue findRouterConfigurationName(AnnotationMirror mirror) {
        return this.findMethodValue(mirror, "configurationName");
    }

    protected AnnotationValue findMethodValue(AnnotationMirror mirror, String methodName) {
        ExecutableElement method = this.findMirrorMethod(mirror, methodName);
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = mirror.getElementValues();
        AnnotationValue mirrorMethodValue = values.get(method);
        return mirrorMethodValue;
    }

    protected TranslatedCCAnnotation findConcurrencyControlAnnotation(Element type) {
        Annotation ann = type.getAnnotation(ConcurrencyControlServerSideLimit.class);
        if (ann != null) {
            String configName = ann.configurationName();
            if (configName != null && configName.length() > 0) {
                return new TranslatedCCAnnotation("org.distributeme.core.concurrencycontrol.ConfigurationBasedConcurrencyControlStrategy", configName);
            }
            return new TranslatedCCAnnotation("org.distributeme.core.concurrencycontrol.ConstantBasedConcurrencyControlStrategy", "0," + ann.value());
        }
        ann = type.getAnnotation(ConcurrencyControlClientSideLimit.class);
        if (ann != null) {
            String configName = ((ConcurrencyControlClientSideLimit)ann).configurationName();
            if (configName != null && configName.length() > 0) {
                return new TranslatedCCAnnotation("org.distributeme.core.concurrencycontrol.ConfigurationBasedConcurrencyControlStrategy", configName);
            }
            return new TranslatedCCAnnotation("org.distributeme.core.concurrencycontrol.ConstantBasedConcurrencyControlStrategy", "" + ((ConcurrencyControlClientSideLimit)ann).value() + ",0");
        }
        ann = type.getAnnotation(ConcurrencyControlLimit.class);
        if (ann != null) {
            String configName = ((ConcurrencyControlLimit)ann).configurationName();
            if (configName != null && configName.length() > 0) {
                return new TranslatedCCAnnotation("org.distributeme.core.concurrencycontrol.ConfigurationBasedConcurrencyControlStrategy", configName);
            }
            return new TranslatedCCAnnotation("org.distributeme.core.concurrencycontrol.ConstantBasedConcurrencyControlStrategy", "" + ((ConcurrencyControlLimit)ann).client() + "," + ((ConcurrencyControlLimit)ann).server());
        }
        return null;
    }

    protected List<TranslatedRouterAnnotation> writeRouterDeclarations(TypeElement type) {
        ArrayList<TranslatedRouterAnnotation> ret = new ArrayList<TranslatedRouterAnnotation>();
        Collection<? extends ExecutableElement> methods = this.getAllDeclaredMethods(type);
        this.writeCommentLine("ROUTER DECL V2");
        AnnotationMirror clazzWideRoute = this.findMirror(type, Route.class);
        if (clazzWideRoute != null) {
            this.writeCommentLine("Class wide router ");
            AnnotationValue configurationNameValue = this.findRouterConfigurationName(clazzWideRoute);
            TranslatedRouterAnnotation translatedRouterAnnotation = new TranslatedRouterAnnotation("" + this.findRouterClassValue(clazzWideRoute).getValue(), "" + this.findRouterParameterValue(clazzWideRoute).getValue(), configurationNameValue == null ? "" : "" + configurationNameValue.getValue());
            this.writeStatement("private final " + Router.class.getName() + " clazzWideRouter = createRouterInstance" + translatedRouterAnnotation.getOrder() + "()");
            ret.add(translatedRouterAnnotation);
        } else {
            this.writeCommentLine("No class-wide-router set, skipping.");
        }
        this.emptyline();
        this.writeCommentLine("Method wide routers if applicable ");
        for (ExecutableElement executableElement : methods) {
            AnnotationMirror methodRoute = this.findMirror(executableElement, Route.class);
            if (methodRoute == null) continue;
            AnnotationValue routerParameterValue = this.findRouterParameterValue(methodRoute);
            AnnotationValue configurationNameValue = this.findRouterConfigurationName(methodRoute);
            TranslatedRouterAnnotation tra = new TranslatedRouterAnnotation("" + this.findRouterClassValue(methodRoute).getValue(), routerParameterValue == null ? "" : "" + routerParameterValue.getValue(), configurationNameValue == null ? "" : "" + configurationNameValue.getValue());
            this.writeStatement("private final " + Router.class.getName() + " " + this.getMethodRouterName(executableElement) + " = createRouterInstance" + tra.getOrder() + "()");
            ret.add(tra);
        }
        this.writeCommentLine("Method wide routers END ");
        this.emptyline();
        this.writeCommentLine("ROUTER DECL V2 end");
        return ret;
    }

    protected List<TranslatedCCAnnotation> writeConcurrencyControlDeclarations(TypeElement type) {
        ArrayList<TranslatedCCAnnotation> ret = new ArrayList<TranslatedCCAnnotation>();
        Collection<? extends ExecutableElement> methods = this.getAllDeclaredMethods(type);
        this.writeCommentLine("CONCURRENCY CONTROL");
        this.writeCommentLine("Class wide concurrency control strategy ");
        TranslatedCCAnnotation clazzWideCCStrategyAnnotation = this.findConcurrencyControlAnnotation(type);
        if (clazzWideCCStrategyAnnotation != null) {
            this.writeStatement("private ConcurrencyControlStrategy clazzWideCCStrategy = createConcurrencyControlStrategy" + clazzWideCCStrategyAnnotation.getOrder() + "()");
            ret.add(clazzWideCCStrategyAnnotation);
        } else {
            this.writeStatement("private ConcurrencyControlStrategy clazzWideCCStrategy = " + Defaults.class.getSimpleName() + ".getDefaultConcurrencyControlStrategy()");
        }
        this.emptyline();
        for (ExecutableElement executableElement : methods) {
            TranslatedCCAnnotation methodCCStrategyAnnotation = this.findConcurrencyControlAnnotation(executableElement);
            if (methodCCStrategyAnnotation != null) {
                this.writeStatement("private ConcurrencyControlStrategy " + this.getCCStrategyVariableName(executableElement) + " = createConcurrencyControlStrategy" + methodCCStrategyAnnotation.getOrder() + "()");
                ret.add(methodCCStrategyAnnotation);
                continue;
            }
            this.writeStatement("private ConcurrencyControlStrategy " + this.getCCStrategyVariableName(executableElement) + " = clazzWideCCStrategy");
        }
        this.writeCommentLine("CONCURRENCY CONTROL end");
        this.emptyline();
        return ret;
    }

    private StringBuilder getParameterizedVariableName(ExecutableElement Element2) {
        StringBuilder ret = new StringBuilder();
        for (VariableElement variableElement : Element2.getParameters()) {
            ret.append('_');
            ret.append(this.stripStrategyVariableName(variableElement.asType().toString()));
            ret.append(variableElement.getSimpleName());
        }
        return ret;
    }

    protected String getFailingStrategyVariableName(ExecutableElement Element2) {
        StringBuilder ret = new StringBuilder(Element2.getSimpleName()).append("FailingStrategy");
        ret.append((CharSequence)this.getParameterizedVariableName(Element2));
        return ret.toString();
    }

    protected String getCCStrategyVariableName(ExecutableElement Element2) {
        StringBuilder ret = new StringBuilder(Element2.getSimpleName()).append("CCStrategy");
        ret.append((CharSequence)this.getParameterizedVariableName(Element2));
        return ret.toString();
    }

    private String stripStrategyVariableName(String toStrip) {
        String ret = StringUtils.removeTag((String)toStrip, (String)"");
        ret = StringUtils.removeChars((String)ret, (char[])toRemove);
        return ret;
    }

    protected void writeConcurrencyControlCreationMethod(TranslatedCCAnnotation cca) {
        this.writeString("private ConcurrencyControlStrategy createConcurrencyControlStrategy" + cca.getOrder() + "(){");
        this.increaseIdent();
        this.writeStatement("ConcurrencyControlStrategy strat = new " + cca.getStrategyClass() + "()");
        this.writeStatement("strat.customize(" + this.quote(cca.getParameter()) + ")");
        this.writeStatement("return strat");
        this.closeBlock();
    }

    protected void writeRouterCreationMethod(String serviceIdCall, TranslatedRouterAnnotation tra) {
        this.writeString("private " + Router.class.getName() + " createRouterInstance" + tra.getOrder() + "(){");
        this.increaseIdent();
        this.writeStatement(Router.class.getName() + " router = new " + tra.getStrategyClass() + "()");
        if (tra.getConfigurationName() != null && tra.getConfigurationName().length() > 0) {
            this.writeStatement("((org.distributeme.core.routing.ConfigurableRouter)router).setConfigurationName(" + serviceIdCall + ", " + this.quote(tra.getConfigurationName()) + ")");
        } else {
            this.writeStatement("router.customize(" + serviceIdCall + ", " + this.quote(tra.getParameter()) + ")");
        }
        this.writeStatement("return router");
        this.closeBlock();
    }

    protected String interceptionPhaseToMethod(InterceptionPhase phase) {
        switch (phase) {
            case BEFORE_SERVANT_CALL: {
                return "beforeServantCall";
            }
            case BEFORE_SERVICE_CALL: {
                return "beforeServiceCall";
            }
            case AFTER_SERVICE_CALL: {
                return "afterServiceCall";
            }
            case AFTER_SERVANT_CALL: {
                return "afterServantCall";
            }
        }
        throw new IllegalArgumentException("Unsupported interception phase");
    }

    protected boolean isVoidReturn(ExecutableElement decl) {
        return decl.getReturnType().toString().equals("void");
    }

    protected String getMethodRouterName(ExecutableElement Element2) {
        return Element2.getSimpleName() + "Router";
    }

    protected static class TranslatedRouterAnnotation
    extends TranslatedAnnotation {
        public TranslatedRouterAnnotation(String aStrategyClass, String aParameter, String configurationName) {
            super(aStrategyClass, aParameter, routerOrders.incrementAndGet());
            this.setConfigurationName(configurationName);
        }
    }

    protected static class TranslatedCCAnnotation
    extends TranslatedAnnotation {
        public TranslatedCCAnnotation(String aStrategyClass, String aParameter) {
            super(aStrategyClass, aParameter, ccOrders.incrementAndGet());
        }
    }
}

