/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.generator;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import org.distributeme.annotation.DistributeMe;
import org.distributeme.core.asynch.CallBackHandler;
import org.distributeme.generator.AbstractGenerator;
import org.distributeme.generator.Generator;

public class AsynchInterfaceGenerator
extends AbstractGenerator
implements Generator {
    public AsynchInterfaceGenerator(ProcessingEnvironment environment) {
        super(environment);
    }

    @Override
    public void generate(TypeElement type, Filer filer, Map<String, String> options) throws IOException {
        DistributeMe typeAnnotation = type.getAnnotation(DistributeMe.class);
        if (!typeAnnotation.asynchSupport()) {
            return;
        }
        JavaFileObject sourceFile = filer.createSourceFile(this.getPackageName(type) + "." + AsynchInterfaceGenerator.getAsynchInterfaceName(type), new Element[0]);
        PrintWriter writer = new PrintWriter(sourceFile.openWriter());
        this.setWriter(writer);
        this.writePackage(type);
        this.writeAnalyzerComments(type);
        this.writeImport(CallBackHandler.class);
        this.emptyline();
        this.writeString("public interface " + AsynchInterfaceGenerator.getAsynchInterfaceName(type) + " extends " + type.getQualifiedName() + ", org.distributeme.core.asynch.AsynchStub{");
        this.increaseIdent();
        Collection<? extends ExecutableElement> methods = this.getAllDeclaredMethods(type);
        for (ExecutableElement executableElement : methods) {
            String methodDecl = this.getAsynchInterfaceMethodDeclaration(executableElement);
            this.writeStatement(methodDecl);
            this.emptyline();
        }
        this.closeBlock();
        writer.flush();
        writer.close();
    }
}

