/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.generator;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;
import org.distributeme.annotation.DistributeMe;
import org.distributeme.core.Defaults;
import org.distributeme.core.ServiceLocator;
import org.distributeme.core.asynch.CallBackHandler;
import org.distributeme.core.asynch.CallTimeoutedException;
import org.distributeme.core.asynch.SingleCallHandler;
import org.distributeme.core.exception.DistributemeRuntimeException;
import org.distributeme.core.exception.NoConnectionToServerException;
import org.distributeme.core.exception.ServiceUnavailableException;
import org.distributeme.generator.AbstractStubGenerator;
import org.distributeme.generator.Generator;
import org.distributeme.generator.logwriter.LogWriter;
import org.distributeme.generator.logwriter.SysErrorLogWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchStubGenerator
extends AbstractStubGenerator
implements Generator {
    private static Logger log = LoggerFactory.getLogger(AsynchStubGenerator.class);

    public AsynchStubGenerator(ProcessingEnvironment environment) {
        super(environment);
    }

    @Override
    public void generate(TypeElement type, Filer filer, Map<String, String> options) throws IOException {
        DistributeMe typeAnnotation = type.getAnnotation(DistributeMe.class);
        if (!typeAnnotation.asynchSupport()) {
            return;
        }
        JavaFileObject sourceFile = filer.createSourceFile(this.getPackageName(type) + "." + AsynchStubGenerator.getAsynchStubName(type), new Element[0]);
        PrintWriter writer = new PrintWriter(sourceFile.openWriter());
        this.setWriter(writer);
        this.writePackage(type);
        this.writeAnalyzerComments(type);
        this.emptyline();
        this.writeImport(List.class);
        this.writeImport(ArrayList.class);
        this.writeImport(HashMap.class);
        this.writeImport(ConcurrentMap.class);
        this.writeImport(ConcurrentHashMap.class);
        this.writeImport(Logger.class);
        this.writeImport(type.getQualifiedName().toString());
        this.writeImport(InterruptedException.class);
        this.writeImport(DistributemeRuntimeException.class);
        this.writeImport(NoConnectionToServerException.class);
        this.writeImport(ServiceUnavailableException.class);
        this.writeImport(Defaults.class);
        this.writeImport(CallBackHandler.class);
        this.writeImport(SingleCallHandler.class);
        this.writeImport(CallTimeoutedException.class);
        this.writeImport(IllegalStateException.class);
        this.writeImport(ServiceLocator.class);
        this.writeImport(ExecutorService.class);
        this.writeImport(Executors.class);
        this.writeImport(AtomicLong.class);
        this.emptyline();
        this.writeString("public class " + AsynchStubGenerator.getAsynchStubName(type) + " implements " + AsynchStubGenerator.getAsynchInterfaceName(type) + "{");
        this.increaseIdent();
        this.emptyline();
        LogWriter logWriter = null;
        try {
            AnnotationMirror logWriterMirror = this.findMirror(type, DistributeMe.class);
            AnnotationValue logWriterClazzValue = this.findLogWriterValue(logWriterMirror);
            String logWriterClazzName = null;
            logWriterClazzName = logWriterClazzValue == null ? SysErrorLogWriter.class.getName() : "" + logWriterClazzValue.getValue();
            logWriter = (LogWriter)Class.forName(logWriterClazzName).newInstance();
        }
        catch (Exception e) {
            log.warn("Still have this stupid exception...", (Throwable)e);
            logWriter = new SysErrorLogWriter();
        }
        String loggerInitialization = logWriter.createLoggerInitialization(AsynchStubGenerator.getStubName(type));
        if (loggerInitialization != null && loggerInitialization.length() > 0) {
            this.writeStatement(loggerInitialization);
        }
        this.emptyline();
        Collection<? extends ExecutableElement> methods = this.getAllDeclaredMethods(type);
        this.writeStatement("private final " + AsynchStubGenerator.getInterfaceName(type) + " diMeTarget");
        this.writeStatement("private final ExecutorService diMeExecutor");
        this.writeStatement("private final AtomicLong diMeRequestCounter = new AtomicLong()");
        this.emptyline();
        this.writeString("public " + AsynchStubGenerator.getAsynchStubName(type) + "(){");
        this.increaseIdent();
        this.writeStatement("this(ServiceLocator.getRemote(" + type.getSimpleName().toString() + ".class))");
        this.closeBlock();
        this.emptyline();
        this.emptyline();
        this.writeString("public " + AsynchStubGenerator.getAsynchStubName(type) + "(" + AsynchStubGenerator.getInterfaceName(type) + " aTarget){");
        this.increaseIdent();
        this.writeStatement("diMeTarget = aTarget");
        if (typeAnnotation.asynchExecutorPoolSize() == -1L) {
            this.writeStatement("diMeExecutor = Executors.newFixedThreadPool(Defaults.getAsynchExecutorPoolSize())");
        } else {
            this.writeStatement("diMeExecutor = Executors.newFixedThreadPool(" + typeAnnotation.asynchExecutorPoolSize() + ")");
        }
        this.closeBlock();
        this.emptyline();
        for (ExecutableElement executableElement : methods) {
            this.writeString("public " + this.getStubMethodDeclaration(executableElement) + "{");
            this.increaseIdent();
            this.writeStatement("SingleCallHandler diMeCallHandler = new SingleCallHandler()");
            String callParams = this.getStubParametersCall(executableElement);
            if (callParams.length() > 0) {
                callParams = callParams + ", ";
            }
            callParams = callParams + "diMeCallHandler";
            this.writeStatement(this.getAsynchMethodName(executableElement) + "(" + callParams + ")");
            this.writeString("try{");
            this.increaseIdent();
            if (typeAnnotation.asynchCallTimeout() == -1L) {
                this.writeStatement("diMeCallHandler.waitForResults()");
            } else {
                this.writeStatement("diMeCallHandler.waitForResults(" + typeAnnotation.asynchCallTimeout() + ")");
            }
            this.decreaseIdent();
            this.writeString("}catch(InterruptedException e){");
            this.increaseIdent();
            this.closeBlock();
            this.writeString("if (!diMeCallHandler.isFinished())");
            this.writeIncreasedStatement("throw new CallTimeoutedException()");
            if (this.isVoidReturn(executableElement)) {
                this.writeString("if (diMeCallHandler.isSuccess())");
                this.writeIncreasedStatement("return");
            } else {
                this.writeString("if (diMeCallHandler.isSuccess())");
                this.writeIncreasedStatement("return " + this.convertReturnValue(executableElement.getReturnType(), "diMeCallHandler.getReturnValue()"));
            }
            this.writeString("if (diMeCallHandler.isError()){");
            this.increaseIdent();
            this.writeStatement("Exception exceptionInMethod = diMeCallHandler.getReturnException()");
            this.writeString("if (exceptionInMethod instanceof RuntimeException)");
            this.writeIncreasedStatement("throw (RuntimeException)exceptionInMethod");
            if (executableElement.getThrownTypes().size() > 0) {
                for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
                    this.writeString("if (exceptionInMethod instanceof " + typeMirror.toString() + ")");
                    this.writeIncreasedStatement("throw (" + typeMirror.toString() + ")exceptionInMethod");
                }
            }
            this.writeStatement("throw new RuntimeException(" + this.quote("Shouldn't happen, unexpected exception of class ") + "+exceptionInMethod.getClass().getName()+" + this.quote(" thrown by method") + ", exceptionInMethod)");
            this.closeBlock("if isError");
            this.writeStatement("throw new IllegalStateException(" + this.quote("You can't be here ;-)") + ")");
            this.closeBlock(this.getStubMethodDeclaration(executableElement));
            this.emptyline();
            this.writeString("public " + this.getStubAsynchMethodDeclaration(executableElement) + "{");
            this.increaseIdent();
            this.writeString("diMeExecutor.execute(new Runnable() {");
            this.increaseIdent();
            this.writeString("@Override");
            this.writeString("public void run() {");
            this.increaseIdent();
            this.openTry();
            this.writeCommentLine("make the real call here");
            String call = "diMeTarget." + executableElement.getSimpleName() + "(" + this.getStubParametersCall(executableElement) + ")";
            if (!this.isVoidReturn(executableElement)) {
                call = executableElement.getReturnType() + " diMeReturnValue = " + call;
            }
            this.writeStatement(call);
            this.writeString("if (diMeHandlers!=null){");
            this.increaseIdent();
            this.writeString("for (CallBackHandler diMeHandler : diMeHandlers){");
            this.increaseIdent();
            this.openTry();
            this.writeStatement("diMeHandler.success(" + (!this.isVoidReturn(executableElement) ? "diMeReturnValue" : "null") + ")");
            this.decreaseIdent();
            this.writeString("}catch(Exception ignored){");
            this.writeCommentLine("add exception warn here");
            this.writeString("}");
            this.closeBlock("for");
            this.closeBlock("if");
            this.decreaseIdent();
            this.writeString("}catch(Exception e){");
            this.increaseIdent();
            this.writeString("if (diMeHandlers!=null){");
            this.increaseIdent();
            this.writeString("for (CallBackHandler diMeHandler : diMeHandlers){");
            this.increaseIdent();
            this.openTry();
            this.writeStatement("diMeHandler.error(e)");
            this.decreaseIdent();
            this.writeString("}catch(Exception ignored){");
            this.writeCommentLine("add exception warn here");
            this.writeString("}");
            this.closeBlock("for");
            this.closeBlock("if");
            this.closeBlock("catch");
            this.closeBlock();
            this.decreaseIdent();
            this.writeString("});");
            this.closeBlock("public " + this.getStubAsynchMethodDeclaration(executableElement));
            this.emptyline();
        }
        this.emptyline();
        this.writeString("public void shutdown(){");
        this.increaseIdent();
        this.writeStatement("diMeExecutor.shutdown()");
        this.closeBlock();
        this.closeBlock();
        writer.flush();
        writer.close();
    }
}

