/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.generator;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import net.anotheria.util.StringUtils;
import org.distributeme.annotation.CombinedService;
import org.distributeme.generator.AsynchFactoryGenerator;
import org.distributeme.generator.AsynchInterfaceGenerator;
import org.distributeme.generator.AsynchStubGenerator;
import org.distributeme.generator.ConstantsGenerator;
import org.distributeme.generator.Generator;
import org.distributeme.generator.RemoteFactoryGenerator;
import org.distributeme.generator.RemoteInterfaceGenerator;
import org.distributeme.generator.ServerGenerator;
import org.distributeme.generator.ServerScriptGenerator;
import org.distributeme.generator.SkeletonGenerator;
import org.distributeme.generator.StubGenerator;
import org.distributeme.generator.jaxrs.ResourceGenerator;

public class GeneratorUtil {
    private static Class<? extends Generator>[] RMI_GENERATORS = new Class[]{RemoteInterfaceGenerator.class, StubGenerator.class, SkeletonGenerator.class, ServerGenerator.class, ConstantsGenerator.class, RemoteFactoryGenerator.class, ServerScriptGenerator.class, AsynchInterfaceGenerator.class, AsynchStubGenerator.class, AsynchFactoryGenerator.class};
    private static Class<? extends Generator>[] COMBINED_SERVER_GENERATORS = new Class[]{ServerGenerator.class, ServerScriptGenerator.class};
    private static Class<? extends Generator>[] JAXRS_GENERATORS = new Class[]{ResourceGenerator.class, StubGenerator.class, ConstantsGenerator.class};

    public static void generateJAXRS(TypeElement type, ProcessingEnvironment environment) {
        System.out.println("DistributeMe JAXRS generation started for type: " + type);
        Map<String, String> generatorOptions = GeneratorUtil.getGeneratorOptions(environment);
        System.out.println("Found " + generatorOptions.size() + " Options:");
        for (String option : generatorOptions.keySet()) {
            System.out.println(option + " : " + generatorOptions.get(option));
        }
        GeneratorUtil.generate(type, environment, generatorOptions, JAXRS_GENERATORS);
        System.out.println("DistributeMe generation finished.");
    }

    private static void generate(TypeElement type, ProcessingEnvironment environment, Map<String, String> generatorOptions, Class<? extends Generator>[] generatorClasses) {
        Filer filer = environment.getFiler();
        for (Class<? extends Generator> generatorClass : generatorClasses) {
            try {
                Generator g = generatorClass.getDeclaredConstructor(ProcessingEnvironment.class).newInstance(environment);
                g.generate(type, filer, generatorOptions);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void generateRMI(TypeElement type, ProcessingEnvironment environment) {
        Map<String, String> generatorOptions = GeneratorUtil.getGeneratorOptions(environment);
        GeneratorUtil.generate(type, environment, generatorOptions, GeneratorUtil.getGeneratorsForType(type));
    }

    private static Class<? extends Generator>[] getGeneratorsForType(Element type) {
        CombinedService combinedServiceAnn = type.getAnnotation(CombinedService.class);
        if (combinedServiceAnn != null) {
            return COMBINED_SERVER_GENERATORS;
        }
        return RMI_GENERATORS;
    }

    private static Map<String, String> getGeneratorOptions(ProcessingEnvironment environment) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String option : environment.getOptions().keySet()) {
            if (!option.startsWith("-A")) continue;
            String[] optionTokens = StringUtils.tokenize((String)option, (char)'=');
            if (optionTokens.length > 2) {
                throw new IllegalArgumentException("Wrong format of generator option: " + option + ": expected -Aname=value");
            }
            String name = optionTokens[0].substring("-A".length());
            String value = optionTokens[1];
            ret.put(name, value);
        }
        return ret;
    }
}

