/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.generator;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import net.anotheria.anoprise.metafactory.ServiceFactory;
import net.anotheria.moskito.core.dynamic.ProxyUtils;
import org.distributeme.annotation.DistributeMe;
import org.distributeme.generator.AbstractGenerator;
import org.distributeme.generator.Generator;

public class RemoteFactoryGenerator
extends AbstractGenerator
implements Generator {
    public RemoteFactoryGenerator(ProcessingEnvironment environment) {
        super(environment);
    }

    @Override
    public void generate(TypeElement type, Filer filer, Map<String, String> options) throws IOException {
        JavaFileObject sourceFile = filer.createSourceFile(this.getPackageName(type) + "." + RemoteFactoryGenerator.getFactoryName(type), new Element[0]);
        PrintWriter writer = new PrintWriter(sourceFile.openWriter());
        this.setWriter(writer);
        this.writePackage(type);
        this.writeAnalyzerComments(type);
        this.emptyline();
        this.writeImport(ServiceFactory.class);
        DistributeMe ann = type.getAnnotation(DistributeMe.class);
        if (ann.moskitoSupport()) {
            this.writeImport(ProxyUtils.class);
        }
        this.emptyline();
        this.writeString("public class " + RemoteFactoryGenerator.getFactoryName(type) + " implements ServiceFactory<" + type.getQualifiedName() + ">{");
        this.increaseIdent();
        this.emptyline();
        this.writeString("public " + type.getQualifiedName() + " create(){");
        this.increaseIdent();
        this.writeStatement(type.getQualifiedName() + " instance = new " + RemoteFactoryGenerator.getStubName(type) + "()");
        if (!ann.moskitoSupport()) {
            this.writeStatement("return instance");
        } else {
            String name = type.getSimpleName().toString() + "DiMe";
            this.writeStatement("return ProxyUtils.createServiceInstance(instance, " + this.quote(name) + ", \"remote-service\", \"default\", " + this.getImplementedInterfacesAsString(type) + ")");
        }
        this.closeBlock("create");
        this.closeBlock();
        writer.flush();
        writer.close();
    }
}

