/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.generator;

import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;
import org.distributeme.core.lifecycle.ServiceAdapter;
import org.distributeme.generator.AbstractGenerator;
import org.distributeme.generator.Generator;

public class RemoteInterfaceGenerator
extends AbstractGenerator
implements Generator {
    public RemoteInterfaceGenerator(ProcessingEnvironment environment) {
        super(environment);
    }

    @Override
    public void generate(TypeElement type, Filer filer, Map<String, String> options) throws IOException {
        JavaFileObject sourceFile = filer.createSourceFile(this.getPackageName(type) + "." + RemoteInterfaceGenerator.getRemoteInterfaceName(type), new Element[0]);
        PrintWriter writer = new PrintWriter(sourceFile.openWriter());
        this.setWriter(writer);
        this.writePackage(type);
        this.writeAnalyzerComments(type);
        this.emptyline();
        this.writeImport(Remote.class);
        this.writeImport(RemoteException.class);
        this.writeImport(ServiceAdapter.class);
        this.writeImport(List.class);
        this.writeImport(Map.class);
        this.emptyline();
        this.writeString("public interface " + RemoteInterfaceGenerator.getRemoteInterfaceName(type) + " extends Remote, ServiceAdapter{");
        this.increaseIdent();
        Collection<? extends ExecutableElement> methods = this.getAllDeclaredMethods(type);
        for (ExecutableElement executableElement : methods) {
            String methodDecl = this.getInterfaceMethodDeclaration(executableElement, true);
            if (executableElement.getThrownTypes().size() > 0) {
                StringBuilder exceptions = new StringBuilder();
                for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
                    if (exceptions.length() > 0) {
                        exceptions.append(", ");
                    }
                    exceptions.append(typeMirror.toString());
                }
                methodDecl = methodDecl + " throws " + exceptions + ", RemoteException";
            } else {
                methodDecl = methodDecl + " throws RemoteException";
            }
            this.writeStatement(methodDecl);
            this.emptyline();
        }
        this.closeBlock();
        writer.flush();
        writer.close();
    }
}

