/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.generator;

import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.UnicastRemoteObject;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import net.anotheria.anoprise.metafactory.Extension;
import net.anotheria.anoprise.metafactory.FactoryNotFoundException;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.ServiceFactory;
import net.anotheria.util.IdCodeGenerator;
import net.anotheria.util.PidTools;
import org.distributeme.annotation.CombinedService;
import org.distributeme.annotation.DistributeMe;
import org.distributeme.annotation.DummyFactory;
import org.distributeme.annotation.Route;
import org.distributeme.annotation.RouteMe;
import org.distributeme.annotation.ServerListener;
import org.distributeme.annotation.SupportService;
import org.distributeme.core.RMIRegistryUtil;
import org.distributeme.core.RegistryLocation;
import org.distributeme.core.RegistryUtil;
import org.distributeme.core.ServerShutdownHook;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.core.SystemPropertyNames;
import org.distributeme.core.Verbosity;
import org.distributeme.core.conventions.SystemProperties;
import org.distributeme.core.lifecycle.LifecycleComponentImpl;
import org.distributeme.core.listener.ListenerRegistry;
import org.distributeme.core.listener.ServerLifecycleListener;
import org.distributeme.core.listener.ServerLifecycleListenerShutdownHook;
import org.distributeme.core.routing.RegistrationNameProvider;
import org.distributeme.core.routing.RoutingAware;
import org.distributeme.core.util.LocalServiceDescriptorStore;
import org.distributeme.generator.AbstractGenerator;
import org.distributeme.generator.Generator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ServerGenerator
extends AbstractGenerator
implements Generator {
    private static final String[] SUPPORT_SERVICES_ONLY = new String[]{"org.distributeme.support.lifecycle.generated.LifecycleSupportServer", "org.distributeme.support.eventservice.generated.EventServiceRMIBridgeServer"};
    private static final String[] SUPPORT_SERVICES_WITH_AGENTS = new String[]{"org.distributeme.support.lifecycle.generated.LifecycleSupportServer", "org.distributeme.support.eventservice.generated.EventServiceRMIBridgeServer", "org.distributeme.agents.transporter.generated.TransporterServer"};

    public ServerGenerator(ProcessingEnvironment environment) {
        super(environment);
    }

    @Override
    public void generate(TypeElement type, Filer filer, Map<String, String> options) throws IOException {
        String[] initCode;
        String[] SUPPORT_SERVICES;
        JavaFileObject sourceFile = filer.createSourceFile(this.getPackageName(type) + "." + ServerGenerator.getServerName(type), new Element[0]);
        PrintWriter writer = new PrintWriter(sourceFile.openWriter());
        this.setWriter(writer);
        boolean combinedServer = type.getAnnotation(CombinedService.class) != null;
        this.writePackage(type);
        this.writeAnalyzerComments(type);
        this.emptyline();
        this.writeImport(Logger.class);
        this.writeImport(LoggerFactory.class);
        this.writeImport(Marker.class);
        this.writeImport(MarkerFactory.class);
        this.writeImport(UnicastRemoteObject.class);
        this.writeImport(Permission.class);
        this.writeImport(LocateRegistry.class);
        this.writeImport(Registry.class);
        this.writeImport(RegistryUtil.class);
        this.writeImport(RegistryLocation.class);
        this.writeImport(ExportException.class);
        this.writeImport(ServiceDescriptor.class);
        this.writeImport(LocalServiceDescriptorStore.class);
        this.writeImport("org.distributeme.core.ServiceDescriptor.Protocol");
        this.writeImport(MetaFactory.class);
        this.writeImport(FactoryNotFoundException.class);
        this.writeImport(Extension.class);
        this.writeImport(PidTools.class);
        this.writeImport(IdCodeGenerator.class);
        this.writeImport(RMIRegistryUtil.class);
        this.writeImport(RemoteException.class);
        this.writeImport(ServiceFactory.class);
        this.writeImport(LifecycleComponentImpl.class);
        this.writeImport(Verbosity.class);
        this.writeImport(SystemPropertyNames.class);
        this.writeImport(ServerShutdownHook.class);
        this.writeImport(SystemProperties.class);
        this.writeImport(List.class);
        this.writeImport(RoutingAware.class);
        this.emptyline();
        DistributeMe annotation = type.getAnnotation(DistributeMe.class);
        boolean supportService = type.getAnnotation(SupportService.class) != null;
        String[] stringArray = SUPPORT_SERVICES = annotation.agentsSupport() ? SUPPORT_SERVICES_WITH_AGENTS : SUPPORT_SERVICES_ONLY;
        if (!supportService) {
            for (String sService : SUPPORT_SERVICES) {
                this.writeImport(sService);
            }
        }
        this.writeString("public class " + ServerGenerator.getServerName(type) + "{");
        this.increaseIdent();
        this.emptyline();
        this.writeStatement("private static Logger log");
        this.writeStatement("private static Marker FATAL = MarkerFactory.getMarker(\"FATAL\")");
        this.emptyline();
        if (!supportService) {
            this.writeString("public static void main(String a[]) throws Exception{");
            this.increaseIdent();
            this.writeString("if (System.getSecurityManager()==null)");
            this.increaseIdent();
            this.writeCommentLine("We allow all operations.");
            this.writeString("System.setSecurityManager(new SecurityManager(){");
            this.writeIncreasedString("public void checkPermission(Permission perm) { }");
            this.writeStatement("})");
            this.decreaseIdent();
            this.writeString("try {");
            this.increaseIdent();
            this.writeStatement("init()");
            this.writeCommentLine("Log current server PID (Process Id)");
            this.writeStatement("PidTools.logPid()");
            this.writeCommentLine("force verbosity to configure itself");
            this.writeStatement("Verbosity.logServerSideExceptions()");
            this.writeStatement("createSupportServicesAndRegisterLocally()");
            if (!combinedServer) {
                this.writeStatement("createServiceAndRegisterLocally()");
            }
            if (combinedServer) {
                this.writeStatement("createCombinedServicesAndRegisterLocally()");
            }
            this.writeStatement("startService()");
            this.writeStatement("notifyListenersAboutStart()");
            this.decreaseIdent();
            this.writeString("} catch (Throwable e) {");
            this.increaseIdent();
            this.writeStatement("log.error(FATAL, \"Unhandled exception caught\", e)");
            this.writeStatement("System.err.println(e.getMessage())");
            this.writeStatement("System.exit(-4)");
            this.decreaseIdent();
            this.writeString("}");
            this.closeBlock("main");
            this.emptyline();
        }
        if (supportService) {
            this.writeCommentLine("Support service have no main method");
        }
        List<AnnotationMirror> mirrors = this.findMirrors(type, ServerListener.class);
        this.writeStatement("private static final List<" + ServerLifecycleListener.class.getName() + "> serverListeners = new " + ArrayList.class.getName() + "<" + ServerLifecycleListener.class.getName() + ">(" + (mirrors == null ? 0 : mirrors.size()) + ")");
        this.writeString("private static void notifyListenersAboutStart(){");
        this.increaseIdent();
        if (mirrors != null && mirrors.size() > 0) {
            this.writeCommentLine("compiled listeners");
            for (AnnotationMirror mirror : mirrors) {
                this.writeString("try{");
                this.increaseIdent();
                this.writeStatement(ServerLifecycleListener.class.getName() + " listener = new " + this.findMethodValue(mirror, "listenerClass").getValue() + "()");
                this.writeStatement("listener.afterStart()");
                this.writeCommentLine("Only add successful listeners");
                this.writeStatement("serverListeners.add(listener)");
                this.decreaseIdent();
                this.writeString("}catch(Exception e){");
                this.writeIncreasedStatement("log.error(" + this.quote("Couldn't initialize listener " + this.findMethodValue(mirror, "listenerClass").getValue()) + ", e)");
                this.writeString("}");
            }
            this.emptyline();
        }
        this.writeCommentLine("configured listeners");
        this.writeStatement("List<" + ServerLifecycleListener.class.getName() + "> configuredListeners = " + ListenerRegistry.class.getName() + ".getInstance().getServerLifecycleListeners()");
        this.writeString("if (configuredListeners!=null && configuredListeners.size()>0){");
        this.increaseIdent();
        this.writeString("for (" + ServerLifecycleListener.class.getName() + " listener : configuredListeners){");
        this.increaseIdent();
        this.writeString("try{");
        this.increaseIdent();
        this.writeStatement("listener.afterStart()");
        this.decreaseIdent();
        this.writeString("}catch(Exception e){");
        this.writeIncreasedStatement("log.error(" + this.quote("Couldn't call afterStart on  listener ") + " + listener, e)");
        this.writeString("}");
        this.closeBlock("for");
        this.closeBlock("if");
        this.closeBlock("notifyListenersAboutStart");
        this.emptyline();
        this.writeString("public static void init() throws Exception{");
        this.increaseIdent();
        this.writeStatement("log = LoggerFactory.getLogger(" + ServerGenerator.getServerName(type) + ".class)");
        this.writeCommentLine("// CUSTOM CODE STARTED");
        for (String s : initCode = annotation.initcode()) {
            this.writeString(s);
        }
        this.writeCommentLine("// CUSTOM CODE ENDED");
        this.closeBlock("init");
        this.emptyline();
        if (!combinedServer) {
            this.writeCommentLine("Have to keep local reference to the rmiServant and skeleton to prevent gc removal");
            this.writeStatement("private static " + ServerGenerator.getRemoteInterfaceName(type) + " skeleton = null");
            this.writeStatement("private static " + ServerGenerator.getRemoteInterfaceName(type) + " rmiServant = null");
            this.writeStatement("private static String serviceId = null");
            this.emptyline();
            this.writeString("public static void createServiceAndRegisterLocally() throws Exception{");
            this.increaseIdent();
            this.writeCommentLine("Use default port, which is -1");
            this.writeStatement("createServiceAndRegisterLocally(-1)");
            this.closeBlock();
            this.emptyline();
            this.writeString("public static void createServiceAndRegisterLocally(int customRegistryPort) throws Exception{");
            this.increaseIdent();
            this.writeCommentLine("creating impl");
            AnnotationMirror annotationMirror = this.findMirror(type, DistributeMe.class);
            if (annotationMirror == null) {
                throw new AssertionError((Object)("AnnotationMirror is null, which actually can't happen, since the annotation was previously found: " + annotation));
            }
            AnnotationValue factoryClazzValue = this.findMethodValue(annotationMirror, "factoryClazz");
            String factoryClassName = ServerGenerator.getDefaultImplFactoryName(type);
            String implClassName = type.getQualifiedName() + "Impl";
            if (factoryClazzValue != null && !factoryClazzValue.getValue().equals(DummyFactory.class.getName() + ".class")) {
                this.writeCommentLine("Registering factory");
                this.writeStatement("MetaFactory.addFactoryClass(" + type + ".class, Extension." + annotation.extension() + ", " + factoryClazzValue.getValue() + ".class)");
            } else {
                this.writeCommentLine("No factory specified");
                if (initCode.length > 0) {
                    this.writeCommentLine("init code not empty, assuming it contains factory Element");
                } else {
                    this.writeString("try{");
                    this.increaseIdent();
                    this.writeStatement("Class<ServiceFactory<" + type.getQualifiedName() + ">> factoryClazz = (Class<ServiceFactory<" + type.getQualifiedName() + ">>)Class.forName(" + this.quote(factoryClassName) + ")");
                    this.writeStatement("MetaFactory.addFactoryClass(" + type + ".class, Extension." + annotation.extension() + ", factoryClazz)");
                    this.decreaseIdent();
                    this.writeString("}catch(ClassNotFoundException factoryNotFound){");
                    this.increaseIdent();
                    this.writeString("try{");
                    this.increaseIdent();
                    this.writeCommentLine("Even more convenient - try to instantiate the implementation directly");
                    this.writeStatement("Class<? extends " + type.getQualifiedName() + "> implClazz = (Class<? extends " + type.getQualifiedName() + ">)Class.forName(" + this.quote(implClassName) + ")");
                    this.writeStatement("MetaFactory.createOnTheFlyFactory(" + type + ".class, Extension." + annotation.extension() + ", implClazz.newInstance())");
                    this.decreaseIdent();
                    this.writeString("}catch(ClassNotFoundException implNotFound){");
                    this.increaseIdent();
                    this.writeStatement("log.info(" + this.quote("Giving up trying to find an impl instance, tried " + factoryClassName + " and " + implClassName + ", expect start to fail since init code were empty too and no factory has been supplied explicitely") + ")");
                    this.closeBlock("inner catch");
                    this.closeBlock("outer catch");
                }
            }
            this.writeStatement(type.getQualifiedName() + " impl = null");
            this.writeString("try{");
            this.increaseIdent();
            this.writeStatement("impl = MetaFactory.get(" + type.getQualifiedName() + ".class, Extension." + annotation.extension() + ")");
            this.decreaseIdent();
            this.writeString("}catch (FactoryNotFoundException factoryNotFound){");
            this.writeIncreasedStatement("throw new AssertionError(" + this.quote("Un- or mis-configured, can't instantiate service instance for " + type.getQualifiedName() + " tried initcode, submitted factory, autoguessed factory (" + factoryClassName + ") and impl class (" + implClassName + ")") + ")");
            this.writeString("}");
            this.writeStatement("skeleton = new " + ServerGenerator.getSkeletonName(type) + "(impl)");
            this.writeStatement("rmiServant = (" + ServerGenerator.getRemoteInterfaceName(type) + ") UnicastRemoteObject.exportObject(skeleton, SystemProperties.SERVICE_BINDING_PORT.getAsInt())");
            this.writeStatement("serviceId = " + ServerGenerator.getConstantsName(type) + ".getServiceId()");
            this.writeCommentLine("Save original serviceId for later RoutingAware call");
            this.writeStatement("String definedServiceId = serviceId");
            this.emptyline();
            if (type.getAnnotation(RouteMe.class) != null) {
                this.emptyline();
                this.writeCommentLine("Customizing registration name");
                AnnotationMirror routeMe = this.findMirror(type, RouteMe.class);
                AnnotationValue registrationNameProviderClazzValue = this.findMethodValue(routeMe, "providerClass");
                AnnotationValue registrationNameProviderParameterValue = this.findMethodValue(routeMe, "providerParameter");
                this.writeStatement(RegistrationNameProvider.class.getName() + " nameProvider = new " + registrationNameProviderClazzValue.getValue() + "()");
                this.writeStatement("nameProvider.customize(" + this.quote(registrationNameProviderParameterValue.getValue()) + ")");
                this.writeStatement("serviceId = nameProvider.getRegistrationName(serviceId)");
                this.emptyline();
            }
            this.writeStatement("String regNameProviderClass = System.getProperty(SystemPropertyNames.REGISTRATION_NAME_PROVIDER)");
            this.writeString("if (regNameProviderClass!=null){");
            this.increaseIdent();
            this.writeStatement(RegistrationNameProvider.class.getName() + " suppliedNameProvider = (" + RegistrationNameProvider.class.getName() + ")Class.forName(regNameProviderClass).newInstance()");
            this.writeStatement("serviceId = suppliedNameProvider.getRegistrationName(serviceId)");
            this.closeBlock("if (regNameProviderClass!=null)");
            this.emptyline();
            this.writeStatement("log.info(" + this.quote("Getting local registry") + ")");
            this.writeStatement("Registry registry = null");
            this.openTry();
            this.writeStatement("registry = RMIRegistryUtil.findOrCreateRegistry(customRegistryPort)");
            this.decreaseIdent();
            this.writeString("}catch(RemoteException e){");
            this.increaseIdent();
            this.writeStatement("log.error(FATAL, " + this.quote("Couldn't obtain free port for a local rmi registry") + ", e)");
            this.writeStatement("System.err.println(" + this.quote("Couldn't obtain a free port for local rmi registry") + ")");
            this.writeStatement("System.exit(-1)");
            this.closeBlock();
            this.emptyline();
            this.writeStatement("log.info(" + this.quote("Registering ") + "+serviceId+" + this.quote(" locally.") + ")");
            this.emptyline();
            this.openTry();
            this.writeStatement("registry.rebind(serviceId, rmiServant)");
            this.decreaseIdent();
            this.writeStatement("}catch(Exception e){");
            this.increaseIdent();
            this.writeStatement("log.error(FATAL, " + this.quote("Couldn't rebind myself at the local registry") + ", e)");
            this.writeStatement("System.err.println(" + this.quote("Couldn't rebind myself at the local registry") + ")");
            this.writeStatement("e.printStackTrace()");
            this.writeStatement("System.exit(-2)");
            this.closeBlock("local registry bind.");
            this.emptyline();
            AnnotationMirror annotationMirrorRoute = this.findMirror(type, Route.class);
            if (annotationMirror != null) {
                AnnotationValue routerParameter = this.findMethodValue(annotationMirror, "routerParameter");
                AnnotationValue configurationName = this.findMethodValue(annotationMirror, "configurationName");
                this.writeString("if (impl instanceof RoutingAware){");
                this.increaseIdent();
                this.writeStatement("((RoutingAware)impl).notifyServiceId(definedServiceId, serviceId, " + (routerParameter == null ? "null" : this.quote(routerParameter.getValue())) + ", " + (configurationName == null ? "null" : this.quote(configurationName.getValue())) + ") ");
                this.closeBlock("/if impl RoutingAware");
            }
            if (!supportService) {
                this.writeStatement("LifecycleComponentImpl.INSTANCE.registerPublicService(serviceId, skeleton)");
            }
            this.closeBlock();
            this.emptyline();
        }
        if (!combinedServer) {
            this.writeString("public static ServiceDescriptor createDescriptor(String instanceId) throws Exception{");
            String descriptorCall = "RegistryUtil.createLocalServiceDescription(Protocol.RMI,  serviceId, instanceId, RMIRegistryUtil.getRmiRegistryPort())";
            this.increaseIdent();
            this.writeStatement("return " + descriptorCall);
            this.closeBlock();
        }
        this.writeString("public static void startService() throws Exception{");
        this.increaseIdent();
        this.writeStatement("String instanceId = IdCodeGenerator.generateCode(10)");
        if (!combinedServer) {
            this.writeStatement("boolean registerCentrally = !SystemProperties.SKIP_CENTRAL_REGISTRY.getAsBoolean()");
            this.writeString("if (registerCentrally){");
            this.increaseIdent();
            this.writeStatement("ServiceDescriptor descriptor = createDescriptor(instanceId)");
            this.writeStatement("LocalServiceDescriptorStore.getInstance().addServiceDescriptor(descriptor)");
            this.emptyline();
            this.writeString("if (!RegistryUtil.bind(descriptor)){");
            this.increaseIdent();
            this.writeStatement("log.error(FATAL, " + this.quote("Couldn't bind myself to the central registry at ") + "+RegistryUtil.describeRegistry())");
            this.writeStatement("System.err.println(" + this.quote("Couldn't bind myself at the central registry at ") + "+RegistryUtil.describeRegistry())");
            this.writeStatement("System.exit(-3)");
            this.closeBlock("central registry bind");
            this.writeStatement("Runtime.getRuntime().addShutdownHook(new ServerShutdownHook(descriptor))");
            this.emptyline();
            this.decreaseIdent();
            this.writeString("}else{");
            this.writeIncreasedStatement("System.out.println(" + this.quote("skipping registration for ") + "+serviceId" + ")");
            this.writeString("}");
            this.writeStatement("System.out.println(" + this.quote("Server ") + "+serviceId+" + this.quote(" is up and ready.") + ")");
        }
        if (combinedServer) {
            List<String> serviceNames = this.getCombinedServicesNames(type);
            for (String service : serviceNames) {
                String descriptorVariableName = ServerGenerator.getServerName(service).toLowerCase() + "Descriptor";
                String serviceServerClassName = ServerGenerator.getFullyQualifiedServerName(service);
                this.writeStatement("ServiceDescriptor " + descriptorVariableName + " = " + serviceServerClassName + ".createDescriptor(instanceId)");
                this.writeStatement("LocalServiceDescriptorStore.getInstance().addServiceDescriptor(" + descriptorVariableName + ")");
                this.emptyline();
                this.writeString("if (!RegistryUtil.bind(" + descriptorVariableName + ")){");
                this.increaseIdent();
                this.writeStatement("log.error(FATAL, " + this.quote("Couldn't bind ") + "+" + descriptorVariableName + "+" + this.quote(" to the central registry at ") + "+RegistryUtil.describeRegistry())");
                this.writeStatement("System.err.println(" + this.quote("Couldn't bind ") + "+" + descriptorVariableName + "+" + this.quote(" at the central registry at ") + "+RegistryUtil.describeRegistry())");
                this.writeStatement("System.exit(-3)");
                this.closeBlock("central registry bind");
                this.writeStatement("Runtime.getRuntime().addShutdownHook(new ServerShutdownHook(" + descriptorVariableName + "))");
                this.emptyline();
                this.writeStatement("System.out.println(" + this.quote("Server ") + "+" + descriptorVariableName + ".getServiceId()+" + this.quote(" is up and ready.") + ")");
            }
        }
        this.writeStatement("Runtime.getRuntime().addShutdownHook(new " + ServerLifecycleListenerShutdownHook.class.getName() + "(serverListeners))");
        this.closeBlock("startService");
        if (!supportService) {
            this.emptyline();
            this.writeString("public static void createSupportServicesAndRegisterLocally() throws Exception{");
            this.increaseIdent();
            for (String s : SUPPORT_SERVICES) {
                this.writeStatement(s + ".init()");
                this.writeStatement(s + ".createServiceAndRegisterLocally()");
            }
            this.closeBlock("createSupportServicesAndRegisterLocally");
            this.emptyline();
        }
        if (combinedServer) {
            this.emptyline();
            this.writeString("public static void createCombinedServicesAndRegisterLocally() throws Exception{");
            this.increaseIdent();
            this.writeStatement("createCombinedServicesAndRegisterLocally(-1)");
            this.closeBlock("createCombinedServicesAndRegisterLocally");
            this.emptyline();
            this.writeString("public static void createCombinedServicesAndRegisterLocally(int customRegistryPort) throws Exception{");
            this.increaseIdent();
            List<String> targetServicesNames = this.getCombinedServicesNames(type);
            for (String service : targetServicesNames) {
                this.writeStatement(ServerGenerator.getFullyQualifiedServerName(service) + ".init()");
                this.writeStatement(ServerGenerator.getFullyQualifiedServerName(service) + ".createServiceAndRegisterLocally(customRegistryPort)");
            }
            this.closeBlock("createCombinedServicesAndRegisterLocally");
            this.emptyline();
        }
        this.closeBlock();
        writer.flush();
        writer.close();
    }

    private List<String> getCombinedServicesNames(TypeElement type) {
        AnnotationMirror ann = this.findMirror(type, CombinedService.class);
        AnnotationValue val = this.findMethodValue(ann, "services");
        List values = (List)val.getValue();
        ArrayList<String> ret = new ArrayList<String>();
        for (AnnotationValue o : values) {
            ret.add(o.getValue().toString());
        }
        return ret;
    }
}

