/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.generator;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import net.anotheria.util.StringUtils;
import org.distributeme.generator.AbstractGenerator;
import org.distributeme.generator.Generator;

public class ServerScriptGenerator
extends AbstractGenerator
implements Generator {
    public ServerScriptGenerator(ProcessingEnvironment environment) {
        super(environment);
    }

    private String makeTypeName(TypeElement type) {
        String fullName = type.getQualifiedName().toString().toLowerCase();
        int lastDot = fullName.lastIndexOf(46);
        if (lastDot == -1) {
            return fullName;
        }
        String packageName = fullName.substring(0, lastDot);
        String[] packageParts = StringUtils.tokenize((String)packageName, (char)'.');
        StringBuilder firstPartOfName = new StringBuilder();
        for (int i = 0; i < packageParts.length; ++i) {
            String token = packageParts[i];
            if (token == null || token.length() <= 0) continue;
            if (i == packageParts.length - 1) {
                firstPartOfName.append('-').append(token);
                continue;
            }
            firstPartOfName.append(token.charAt(0));
        }
        return firstPartOfName.append('-').append(fullName.substring(lastDot + 1)).toString();
    }

    @Override
    public void generate(TypeElement type, Filer filer, Map<String, String> options) throws IOException {
        String relativeName = "scripts/" + this.makeTypeName(type) + "-server.sh";
        FileObject fileObject = filer.createResource(StandardLocation.SOURCE_OUTPUT, "", relativeName, new Element[0]);
        PrintWriter writer = new PrintWriter(fileObject.openWriter());
        this.setWriter(writer);
        this.writeString("#!/bin/bash");
        this.emptyline();
        if (options.get("includescript") != null) {
            this.writeString("source " + options.get("includescript"));
            this.emptyline();
        }
        this.writeString("#jpdaOpts=\"-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=localhost:8101\"");
        this.emptyline();
        this.writeString("#release_path=<absolute_path_to_release>");
        this.writeString("#dist=<dist_jar>");
        this.writeString("#lib=<lib_folder>");
        this.writeString("#etc=<etc_folder>");
        this.writeString("#initialMemory=<initial_memory_size>");
        this.writeString("#maxMemory=<max_memory_size>");
        this.writeString("#configuremeEnvironment=<configureme_environment>");
        this.writeString("#user=<restricted_user_name>");
        this.writeString("#outlog=<nohup_stdout_log_file_name>");
        this.writeString("#errlog=<nohup_stdout_log_file_name>");
        this.writeString("#logdir=<log_directory>");
        this.writeString("#tmpdir=<temporary_files_directory>");
        this.writeString("#pidfile=<log_files_directory>");
        this.emptyline();
        this.writeString("if [ -z \"$release_path\" ]; then");
        this.increaseIdent();
        this.writeString("echo 'release_path environment is not set!'");
        this.writeString("exit 1");
        this.decreaseIdent();
        this.writeString("fi");
        this.emptyline();
        this.writeString("if [ -z \"$dist\" ]; then");
        this.increaseIdent();
        this.writeString("echo 'dist environment is not set!'");
        this.writeString("exit 1");
        this.decreaseIdent();
        this.writeString("fi");
        this.emptyline();
        this.writeString("dist=$release_path/$dist");
        this.writeString("lib=$release_path/${lib:=lib}");
        this.writeString("etc=$release_path/${etc:=etc}");
        this.writeString("initialMemory=${initialMemory:=512M}");
        this.writeString("maxMemory=${maxMemory:=512M}");
        this.writeString("configuremeEnvironment=${configuremeEnvironment:=dev}");
        this.writeString("user=${user:=$USER}");
        this.writeString("logdir=$release_path/${logdir:=.}");
        this.writeString("outlog=${outlog:=$logdir/nohup-" + ServerScriptGenerator.getServerName(type) + "-out.log}");
        this.writeString("errlog=${errlog:=$logdir/nohup-" + ServerScriptGenerator.getServerName(type) + "-err.log}");
        this.writeString("tmpdir=$release_path/${tmpdir:=/tmp}");
        this.writeString("pidfile=${pidfile:=$tmpdir/" + ServerScriptGenerator.getServerName(type) + ".pid}");
        this.emptyline();
        this.writeString("server='" + this.getPackageName(type) + "." + ServerScriptGenerator.getServerName(type) + "'");
        this.emptyline();
        this.writeString("isServerUp() {");
        this.increaseIdent();
        this.writeString("if [ -f \"$pidfile\" ]; then");
        this.increaseIdent();
        this.writeString("pid=`cat \"$pidfile\"`");
        this.writeString("alive=`ps --no-heading $pid 2>/dev/null | wc -l`");
        this.writeString("if [ $alive == 0 ]; then");
        this.increaseIdent();
        this.writeString("rm -f \"$pidfile\"");
        this.writeString("return 0");
        this.decreaseIdent();
        this.writeString("else");
        this.writeIncreasedString("return 1");
        this.writeString("fi");
        this.decreaseIdent();
        this.writeString("else");
        this.writeIncreasedString("return 0");
        this.writeString("fi");
        this.decreaseIdent();
        this.writeString("}");
        this.emptyline();
        this.writeString("start() {");
        this.increaseIdent();
        this.writeString("isServerUp");
        this.writeString("running=$?");
        this.writeString("if [ $running == 0 ]; then");
        this.increaseIdent();
        this.writeString("echo -n 'Starting " + ServerScriptGenerator.getServerName(type) + "... '");
        this.writeString("for file in $(ls $lib); do");
        this.increaseIdent();
        this.writeString("CLASSPATH=$CLASSPATH:$lib/$file");
        this.writeString("rmicodebase=\"$rmicodebase file:$lib/$file\"");
        this.decreaseIdent();
        this.writeString("done");
        this.writeString("CLASSPATH=$etc:$dist:$CLASSPATH");
        this.writeString("rmicodebase=\"file:$etc file:$dist $rmicodebase\"");
        this.writeString("work_dir=`pwd`");
        this.writeString("cd \"$release_path\"");
        this.writeString("sudo -u \"$user\" /bin/bash -c \"nohup java $jpdaOpts -Xmx$maxMemory -Xms$initialMemory -classpath $CLASSPATH -Djava.rmi.server.codebase=\\\"$rmicodebase\\\" -Dpidfile=\\\"$pidfile\\\" -Dconfigureme.defaultEnvironment=$configuremeEnvironment $server 1>>\\\"$outlog\\\" 2>>\\\"$errlog\\\" &\"");
        this.writeString("cd \"$work_dir\"");
        this.writeString("#Wait for possible starting error");
        this.writeString("sleep 2");
        this.writeString("isServerUp");
        this.writeString("running=$?");
        this.writeString("if [ $running == 1 ]; then");
        this.writeIncreasedString("echo Done");
        this.writeString("else");
        this.writeIncreasedString("echo Failed");
        this.writeString("fi");
        this.decreaseIdent();
        this.writeString("else");
        this.writeIncreasedString("echo " + ServerScriptGenerator.getServerName(type) + " is already running");
        this.writeString("fi");
        this.decreaseIdent();
        this.writeString("}");
        this.emptyline();
        this.writeString("stop() {");
        this.increaseIdent();
        this.writeString("isServerUp");
        this.writeString("running=$?");
        this.writeString("if [ $running == 0 ]; then");
        this.writeIncreasedString("echo '" + ServerScriptGenerator.getServerName(type) + " is not running'");
        this.writeString("else");
        this.increaseIdent();
        this.writeString("echo -n 'Stopping " + ServerScriptGenerator.getServerName(type) + "... '");
        this.writeString("pid=`cat \"$pidfile\"`");
        this.writeString("kill $pid");
        this.writeString("sleep 2");
        this.writeString("isServerUp");
        this.writeString("running=$?");
        this.writeString("if [ $running == 0 ]; then");
        this.increaseIdent();
        this.writeString("echo Done");
        this.writeString("rm -f \"$pidfile\"");
        this.decreaseIdent();
        this.writeString("else");
        this.writeIncreasedString("echo Failed");
        this.writeString("fi");
        this.decreaseIdent();
        this.writeString("fi");
        this.decreaseIdent();
        this.writeString("}");
        this.emptyline();
        this.writeString("status() {");
        this.increaseIdent();
        this.writeString("isServerUp");
        this.writeString("running=$?");
        this.writeString("if [ $running == 1 ]; then");
        this.writeIncreasedString("echo '" + ServerScriptGenerator.getServerName(type) + " is running'");
        this.writeString("else");
        this.writeIncreasedString("echo '" + ServerScriptGenerator.getServerName(type) + " is not running'");
        this.writeString("fi");
        this.decreaseIdent();
        this.writeString("}");
        this.emptyline();
        this.writeString("case $1 in");
        this.increaseIdent();
        this.writeString("start)");
        this.increaseIdent();
        this.writeString("start");
        this.writeString(";;");
        this.decreaseIdent();
        this.writeString("stop)");
        this.increaseIdent();
        this.writeString("stop");
        this.writeString(";;");
        this.decreaseIdent();
        this.writeString("restart)");
        this.increaseIdent();
        this.writeString("stop");
        this.writeString("sleep 1");
        this.writeString("start");
        this.writeString(";;");
        this.decreaseIdent();
        this.writeString("status)");
        this.increaseIdent();
        this.writeString("status");
        this.writeString(";;");
        this.decreaseIdent();
        this.writeString("*)");
        this.writeString("echo $\"Usage: $0 {start|stop|restart|status}\"");
        this.writeString("exit 1");
        this.decreaseIdent();
        this.writeString("esac");
        this.emptyline();
        this.writeString("exit 0");
        writer.flush();
        writer.close();
    }
}

