/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.generator;

import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;
import org.distributeme.annotation.DistributeMe;
import org.distributeme.annotation.DontRoute;
import org.distributeme.annotation.FailBy;
import org.distributeme.annotation.Route;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.Defaults;
import org.distributeme.core.DiscoveryMode;
import org.distributeme.core.RegistryUtil;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.core.concurrencycontrol.ConcurrencyControlStrategy;
import org.distributeme.core.exception.DistributemeRuntimeException;
import org.distributeme.core.exception.NoConnectionToServerException;
import org.distributeme.core.exception.ServiceUnavailableException;
import org.distributeme.core.failing.FailDecision;
import org.distributeme.core.failing.FailingStrategy;
import org.distributeme.core.interceptor.ClientSideRequestInterceptor;
import org.distributeme.core.interceptor.FailedByInterceptorException;
import org.distributeme.core.interceptor.InterceptionContext;
import org.distributeme.core.interceptor.InterceptionPhase;
import org.distributeme.core.interceptor.InterceptorRegistry;
import org.distributeme.core.interceptor.InterceptorResponse;
import org.distributeme.generator.AbstractGenerator;
import org.distributeme.generator.AbstractStubGenerator;
import org.distributeme.generator.Generator;
import org.distributeme.generator.logwriter.LogWriter;
import org.distributeme.generator.logwriter.SysErrorLogWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StubGenerator
extends AbstractStubGenerator
implements Generator {
    private static Logger log = LoggerFactory.getLogger(StubGenerator.class);

    public StubGenerator(ProcessingEnvironment environment) {
        super(environment);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generate(TypeElement type, Filer filer, Map<String, String> options) throws IOException {
        JavaFileObject sourceFile = filer.createSourceFile(this.getPackageName(type) + "." + StubGenerator.getStubName(type), new Element[0]);
        PrintWriter writer = new PrintWriter(sourceFile.openWriter());
        this.setWriter(writer);
        this.writePackage(type);
        this.writeAnalyzerComments(type);
        this.emptyline();
        this.writeImport(List.class);
        this.writeImport(ArrayList.class);
        this.writeImport(HashMap.class);
        this.writeImport(ConcurrentMap.class);
        this.writeImport(ConcurrentHashMap.class);
        this.writeImport(Logger.class);
        this.writeImport(RemoteException.class);
        this.writeImport(NotBoundException.class);
        this.writeImport(RegistryUtil.class);
        this.writeImport("java.rmi.registry.LocateRegistry");
        this.writeImport("java.rmi.registry.Registry");
        this.writeImport(ServiceDescriptor.class);
        this.writeImport("org.distributeme.core.ServiceDescriptor.Protocol");
        this.writeImport(DiscoveryMode.class);
        this.writeImport(FailingStrategy.class);
        this.writeImport(ConcurrencyControlStrategy.class);
        this.writeImport(FailDecision.class);
        this.writeImport(ClientSideCallContext.class);
        this.writeImport(DistributemeRuntimeException.class);
        this.writeImport(NoConnectionToServerException.class);
        this.writeImport(ServiceUnavailableException.class);
        this.writeImport(Defaults.class);
        this.writeImport(ClientSideRequestInterceptor.class);
        this.writeImport(InterceptorRegistry.class);
        this.writeImport(InterceptorResponse.class);
        this.writeImport(InterceptionContext.class);
        this.writeImport(InterceptionPhase.class);
        this.writeImport(FailedByInterceptorException.class);
        this.emptyline();
        this.writeString("public class " + StubGenerator.getStubName(type) + " implements " + type.getQualifiedName() + "{");
        this.increaseIdent();
        this.emptyline();
        LogWriter logWriter = null;
        try {
            AnnotationMirror logWriterMirror = this.findMirror(type, DistributeMe.class);
            AnnotationValue logWriterClazzValue = this.findLogWriterValue(logWriterMirror);
            String logWriterClazzName = null;
            logWriterClazzName = logWriterClazzValue == null ? SysErrorLogWriter.class.getName() : "" + logWriterClazzValue.getValue();
            logWriter = (LogWriter)Class.forName(logWriterClazzName).newInstance();
        }
        catch (Exception e) {
            log.warn("Still have this stupid exception...", (Throwable)e);
            logWriter = new SysErrorLogWriter();
        }
        String loggerInitialization = logWriter.createLoggerInitialization(StubGenerator.getStubName(type));
        if (loggerInitialization != null && loggerInitialization.length() > 0) {
            this.writeStatement(loggerInitialization);
        }
        this.emptyline();
        boolean clazzWideRoutingEnabled = this.findMirror(type, Route.class) != null;
        this.writeStatement("private volatile ConcurrentMap<String," + StubGenerator.getRemoteInterfaceName(type) + "> delegates = new ConcurrentHashMap<String," + StubGenerator.getRemoteInterfaceName(type) + ">()");
        this.emptyline();
        this.writeStatement("private DiscoveryMode discoveryMode = DiscoveryMode.AUTO");
        this.emptyline();
        List<AbstractGenerator.TranslatedRouterAnnotation> routerAnnotations = this.writeRouterDeclarations(type);
        Collection<? extends ExecutableElement> methods = this.getAllDeclaredMethods(type);
        HashSet<ExecutableElement> routedMethods = new HashSet<ExecutableElement>();
        for (ExecutableElement executableElement : methods) {
            AnnotationMirror methodRoute = this.findMirror(executableElement, Route.class);
            if (methodRoute == null) continue;
            routedMethods.add(executableElement);
        }
        this.emptyline();
        this.writeCommentLine("Failing");
        this.writeCommentLine("Class wide failing strategy ");
        AnnotationMirror clazzWideFailingStrategyAnnotation = this.findMirror(type, FailBy.class);
        Object var13_16 = null;
        if (clazzWideFailingStrategyAnnotation != null) {
            String string = "" + this.findMethodValue(clazzWideFailingStrategyAnnotation, "strategyClass").getValue();
        }
        if (clazzWideFailingStrategyAnnotation != null) {
            void var13_18;
            FailBy ann = type.getAnnotation(FailBy.class);
            if (ann.reuseRouter()) {
                if (!clazzWideRoutingEnabled) {
                    throw new AssertionError((Object)"Can't reuse router if no @Route router is configured.");
                }
                this.writeStatement("private FailingStrategy clazzWideFailingStrategy = (FailingStrategy) clazzWideRouter");
            } else if (var13_18 != null) {
                this.writeStatement("private FailingStrategy clazzWideFailingStrategy = new " + (String)var13_18 + "()");
            }
        } else {
            this.writeStatement("private FailingStrategy clazzWideFailingStrategy = " + Defaults.class.getSimpleName() + ".getDefaultFailingStrategy()");
        }
        this.emptyline();
        for (ExecutableElement executableElement : methods) {
            AnnotationMirror annotationMirror = this.findMirror(executableElement, FailBy.class);
            if (annotationMirror != null) {
                FailBy ann = executableElement.getAnnotation(FailBy.class);
                if (ann.reuseRouter()) {
                    if (!routedMethods.contains(executableElement) && !clazzWideRoutingEnabled) {
                        throw new AssertionError((Object)("Can't reuse router in method " + executableElement + ", because no router is configured."));
                    }
                    String targetRouterName = routedMethods.contains(executableElement) ? this.getMethodRouterName(executableElement) : "clazzWideRouter";
                    this.writeStatement("private FailingStrategy " + this.getFailingStrategyVariableName(executableElement) + " = (FailingStrategy) " + targetRouterName);
                    continue;
                }
                String methodFailingStrategyName = "" + this.findMethodValue(annotationMirror, "strategyClass").getValue();
                this.writeStatement("private FailingStrategy " + this.getFailingStrategyVariableName(executableElement) + " = new " + methodFailingStrategyName + "()");
                continue;
            }
            this.writeStatement("private FailingStrategy " + this.getFailingStrategyVariableName(executableElement) + " = clazzWideFailingStrategy");
        }
        this.writeCommentLine("Failing end");
        this.emptyline();
        List<AbstractGenerator.TranslatedCCAnnotation> concurrencyControlAnnotations = this.writeConcurrencyControlDeclarations(type);
        this.writeString("public " + StubGenerator.getStubName(type) + "(){");
        this.increaseIdent();
        this.writeStatement("discoveryMode = DiscoveryMode.AUTO");
        this.closeBlock();
        this.emptyline();
        this.writeStatement("private ServiceDescriptor manuallySetDescriptor");
        this.writeStatement("private " + StubGenerator.getRemoteInterfaceName(type) + " manuallySetTarget");
        this.emptyline();
        this.writeString("public " + StubGenerator.getStubName(type) + "(ServiceDescriptor target){");
        this.increaseIdent();
        this.writeStatement("discoveryMode = DiscoveryMode.MANUAL");
        this.writeStatement("manuallySetDescriptor = target");
        this.writeString("try{");
        this.writeIncreasedStatement("manuallySetTarget = lookup(manuallySetDescriptor)");
        this.writeString("}catch(NoConnectionToServerException e){");
        this.writeIncreasedStatement("throw new IllegalStateException(" + this.quote("Can not resolve manually set reference") + ", e)");
        this.closeBlockWithoutIdent();
        this.closeBlock();
        this.emptyline();
        for (ExecutableElement executableElement : methods) {
            AnnotationMirror methodMirror;
            this.writeString("public " + this.getStubMethodDeclaration(executableElement) + "{");
            this.increaseIdent();
            StringBuilder callToPrivate = new StringBuilder(executableElement.getSimpleName() + "(");
            for (VariableElement variableElement : executableElement.getParameters()) {
                callToPrivate.append(variableElement.getSimpleName());
                callToPrivate.append(", ");
            }
            this.writeStatement((this.isVoidReturn(executableElement) ? "" : "return ") + callToPrivate.toString() + "(ClientSideCallContext)null)");
            this.closeBlock("public " + this.getStubMethodDeclaration(executableElement));
            this.emptyline();
            String methodDecl = this.getInternalStubMethodDeclaration(executableElement);
            this.writeString("private " + methodDecl + "{");
            this.increaseIdent();
            this.writeStatement("List __fromServerSide = null");
            this.writeStatement("Exception exceptionInMethod = null");
            this.writeCommentLine("This flag is used by the interceptor logic to mark a request es failed, even it is not.");
            this.writeStatement("boolean diMeForceFailing = false");
            this.writeStatement("boolean abortAndFail = false");
            this.writeString("if (diMeCallContext == null)");
            this.writeIncreasedStatement("diMeCallContext = new ClientSideCallContext(" + this.quote(executableElement.getSimpleName()) + ")");
            this.writeString("if (discoveryMode == DiscoveryMode.MANUAL) {");
            this.writeIncreasedStatement("diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId())");
            this.writeString("}");
            this.writeString("if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)");
            this.writeIncreasedStatement("diMeCallContext.setServiceId(" + StubGenerator.getConstantsName(type) + ".getServiceId())");
            this.emptyline();
            this.writeStatement("HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext()");
            boolean bl = true;
            this.writeCommentLine("Initialize interceptors");
            this.writeStatement("List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors()");
            this.writeStatement("InterceptionContext diMeInterceptionContext = new InterceptionContext()");
            this.writeCommentLine("Concurrency control, client side - start");
            this.writeStatement(this.getCCStrategyVariableName(executableElement) + ".notifyClientSideCallStarted(diMeCallContext)");
            this.emptyline();
            if (bl) {
                this.writeStatement("ArrayList<Object> diMeParameters = new ArrayList<Object>()");
                List<? extends VariableElement> parameters = executableElement.getParameters();
                for (VariableElement variableElement : parameters) {
                    this.writeStatement("diMeParameters.add(" + variableElement.getSimpleName() + ")");
                }
                this.writeStatement("diMeCallContext.setParameters(diMeParameters)");
            }
            if ((methodMirror = this.findMirror(executableElement, DontRoute.class)) != null) {
                this.writeCommentLine("explicitly skipping routing for method " + executableElement);
            } else {
                String routerName = null;
                if (clazzWideRoutingEnabled) {
                    routerName = "clazzWideRouter";
                }
                if (routedMethods.contains(executableElement)) {
                    routerName = this.getMethodRouterName(executableElement);
                }
                if (routerName != null) {
                    if (!bl) {
                        this.writeStatement("ArrayList<Object> diMeParameters = new ArrayList<Object>()");
                        List<? extends VariableElement> list = executableElement.getParameters();
                        for (VariableElement variableElement : list) {
                            this.writeStatement("diMeParameters.add(" + variableElement.getSimpleName() + ")");
                        }
                        this.writeStatement("diMeCallContext.setParameters(diMeParameters)");
                    }
                    this.writeStatement("diMeCallContext.setServiceId(" + routerName + ".getServiceIdForCall(diMeCallContext))");
                }
            }
            this.writeString("try{");
            this.increaseIdent();
            this.writeInterceptionBlock(InterceptionPhase.BEFORE_SERVICE_CALL, executableElement);
            this.writeCommentLine("parse parameters again in case an interceptor modified them");
            List<? extends VariableElement> parameters = executableElement.getParameters();
            boolean bl2 = false;
            for (VariableElement variableElement : parameters) {
                void var22_37;
                this.writeStatement(variableElement.getSimpleName() + " = " + this.convertReturnValue(variableElement.asType(), "diMeParameters.get(" + (int)(++var22_37) + ")"));
            }
            String call = "__fromServerSide = getDelegate(diMeCallContext.getServiceId())." + executableElement.getSimpleName();
            StringBuilder stringBuilder = new StringBuilder();
            for (VariableElement variableElement : parameters) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(variableElement.getSimpleName());
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(" __transportableCallContext");
            call = call + "(" + stringBuilder.toString() + ");";
            this.writeString("if (!abortAndFail){");
            this.increaseIdent();
            this.writeString(call);
            this.writeStatement("__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)))");
            if (this.isVoidReturn(executableElement)) {
                this.writeStatement("return");
            } else {
                this.writeStatement("return " + this.convertReturnValue(executableElement.getReturnType(), "__fromServerSide.get(0)"));
            }
            this.closeBlock();
            this.decreaseIdent();
            this.writeString("}catch(RemoteException e){");
            this.increaseIdent();
            this.writeCommentLine("handle exceptions properly");
            this.writeStatement(logWriter.createExceptionOutput(this.quote(executableElement.getSimpleName() + "(...)"), "e"));
            this.writeStatement("notifyDelegateFailed(diMeCallContext.getServiceId())");
            this.writeStatement("exceptionInMethod = e");
            this.decreaseIdent();
            this.writeString("}catch(NoConnectionToServerException e){");
            this.writeIncreasedStatement("exceptionInMethod = e");
            this.writeString("}finally{");
            this.increaseIdent();
            this.writeCommentLine("Concurrency control, client side - end");
            this.writeStatement(this.getCCStrategyVariableName(executableElement) + ".notifyClientSideCallFinished(diMeCallContext)");
            this.writeInterceptionBlock(InterceptionPhase.AFTER_SERVICE_CALL, executableElement);
            this.emptyline();
            this.closeBlock("finally");
            this.writeCommentLine("Failing");
            this.writeString("if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){");
            this.increaseIdent();
            this.writeStatement("FailDecision failDecision = " + this.getFailingStrategyVariableName(executableElement) + ".callFailed(diMeCallContext)");
            this.writeString("if (failDecision.getTargetService()!=null)");
            this.writeIncreasedStatement("diMeCallContext.setServiceId(failDecision.getTargetService())");
            this.writeString("switch(failDecision.getReaction()){");
            this.increaseIdent();
            this.writeString("case RETRY:");
            if (!this.isVoidReturn(executableElement)) {
                this.writeIncreasedStatement("return " + callToPrivate + "diMeCallContext.increaseCallCount())");
            } else {
                this.writeIncreasedStatement(callToPrivate + "diMeCallContext.increaseCallCount())");
                this.writeIncreasedStatement("return");
            }
            this.writeString("case RETRYONCE:");
            this.increaseIdent();
            this.writeCommentLine("Only retry if its the first call");
            this.writeString("if (!diMeCallContext.isFirstCall())");
            this.writeIncreasedStatement("break");
            if (!this.isVoidReturn(executableElement)) {
                this.writeStatement("return " + callToPrivate + "diMeCallContext.increaseCallCount())");
            } else {
                this.writeStatement(callToPrivate + "diMeCallContext.increaseCallCount())");
                this.writeStatement("return");
            }
            this.decreaseIdent();
            this.writeString("case FAIL:");
            this.writeString("default:");
            this.writeCommentLine("Fail or default is to do nothing at all and let the request fail");
            this.closeBlock("switch(failDecision)");
            this.closeBlock();
            this.writeCommentLine("fail through, if we are here, we must have had an exception before.");
            this.writeString("if (exceptionInMethod == null)");
            this.writeIncreasedStatement("throw new AssertionError(" + this.quote("Exception must have been thrown before, but it wasn't, framework error!") + ")");
            this.writeStatement("throw mapException(exceptionInMethod)");
            this.closeBlock();
            this.emptyline();
        }
        this.writeCommentLine("according to findbugs this method is never used, so we remove it for now reduce warnings.");
        this.emptyline();
        this.writeString("//private void notifyDelegateFailed(){");
        this.increaseIdent();
        this.writeStatement("//notifyDelegateFailed(" + StubGenerator.getConstantsName(type) + ".getServiceId())");
        this.decreaseIdent();
        this.writeString("//}");
        this.emptyline();
        this.writeString("private void notifyDelegateFailed(String serviceId){");
        this.increaseIdent();
        this.writeString("if (discoveryMode==DiscoveryMode.MANUAL){");
        this.writeIncreasedStatement("manuallySetTarget = null");
        this.writeIncreasedStatement("return");
        this.writeString("}");
        this.writeString("if (serviceId!=null)");
        this.writeIncreasedStatement("delegates.remove(serviceId)");
        this.closeBlock("notifyDelegateFailed");
        this.emptyline();
        this.writeString("private " + StubGenerator.getRemoteInterfaceName(type) + " getDelegate() throws NoConnectionToServerException{");
        this.increaseIdent();
        this.writeString("if (discoveryMode==DiscoveryMode.MANUAL){");
        this.increaseIdent();
        this.writeString("if (manuallySetTarget!=null)");
        this.writeIncreasedStatement("return manuallySetTarget");
        this.writeStatement("manuallySetTarget = lookup(manuallySetDescriptor)");
        this.writeStatement("return manuallySetTarget");
        this.closeBlock("if (mode==MANUAL)");
        this.writeStatement("return getDelegate(" + StubGenerator.getConstantsName(type) + ".getServiceId())");
        this.closeBlock();
        this.emptyline();
        this.writeString("private " + StubGenerator.getRemoteInterfaceName(type) + " getDelegate(String serviceId) throws NoConnectionToServerException{");
        this.increaseIdent();
        this.writeCommentLine("if no serviceId is provided, fallback to default resolve with manual mode");
        this.writeString("if (serviceId==null || discoveryMode==DiscoveryMode.MANUAL)");
        this.writeIncreasedStatement("return getDelegate()");
        this.writeStatement(StubGenerator.getRemoteInterfaceName(type) + " delegate = delegates.get(serviceId)");
        this.writeString("if (delegate==null){");
        this.increaseIdent();
        this.openTry();
        this.writeStatement("delegate = lookup(serviceId)");
        this.writeStatement(StubGenerator.getRemoteInterfaceName(type) + " existingDelegate = delegates.putIfAbsent(serviceId, delegate)");
        this.writeString("if (existingDelegate!=null)");
        this.writeIncreasedStatement("delegate = existingDelegate");
        this.decreaseIdent();
        this.writeString("}catch(Exception e){");
        this.writeCommentLine("//TODO - generate and throw typed exception.");
        this.writeIncreasedStatement("throw new NoConnectionToServerException(\"Couldn't lookup delegate because: \"+e.getMessage()+\" at \"+RegistryUtil.describeRegistry(), e)");
        this.writeString("}//try");
        this.closeBlock("first if (del==null) ");
        this.writeStatement("return delegate");
        this.closeBlock("fun");
        this.emptyline();
        this.writeString("private " + StubGenerator.getRemoteInterfaceName(type) + " lookup(String serviceId) throws NoConnectionToServerException{");
        this.increaseIdent();
        this.writeCommentLine("//first we need to lookup target host.");
        this.writeStatement("ServiceDescriptor toLookup = new ServiceDescriptor(Protocol.RMI, serviceId)");
        this.writeStatement("ServiceDescriptor targetService = RegistryUtil.resolve(toLookup)");
        this.writeString("if (targetService==null)");
        this.writeIncreasedStatement("throw new RuntimeException(" + this.quote("Can't resolve host for an instance of ") + "+" + StubGenerator.getConstantsName(type) + ".getServiceId())");
        this.writeStatement("Registry registry = null");
        this.openTry();
        this.writeStatement("registry = LocateRegistry.getRegistry(targetService.getHost(), targetService.getPort())");
        this.decreaseIdent();
        this.writeString("}catch(Exception e){");
        this.writeIncreasedStatement(logWriter.createErrorOutputWithException(this.quote("lookup - couldn't obtain rmi registry on ") + "+targetService+" + this.quote(", aborting lookup"), "e"));
        this.writeIncreasedStatement("throw new NoConnectionToServerException(" + this.quote("Can't resolve rmi registry for an instance of ") + "+" + StubGenerator.getConstantsName(type) + ".getServiceId())");
        this.writeString("}");
        this.openTry();
        this.writeStatement("return (" + StubGenerator.getRemoteInterfaceName(type) + ") registry.lookup(serviceId)");
        this.decreaseIdent();
        this.writeString("}catch(RemoteException e){");
        this.writeIncreasedStatement("throw new NoConnectionToServerException(" + this.quote("Can't lookup service in the target rmi registry for an instance of ") + "+serviceId, e)");
        this.writeString("}catch(NotBoundException e){");
        this.writeIncreasedStatement("throw new NoConnectionToServerException(" + this.quote("Can't lookup service in the target rmi registry for an instance of ") + "+serviceId, e)");
        this.writeString("}");
        this.closeBlock();
        this.emptyline();
        this.writeString("private " + StubGenerator.getRemoteInterfaceName(type) + " lookup(ServiceDescriptor serviceDescriptor) throws NoConnectionToServerException{");
        this.increaseIdent();
        this.writeStatement("Registry registry = null");
        this.openTry();
        this.writeStatement("registry = LocateRegistry.getRegistry(serviceDescriptor.getHost(), serviceDescriptor.getPort())");
        this.decreaseIdent();
        this.writeString("}catch(Exception e){");
        this.writeIncreasedStatement(logWriter.createErrorOutputWithException(this.quote("lookup - couldn't obtain rmi registry on ") + "+serviceDescriptor+" + this.quote(", aborting lookup"), "e"));
        this.writeIncreasedStatement("throw new NoConnectionToServerException(" + this.quote("Can't resolve rmi registry for ") + "+serviceDescriptor)");
        this.writeString("}");
        this.openTry();
        this.writeStatement(StubGenerator.getRemoteInterfaceName(type) + " ret = (" + StubGenerator.getRemoteInterfaceName(type) + ") registry.lookup(serviceDescriptor.getServiceId())");
        this.writeStatement("return ret");
        this.decreaseIdent();
        this.writeString("}catch(RemoteException e){");
        this.writeIncreasedStatement("throw new NoConnectionToServerException(" + this.quote("Can't lookup service in the target rmi registry for an instance of ") + "+serviceDescriptor, e)");
        this.writeString("}catch(NotBoundException e){");
        this.writeIncreasedStatement("throw new NoConnectionToServerException(" + this.quote("Can't lookup service in the target rmi registry for an instance of ") + "+serviceDescriptor, e)");
        this.writeString("}");
        this.closeBlock();
        this.emptyline();
        this.writeString("private " + DistributemeRuntimeException.class.getSimpleName() + " mapException(Exception in){");
        this.increaseIdent();
        this.writeString("if (in instanceof " + DistributemeRuntimeException.class.getSimpleName() + ")");
        this.writeIncreasedStatement("return (" + DistributemeRuntimeException.class.getSimpleName() + ") in");
        this.writeString("if (in instanceof " + RemoteException.class.getSimpleName() + ")");
        this.writeIncreasedStatement("return new " + ServiceUnavailableException.class.getSimpleName() + " (\"Service unavailable due to rmi failure: \"+in.getMessage(), in)");
        this.writeStatement("return new " + ServiceUnavailableException.class.getSimpleName() + "(\"Unexpected exception: \"+in.getMessage()+\" \" + in.getClass().getName(), in)");
        this.closeBlock();
        for (AbstractGenerator.TranslatedCCAnnotation translatedCCAnnotation : concurrencyControlAnnotations) {
            this.writeConcurrencyControlCreationMethod(translatedCCAnnotation);
        }
        for (AbstractGenerator.TranslatedRouterAnnotation translatedRouterAnnotation : routerAnnotations) {
            this.writeRouterCreationMethod(StubGenerator.getConstantsName(type) + ".getServiceId()", translatedRouterAnnotation);
        }
        this.closeBlock();
        writer.flush();
        writer.close();
    }

    private void writeInterceptionBlock(InterceptionPhase phase, ExecutableElement method) {
        boolean afterCall = phase == InterceptionPhase.AFTER_SERVICE_CALL;
        this.writeStatement("diMeInterceptionContext.setCurrentPhase(InterceptionPhase." + phase.toString() + ")");
        if (afterCall) {
            this.writeString("if (__fromServerSide!=null){");
            this.writeIncreasedStatement("diMeInterceptionContext.setReturnValue(__fromServerSide.get(0))");
            this.writeString("}");
            this.writeStatement("diMeInterceptionContext.setException(exceptionInMethod)");
            this.writeStatement("boolean diMeReturnOverriden = false");
        }
        this.writeString("for (ClientSideRequestInterceptor interceptor : diMeInterceptors){");
        this.increaseIdent();
        this.writeStatement("InterceptorResponse interceptorResponse = interceptor." + this.interceptionPhaseToMethod(phase) + "(diMeCallContext, diMeInterceptionContext)");
        this.writeString("switch(interceptorResponse.getCommand()){");
        this.writeString("case ABORT:");
        this.increaseIdent();
        this.writeString("if (interceptorResponse.getException() instanceof RuntimeException)");
        this.writeIncreasedStatement("throw (RuntimeException) interceptorResponse.getException()");
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            this.writeString("if (interceptorResponse.getException() instanceof " + typeMirror.toString() + ")");
            this.writeIncreasedStatement("throw (" + typeMirror.toString() + ") interceptorResponse.getException()");
        }
        this.writeStatement("throw new RuntimeException(" + this.quote("Interceptor exception") + ",interceptorResponse.getException())");
        this.decreaseIdent();
        this.writeString("case RETURN:");
        if (this.isVoidReturn(method)) {
            this.writeIncreasedStatement("return");
        } else {
            this.writeIncreasedStatement("return " + this.convertReturnValue(method.getReturnType(), "interceptorResponse.getReturnValue()"));
        }
        if (!this.isVoidReturn(method) && afterCall) {
            this.writeString("case OVERWRITE_RETURN_AND_CONTINUE:");
            this.writeIncreasedString("if (__fromServerSide == null)");
            this.increaseIdent();
            this.writeIncreasedStatement("throw new AssertionError(" + this.quote("Incorrect use of interceptor, there is no return value in this method or it is null") + ")");
            this.decreaseIdent();
            this.writeIncreasedStatement("__fromServerSide.set(0, interceptorResponse.getReturnValue())");
            this.writeIncreasedStatement("diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue())");
            this.writeIncreasedStatement("diMeReturnOverriden = true");
            this.writeIncreasedStatement("break");
        }
        this.writeString("case CONTINUE:");
        this.writeIncreasedStatement("break");
        this.writeString("case ABORT_AND_FAIL:");
        this.writeIncreasedStatement("abortAndFail = true");
        if (!afterCall) {
            this.writeIncreasedStatement("exceptionInMethod = new FailedByInterceptorException()");
        }
        this.writeIncreasedStatement("break");
        this.writeString("case RETURN_AND_FAIL:");
        this.writeCommentLine("Force failing logic to work.");
        if (!afterCall) {
            this.writeIncreasedStatement("diMeForceFailing = true");
            this.writeIncreasedStatement("exceptionInMethod = new FailedByInterceptorException()");
        }
        if (afterCall) {
            this.writeStatement(this.getFailingStrategyVariableName(method) + ".callFailed(diMeCallContext)");
        }
        this.writeIncreasedStatement("break");
        this.writeString("default:");
        this.writeIncreasedStatement("throw new IllegalStateException(" + this.quote("Unsupported or unexpected command from interceptor ") + " + interceptorResponse.getCommand()+ \" in phase:\"+diMeInterceptionContext.getCurrentPhase())");
        this.increaseIdent();
        this.closeBlock("switch");
        this.closeBlock("for");
        if (!this.isVoidReturn(method) && afterCall) {
            this.writeCommentLine("The next check for null of __fromServerSide is unneeded but for security reasons.");
            this.writeString("if (diMeReturnOverriden && __fromServerSide!=null)");
            this.writeIncreasedStatement("return " + this.convertReturnValue(method.getReturnType(), "__fromServerSide.get(0)"));
        }
    }
}

