/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.generator.jaxrs;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import net.anotheria.moskito.core.dynamic.MoskitoInvokationProxy;
import net.anotheria.moskito.core.logging.DefaultStatsLogger;
import net.anotheria.moskito.core.logging.IntervalStatsLogger;
import net.anotheria.moskito.core.logging.SL4JLogOutput;
import net.anotheria.moskito.core.predefined.ServiceStatsCallHandler;
import net.anotheria.moskito.core.predefined.ServiceStatsFactory;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.IProducerRegistryAPI;
import net.anotheria.moskito.core.registry.ProducerRegistryAPIFactory;
import net.anotheria.moskito.core.stats.DefaultIntervals;
import org.distributeme.annotation.DistributeMe;
import org.distributeme.core.Defaults;
import org.distributeme.core.ServerSideCallContext;
import org.distributeme.core.ServiceLocator;
import org.distributeme.core.Verbosity;
import org.distributeme.core.concurrencycontrol.ConcurrencyControlStrategy;
import org.distributeme.core.interceptor.InterceptionContext;
import org.distributeme.core.interceptor.InterceptionPhase;
import org.distributeme.core.interceptor.InterceptorRegistry;
import org.distributeme.core.interceptor.InterceptorResponse;
import org.distributeme.core.interceptor.ServerSideRequestInterceptor;
import org.distributeme.core.lifecycle.HealthStatus;
import org.distributeme.core.lifecycle.LifecycleAware;
import org.distributeme.core.util.VoidMarker;
import org.distributeme.generator.AbstractGenerator;
import org.distributeme.generator.Generator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceGenerator
extends AbstractGenerator
implements Generator {
    public ResourceGenerator(ProcessingEnvironment environment) {
        super(environment);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generate(TypeElement type, Filer filer, Map<String, String> options) throws IOException {
        JavaFileObject sourceFile = filer.createSourceFile(this.getPackageName(type) + "." + ResourceGenerator.getResourceName(type), new Element[0]);
        Writer writer = sourceFile.openWriter();
        this.setWriter(writer);
        DistributeMe ann = type.getAnnotation(DistributeMe.class);
        this.writePackage(type);
        this.writeAnalyzerComments(type);
        this.emptyline();
        this.writeImport(Logger.class);
        this.writeImport(LoggerFactory.class);
        this.writeImport(List.class);
        this.writeImport(Map.class);
        this.writeImport(ArrayList.class);
        this.writeImport(Collections.class);
        this.writeImport(Verbosity.class);
        this.writeImport(Defaults.class);
        this.writeImport(ServerSideCallContext.class);
        this.writeImport(ServerSideRequestInterceptor.class);
        this.writeImport(InterceptorResponse.class);
        this.writeImport(InterceptionContext.class);
        this.writeImport(InterceptorRegistry.class);
        this.writeImport(InterceptionPhase.class);
        this.writeImport(ConcurrencyControlStrategy.class);
        this.writeImport(ServiceLocator.class);
        if (ann.moskitoSupport()) {
            this.writeImport(MoskitoInvokationProxy.class);
            this.writeImport(DefaultStatsLogger.class);
            this.writeImport(IntervalStatsLogger.class);
            this.writeImport(SL4JLogOutput.class);
            this.writeImport(DefaultIntervals.class);
            this.writeImport(ServiceStatsCallHandler.class);
            this.writeImport(ServiceStatsFactory.class);
            this.writeImport(IProducerRegistryAPI.class);
            this.writeImport(ProducerRegistryAPIFactory.class);
            this.writeImport(IStatsProducer.class);
        }
        this.writeImport(MediaType.class);
        this.writeImport(Path.class);
        this.writeImport(POST.class);
        this.writeImport(Produces.class);
        this.writeImport(Consumes.class);
        this.emptyline();
        boolean lifecycleAware = false;
        List<? extends TypeMirror> superInterfaces = type.getInterfaces();
        for (TypeMirror typeMirror : superInterfaces) {
            if (!((Object)typeMirror).toString().equals("org.distributeme.core.lifecycle.LifecycleAware")) continue;
            lifecycleAware = true;
            break;
        }
        if (lifecycleAware) {
            this.writeImport(LifecycleAware.class);
            this.writeImport(HealthStatus.class);
        }
        this.writeString("@Path(\"/" + type.getSimpleName().toString() + "\")");
        this.writeString("@Produces(MediaType.APPLICATION_JSON)");
        this.writeString("@Consumes(MediaType.APPLICATION_JSON)");
        this.writeString("public class " + ResourceGenerator.getResourceName(type) + (lifecycleAware ? " implements  LifecycleAware" : "") + " {");
        this.increaseIdent();
        this.emptyline();
        this.writeStatement("private static Logger log = LoggerFactory.getLogger(" + ResourceGenerator.getResourceName(type) + ".class)");
        this.emptyline();
        this.writeStatement("private " + type.getQualifiedName() + " implementation");
        this.emptyline();
        this.writeStatement("private long lastAccess");
        this.writeStatement("private long created");
        this.emptyline();
        List<AbstractGenerator.TranslatedCCAnnotation> concurrencyControlAnnotations = this.writeConcurrencyControlDeclarations(type);
        this.writeString("public " + ResourceGenerator.getResourceName(type) + "(){");
        this.increaseIdent();
        this.writeStatement("this(ServiceLocator.getLocal(" + type.getQualifiedName() + ".class))");
        this.closeBlock();
        this.emptyline();
        this.writeString("public " + ResourceGenerator.getResourceName(type) + "(" + type.getQualifiedName() + " anImplementation){");
        this.increaseIdent();
        this.writeStatement("created = System.currentTimeMillis()");
        if (ann.moskitoSupport()) {
            this.writeString("MoskitoInvokationProxy proxy = new MoskitoInvokationProxy(");
            this.writeIncreasedString("anImplementation,");
            this.writeIncreasedString("new ServiceStatsCallHandler(),");
            this.writeIncreasedString("new ServiceStatsFactory(),");
            this.writeIncreasedString(this.quote(type.getSimpleName().toString()) + ", ");
            this.writeIncreasedString(this.quote("service") + ",");
            this.writeIncreasedString(this.quote("default") + ",");
            this.writeIncreasedString(this.getImplementedInterfacesAsString(type));
            this.writeString(");");
            this.writeStatement("implementation = (" + type.getQualifiedName() + ") proxy.createProxy()");
            this.writeString("// add moskito logger");
            this.writeStatement("new DefaultStatsLogger(proxy.getProducer(), new SL4JLogOutput(LoggerFactory.getLogger(\"moskito.custom.default\")))");
            this.writeStatement("new IntervalStatsLogger(proxy.getProducer(), DefaultIntervals.FIVE_MINUTES, new SL4JLogOutput(LoggerFactory.getLogger(\"moskito.custom.5m\")))");
            this.writeStatement("new IntervalStatsLogger(proxy.getProducer(), DefaultIntervals.FIFTEEN_MINUTES, new SL4JLogOutput(LoggerFactory.getLogger(\"moskito.custom.15m\")))");
            this.writeStatement("new IntervalStatsLogger(proxy.getProducer(), DefaultIntervals.ONE_HOUR, new SL4JLogOutput(LoggerFactory.getLogger(\"moskito.custom.1h\")))");
            this.writeStatement("new IntervalStatsLogger(proxy.getProducer(), DefaultIntervals.ONE_DAY, new SL4JLogOutput(LoggerFactory.getLogger(\"moskito.custom.1d\")))");
            this.writeString("//end moskito logger");
            this.writeCommentLine("//ADD LOGGING FOR ALL BUILTIN PRODUCERS");
            this.writeStatement("IProducerRegistryAPI api = new ProducerRegistryAPIFactory().createProducerRegistryAPI()");
            this.writeStatement("List<IStatsProducer> stats = api.getAllProducersBySubsystem(\"builtin\")");
            this.writeString("for (IStatsProducer producer : stats){");
            this.increaseIdent();
            this.writeStatement("new DefaultStatsLogger(producer, new SL4JLogOutput(LoggerFactory.getLogger(\"moskito.bi.default\")))");
            this.writeStatement("new IntervalStatsLogger(producer, DefaultIntervals.FIVE_MINUTES, new SL4JLogOutput(LoggerFactory.getLogger(\"moskito.bi.5m\")))");
            this.writeStatement("new IntervalStatsLogger(producer, DefaultIntervals.FIFTEEN_MINUTES, new SL4JLogOutput(LoggerFactory.getLogger(\"moskito.bi.15m\")))");
            this.writeStatement("new IntervalStatsLogger(producer, DefaultIntervals.ONE_HOUR, new SL4JLogOutput(LoggerFactory.getLogger(\"moskito.bi.1h\")))");
            this.writeStatement("new IntervalStatsLogger(producer, DefaultIntervals.ONE_DAY, new SL4JLogOutput(LoggerFactory.getLogger(\"moskito.bi.1d\")))");
            this.closeBlock();
        } else {
            this.writeStatement("implementation = anImplementation");
        }
        this.closeBlock();
        this.emptyline();
        Collection<? extends ExecutableElement> collection = this.getAllDeclaredMethods(type);
        for (ExecutableElement executableElement : collection) {
            void var17_20;
            String methodDecl = this.getResourceSkeletonMethodDeclaration(executableElement);
            List<? extends TypeMirror> exceptions = executableElement.getThrownTypes();
            this.writeString("@POST @Path(\"" + executableElement.getSimpleName() + "\")");
            this.writeString("public " + methodDecl + "{");
            this.increaseIdent();
            this.writeString("Map <?,?> __transportableCallContext = Collections.emptyMap(); //not used NOW!");
            this.writeStatement("lastAccess = System.currentTimeMillis()");
            this.writeStatement("ServerSideCallContext diMeCallContext = new ServerSideCallContext(" + this.quote(executableElement.getSimpleName()) + ", __transportableCallContext)");
            this.writeStatement("diMeCallContext.setServiceId(" + ResourceGenerator.getConstantsName(type) + ".getServiceId())");
            this.writeStatement("ArrayList<Object> diMeParameters = new ArrayList<Object>()");
            List<? extends VariableElement> parameters = executableElement.getParameters();
            for (VariableElement variableElement : parameters) {
                this.writeStatement("diMeParameters.add(" + variableElement.getSimpleName() + ")");
            }
            this.writeStatement("diMeCallContext.setParameters(diMeParameters)");
            this.writeStatement("InterceptionContext diMeInterceptionContext = new InterceptionContext()");
            this.writeCommentLine("Initialize interceptors");
            this.writeStatement("List<ServerSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors()");
            this.emptyline();
            this.writeStatement("ArrayList __return = new ArrayList()");
            this.emptyline();
            this.writeInterceptionBlock(InterceptionPhase.BEFORE_SERVANT_CALL, executableElement);
            this.writeCommentLine("Concurrency control, server side - ");
            this.writeStatement(this.getCCStrategyVariableName(executableElement) + ".notifyServerSideCallStarted(diMeCallContext)");
            this.emptyline();
            this.writeString("try{");
            this.increaseIdent();
            String call = "";
            if (!executableElement.getReturnType().toString().equals("void")) {
                call = call + "Object __result = ";
            }
            call = call + "implementation." + executableElement.getSimpleName();
            String string = "";
            for (VariableElement variableElement : parameters) {
                void var17_25;
                if (var17_20.length() != 0) {
                    String string2 = (String)var17_20 + ", ";
                }
                String string3 = (String)var17_25 + variableElement.getSimpleName();
            }
            call = call + "(" + (String)var17_20 + ");";
            this.writeString(call);
            if (executableElement.getReturnType().toString().equals("void")) {
                this.writeStatement("__return.add(" + VoidMarker.class.getName() + ".VOID)");
            } else {
                this.writeStatement("__return.add(__result)");
                this.writeStatement("diMeInterceptionContext.setReturnValue(__result)");
            }
            this.writeStatement("__return.add(diMeCallContext.getTransportableCallContext())");
            this.writeInterceptionBlock(InterceptionPhase.AFTER_SERVANT_CALL, executableElement);
            this.writeStatement("return __return");
            this.decreaseIdent();
            for (TypeMirror typeMirror : exceptions) {
                this.writeString("}catch(" + typeMirror.toString() + " e){");
                this.increaseIdent();
                this.writeString("if (Verbosity.logServerSideExceptions())");
                this.writeIncreasedStatement("log.error(" + this.quote(executableElement.getSimpleName() + "()") + ", e)");
                this.decreaseIdent();
                this.writeIncreasedStatement("throw(e)");
            }
            this.writeString("}finally{");
            this.writeIncreasedStatement(this.getCCStrategyVariableName(executableElement) + ".notifyServerSideCallFinished(diMeCallContext)");
            this.writeString("}");
            this.closeBlock();
            this.emptyline();
        }
        this.writeCommentLine("Service adapter methods");
        this.writeString("public long getCreationTimestamp(){ return created; }");
        this.writeString("public long getLastAccessTimestamp(){ return lastAccess; }");
        this.emptyline();
        if (lifecycleAware) {
            this.writeCommentLine("Support for LifecycleAware");
            this.writeString("public HealthStatus getHealthStatus(){ return implementation.getHealthStatus(); }");
        }
        for (AbstractGenerator.TranslatedCCAnnotation translatedCCAnnotation : concurrencyControlAnnotations) {
            this.writeConcurrencyControlCreationMethod(translatedCCAnnotation);
        }
        this.closeBlock();
        writer.flush();
        writer.close();
    }

    private void writeInterceptionBlock(InterceptionPhase phase, ExecutableElement method) {
        this.writeStatement("diMeInterceptionContext.setCurrentPhase(InterceptionPhase." + phase.toString() + ")");
        this.writeString("for (ServerSideRequestInterceptor interceptor : diMeInterceptors){");
        this.increaseIdent();
        this.writeStatement("InterceptorResponse interceptorResponse = interceptor." + this.interceptionPhaseToMethod(phase) + "(diMeCallContext, diMeInterceptionContext)");
        this.writeString("switch(interceptorResponse.getCommand()){");
        this.writeString("case ABORT:");
        this.increaseIdent();
        this.writeString("if (interceptorResponse.getException() instanceof RuntimeException)");
        this.writeIncreasedStatement("throw (RuntimeException) interceptorResponse.getException()");
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            this.writeString("if (interceptorResponse.getException() instanceof " + typeMirror.toString() + ")");
            this.writeIncreasedStatement("throw (" + typeMirror.toString() + ") interceptorResponse.getException()");
        }
        this.writeStatement("throw new RuntimeException(" + this.quote("Interceptor exception") + ",interceptorResponse.getException())");
        this.decreaseIdent();
        this.writeString("case RETURN:");
        this.writeIncreasedStatement("__return.set(0, interceptorResponse.getReturnValue())");
        this.writeIncreasedStatement("diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue())");
        this.writeIncreasedStatement("break");
        this.writeString("case OVERWRITE_RETURN_AND_CONTINUE:");
        this.writeIncreasedStatement("__return.set(0, interceptorResponse.getReturnValue())");
        this.writeIncreasedStatement("diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue())");
        this.writeIncreasedStatement("break");
        this.writeString("case CONTINUE:");
        this.writeIncreasedStatement("break");
        this.increaseIdent();
        this.closeBlock("switch");
        this.closeBlock("for");
    }
}

