/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.generator.ws;

import java.io.PrintWriter;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.distributeme.generator.ws.WSStructureGenerator;
import org.distributeme.generator.ws.WebServiceMeGenerator;

public class ConfigurationGenerator
extends WSStructureGenerator
implements WebServiceMeGenerator {
    public ConfigurationGenerator(ProcessingEnvironment filer) {
        super(filer);
    }

    @Override
    public void generate(TypeElement type) {
        PrintWriter writer = this.createTextFile(type.getSimpleName().toString(), ConfigurationGenerator.getMetaInfDir(), "MANIFEST", "MF");
        writer.print("Manifest-Version: 1.0\n");
        writer.print("Class-Path: \n");
        ConfigurationGenerator.closeWriter(writer);
        writer = this.createTextFile(type.getSimpleName().toString(), ConfigurationGenerator.getWebInfLibDir(), "readme", "txt");
        writer.print("Directory for project libraries");
        ConfigurationGenerator.closeWriter(writer);
        this.generateWebXml(type);
        this.generateSunJaxWsXml(type);
    }

    private void generateWebXml(Element type) {
        PrintWriter writer = this.createXmlFile(type.getSimpleName().toString(), ConfigurationGenerator.getWebInfDir(), "web");
        writer.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.print("<web-app id=\"WebApp_ID\" version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\"\n");
        writer.print("\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        writer.print("\txsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\">\n");
        writer.print("\t<display-name>" + type.getSimpleName().toString() + "</display-name>\n");
        writer.print("\t<listener>\n");
        writer.print("\t\t<listener-class>com.sun.xml.ws.transport.http.servlet.WSServletContextListener</listener-class>\n");
        writer.print("\t</listener>\n");
        writer.print("\t<servlet>\n");
        writer.print("\t\t<servlet-name>" + type.getSimpleName().toString() + "</servlet-name>\n");
        writer.print("\t\t<servlet-class>com.sun.xml.ws.transport.http.servlet.WSServlet</servlet-class>\n");
        writer.print("\t\t<load-on-startup>1</load-on-startup>\n");
        writer.print("\t</servlet>\n");
        writer.print("\t<servlet-mapping>\n");
        writer.print("\t\t<servlet-name>" + type.getSimpleName().toString() + "</servlet-name>\n");
        writer.print("\t\t<url-pattern>/" + type.getSimpleName().toString() + "</url-pattern>\n");
        writer.print("\t</servlet-mapping>\n");
        writer.print("</web-app>\n");
        ConfigurationGenerator.closeWriter(writer);
    }

    private void generateSunJaxWsXml(Element type) {
        PrintWriter writer = this.createXmlFile(type.getSimpleName().toString(), ConfigurationGenerator.getWebInfDir(), "sun-jaxws");
        writer.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.print("<endpoints xmlns='http://java.sun.com/xml/ns/jax-ws/ri/runtime' version='2.0'>\n");
        writer.print("\t<endpoint\n");
        writer.print("\t\tname='" + type.getSimpleName().toString() + "'\n");
        writer.print("\t\timplementation='" + this.getWSProxyName(type) + "'\n");
        writer.print("\t\turl-pattern='/" + type.getSimpleName().toString() + "'/>\n");
        writer.print("</endpoints>");
        ConfigurationGenerator.closeWriter(writer);
    }
}

