/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.generator.ws;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import net.anotheria.anoprise.metafactory.Extension;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.moskito.core.dynamic.MoskitoInvokationProxy;
import net.anotheria.moskito.core.logging.DefaultStatsLogger;
import net.anotheria.moskito.core.logging.IntervalStatsLogger;
import net.anotheria.moskito.core.logging.Log4JOutput;
import net.anotheria.moskito.core.predefined.ServiceStatsCallHandler;
import net.anotheria.moskito.core.predefined.ServiceStatsFactory;
import net.anotheria.moskito.core.stats.DefaultIntervals;
import org.distributeme.annotation.WebServiceMe;
import org.distributeme.generator.ws.WSStructureGenerator;
import org.distributeme.generator.ws.WebServiceMeGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceProxyGenerator
extends WSStructureGenerator
implements WebServiceMeGenerator {
    public ServiceProxyGenerator(ProcessingEnvironment environment) {
        super(environment);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generate(TypeElement type) {
        void var7_9;
        String[] initCode;
        PrintWriter writer = this.createSourceFile(type.getSimpleName().toString().toString(), this.getWSProxyPackage(type), ServiceProxyGenerator.getWSProxySimpleName(type));
        this.setWriter(writer);
        WebServiceMe ann = type.getAnnotation(WebServiceMe.class);
        this.writeString("package " + this.getWSProxyPackage(type) + ";");
        this.emptyline();
        this.writeImport(this.getPackageOf(type).getQualifiedName().toString(), type.getSimpleName().toString());
        this.writeImport(Logger.class);
        this.writeImport(LoggerFactory.class);
        if (ann.moskitoSupport()) {
            this.writeImport(MoskitoInvokationProxy.class);
            this.writeImport(DefaultStatsLogger.class);
            this.writeImport(IntervalStatsLogger.class);
            this.writeImport(Log4JOutput.class);
            this.writeImport(DefaultIntervals.class);
            this.writeImport(ServiceStatsCallHandler.class);
            this.writeImport(ServiceStatsFactory.class);
            this.writeImport(MetaFactory.class);
            this.writeImport(Extension.class);
            this.writeImport("javax.jws.WebService");
        }
        this.emptyline();
        this.writeString("@WebService");
        this.writeString("public class " + ServiceProxyGenerator.getWSProxySimpleName(type) + " implements " + type.getSimpleName().toString() + " {");
        this.increaseIdent();
        this.emptyline();
        this.writeStatement("private static final Logger LOGGER = Logger.getLogger(" + ServiceProxyGenerator.getWSProxySimpleName(type) + ".class)");
        this.emptyline();
        this.writeStatement("private " + type.getQualifiedName() + " implementation");
        this.emptyline();
        this.writeString("public " + ServiceProxyGenerator.getWSProxySimpleName(type) + "() {");
        this.increaseIdent();
        this.writeStatement("init()");
        if (ann.moskitoSupport()) {
            this.writeString("MoskitoInvokationProxy proxy = new MoskitoInvokationProxy(");
            this.writeIncreasedString("implementation,");
            this.writeIncreasedString("new ServiceStatsCallHandler(),");
            this.writeIncreasedString("new ServiceStatsFactory(),");
            this.writeIncreasedString(this.quote(type.getSimpleName().toString()) + ", ");
            this.writeIncreasedString(this.quote("service") + ",");
            this.writeIncreasedString(this.quote("default") + ",");
            this.writeIncreasedString(this.getImplementedInterfacesAsString(type));
            this.writeString(");");
            this.emptyline();
            this.writeStatement("implementation = (" + type.getQualifiedName() + ") proxy.createProxy()");
            this.emptyline();
            this.writeStatement("new DefaultStatsLogger(proxy.getProducer(), new Log4JOutput(Logger.getLogger(\"MoskitoDefault\")))");
            this.writeStatement("new IntervalStatsLogger(proxy.getProducer(), DefaultIntervals.FIVE_MINUTES, new Log4JOutput(Logger.getLogger(\"Moskito5m\")))");
            this.writeStatement("new IntervalStatsLogger(proxy.getProducer(), DefaultIntervals.FIFTEEN_MINUTES, new Log4JOutput(Logger.getLogger(\"Moskito15m\")))");
            this.writeStatement("new IntervalStatsLogger(proxy.getProducer(), DefaultIntervals.ONE_HOUR, new Log4JOutput(Logger.getLogger(\"Moskito1h\")))");
            this.writeStatement("new IntervalStatsLogger(proxy.getProducer(), DefaultIntervals.ONE_DAY, new Log4JOutput(Logger.getLogger(\"Moskito1d\")))");
        }
        this.closeBlock();
        this.emptyline();
        this.writeString("private void init() {");
        this.increaseIdent();
        this.writeString("try {");
        this.increaseIdent();
        String[] arr$ = initCode = ann.initcode();
        int len$ = arr$.length;
        boolean bl = false;
        while (var7_9 < len$) {
            String s = arr$[var7_9];
            this.writeString(s);
            ++var7_9;
        }
        this.decreaseIdent();
        this.writeIncreasedStatement("implementation = MetaFactory.get(" + type.getQualifiedName() + ".class);");
        this.writeString("} catch (Exception e) {");
        this.writeIncreasedStatement("LOGGER.error(\"init()\", e)");
        this.writeIncreasedStatement("throw new RuntimeException(e)");
        this.writeString("}");
        this.closeBlock();
        Collection<? extends ExecutableElement> methods = this.getAllDeclaredMethods(type);
        for (ExecutableElement executableElement : methods) {
            String methodDecl = this.getStubMethodDeclaration(executableElement);
            List<? extends TypeMirror> exceptions = executableElement.getThrownTypes();
            this.writeString("@Override");
            this.writeString("public " + methodDecl + " {");
            this.increaseIdent();
            if (exceptions.size() > 0) {
                this.writeString("try{");
                this.increaseIdent();
            }
            String call = "";
            if (!executableElement.getReturnType().toString().equals("void")) {
                call = call + "return ";
            }
            call = call + "implementation." + executableElement.getSimpleName();
            List<? extends VariableElement> parameters = executableElement.getParameters();
            String paramCall = "";
            for (VariableElement variableElement : parameters) {
                if (paramCall.length() != 0) {
                    paramCall = paramCall + ", ";
                }
                paramCall = paramCall + variableElement.getSimpleName();
            }
            call = call + "(" + paramCall + ");";
            this.writeString(call);
            if (exceptions.size() > 0) {
                this.decreaseIdent();
                for (TypeMirror typeMirror : exceptions) {
                    this.writeString("} catch (" + typeMirror.toString() + " e) {");
                    this.writeIncreasedStatement("LOGGER.error(" + this.quote(executableElement.getSimpleName() + "()") + ", e)");
                    this.writeIncreasedStatement("throw(e)");
                }
                this.writeString("}");
            }
            this.closeBlock();
            this.emptyline();
        }
        this.closeBlock();
        ServiceProxyGenerator.closeWriter(writer);
    }
}

