/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.processors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.distributeme.annotation.DistributeMe;
import org.distributeme.annotation.WebServiceMe;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.generator.GeneratorUtil;
import org.distributeme.generator.ws.ConfigurationGenerator;
import org.distributeme.generator.ws.ServiceProxyGenerator;
import org.distributeme.generator.ws.WebServiceMeGenerator;

public class GeneratorProcessorFactory
implements Processor {
    private static final Set<String> supportedAnnotations = new HashSet<String>(Arrays.asList("org.distributeme.annotation.DistributeMe", "org.distributeme.annotation.WebServiceMe"));
    private static final Set<String> supportedOptions = new HashSet<String>();
    private ProcessingEnvironment environment;
    private List<WebServiceMeGenerator> wsGenerators;

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        this.environment = processingEnv;
        this.wsGenerators = new ArrayList<WebServiceMeGenerator>();
        this.wsGenerators.add(new ServiceProxyGenerator(this.environment));
        this.wsGenerators.add(new ConfigurationGenerator(this.environment));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getRootElements()) {
            WebServiceMe wsAnnotation;
            DistributeMe annotation = element.getAnnotation(DistributeMe.class);
            if (!(element instanceof TypeElement)) continue;
            TypeElement type = (TypeElement)element;
            if (annotation != null) {
                if (Arrays.asList(annotation.protocols()).contains(ServiceDescriptor.Protocol.RMI)) {
                    try {
                        GeneratorUtil.generateRMI(type, this.environment);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (Arrays.asList(annotation.protocols()).contains(ServiceDescriptor.Protocol.JAXRS)) {
                    try {
                        GeneratorUtil.generateJAXRS(type, this.environment);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if ((wsAnnotation = type.getAnnotation(WebServiceMe.class)) == null) continue;
            for (WebServiceMeGenerator generator : this.wsGenerators) {
                generator.generate(type);
            }
        }
        return true;
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return null;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return supportedAnnotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_7;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return supportedOptions;
    }
}

