package org.distributeme.support.lifecycle.generated;
//CHECKSTYLE:OFF

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.Map;
import java.util.ArrayList;
import org.distributeme.core.Verbosity;
import org.distributeme.core.Defaults;
import org.distributeme.core.ServerSideCallContext;
import org.distributeme.core.interceptor.ServerSideRequestInterceptor;
import org.distributeme.core.interceptor.InterceptorResponse;
import org.distributeme.core.interceptor.InterceptionContext;
import org.distributeme.core.interceptor.InterceptorRegistry;
import org.distributeme.core.interceptor.InterceptionPhase;
import org.distributeme.core.concurrencycontrol.ConcurrencyControlStrategy;

// Generated by org.distributeme.generator.SkeletonGenerator
public class RemoteLifecycleSupportServiceSkeleton implements RemoteLifecycleSupportService {

	private static Logger log = LoggerFactory.getLogger(RemoteLifecycleSupportServiceSkeleton.class);

	private org.distributeme.support.lifecycle.LifecycleSupportService implementation;

	private long lastAccess;
	private long created;

	// CONCURRENCY CONTROL
	// Class wide concurrency control strategy 
	private ConcurrencyControlStrategy clazzWideCCStrategy = Defaults.getDefaultConcurrencyControlStrategy();

	private ConcurrencyControlStrategy isOnlineCCStrategy = clazzWideCCStrategy;
	private ConcurrencyControlStrategy printStatusToSystemOutCCStrategy = clazzWideCCStrategy;
	private ConcurrencyControlStrategy printStatusToLogInfoCCStrategy = clazzWideCCStrategy;
	private ConcurrencyControlStrategy getPublicServicesCCStrategy = clazzWideCCStrategy;
	private ConcurrencyControlStrategy registerPublicServiceCCStrategy_javalangStringarg0_orgdistributemecorelifecycleServiceAdapterarg1 = clazzWideCCStrategy;
	private ConcurrencyControlStrategy getServiceInfoCCStrategy_javalangStringarg0 = clazzWideCCStrategy;
	private ConcurrencyControlStrategy shutdownCCStrategy_javalangStringarg0 = clazzWideCCStrategy;
	private ConcurrencyControlStrategy getHealthStatusCCStrategy_javalangStringarg0 = clazzWideCCStrategy;
	private ConcurrencyControlStrategy getHealthStatusesCCStrategy = clazzWideCCStrategy;
	// CONCURRENCY CONTROL end

	public RemoteLifecycleSupportServiceSkeleton(){
		this(null);
	}

	public RemoteLifecycleSupportServiceSkeleton(org.distributeme.support.lifecycle.LifecycleSupportService anImplementation){
		created = System.currentTimeMillis();
		implementation = anImplementation;
	}

	public List isOnline(Map<?,?> __transportableCallContext){
		lastAccess = System.currentTimeMillis();
		ServerSideCallContext diMeCallContext = new ServerSideCallContext("isOnline", __transportableCallContext);
		diMeCallContext.setServiceId(LifecycleSupportServiceConstants.getServiceId());
		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeCallContext.setParameters(diMeParameters);
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Initialize interceptors
		List<ServerSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors();

		ArrayList __return = new ArrayList();

		diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVANT_CALL);
		for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
			InterceptorResponse interceptorResponse = interceptor.beforeServantCall(diMeCallContext, diMeInterceptionContext);
			switch(interceptorResponse.getCommand()){
			case ABORT:
				if (interceptorResponse.getException() instanceof RuntimeException)
					throw (RuntimeException) interceptorResponse.getException();
				throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
			case RETURN:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case OVERWRITE_RETURN_AND_CONTINUE:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case CONTINUE:
				break;
			} //...switch
		} //...for
		// Concurrency control, server side - 
		isOnlineCCStrategy.notifyServerSideCallStarted(diMeCallContext);

		try{
			Object __result = implementation.isOnline();
			__return.add(__result);
			diMeInterceptionContext.setReturnValue(__result);
			__return.add(diMeCallContext.getTransportableCallContext());
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVANT_CALL);
			for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServantCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case OVERWRITE_RETURN_AND_CONTINUE:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case CONTINUE:
					break;
				} //...switch
			} //...for
			return __return;
		}finally{
			isOnlineCCStrategy.notifyServerSideCallFinished(diMeCallContext);
		}
	}

	public List printStatusToSystemOut(Map<?,?> __transportableCallContext){
		lastAccess = System.currentTimeMillis();
		ServerSideCallContext diMeCallContext = new ServerSideCallContext("printStatusToSystemOut", __transportableCallContext);
		diMeCallContext.setServiceId(LifecycleSupportServiceConstants.getServiceId());
		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeCallContext.setParameters(diMeParameters);
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Initialize interceptors
		List<ServerSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors();

		ArrayList __return = new ArrayList();

		diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVANT_CALL);
		for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
			InterceptorResponse interceptorResponse = interceptor.beforeServantCall(diMeCallContext, diMeInterceptionContext);
			switch(interceptorResponse.getCommand()){
			case ABORT:
				if (interceptorResponse.getException() instanceof RuntimeException)
					throw (RuntimeException) interceptorResponse.getException();
				throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
			case RETURN:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case OVERWRITE_RETURN_AND_CONTINUE:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case CONTINUE:
				break;
			} //...switch
		} //...for
		// Concurrency control, server side - 
		printStatusToSystemOutCCStrategy.notifyServerSideCallStarted(diMeCallContext);

		try{
			implementation.printStatusToSystemOut();
			__return.add(org.distributeme.core.util.VoidMarker.VOID);
			__return.add(diMeCallContext.getTransportableCallContext());
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVANT_CALL);
			for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServantCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case OVERWRITE_RETURN_AND_CONTINUE:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case CONTINUE:
					break;
				} //...switch
			} //...for
			return __return;
		}finally{
			printStatusToSystemOutCCStrategy.notifyServerSideCallFinished(diMeCallContext);
		}
	}

	public List printStatusToLogInfo(Map<?,?> __transportableCallContext){
		lastAccess = System.currentTimeMillis();
		ServerSideCallContext diMeCallContext = new ServerSideCallContext("printStatusToLogInfo", __transportableCallContext);
		diMeCallContext.setServiceId(LifecycleSupportServiceConstants.getServiceId());
		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeCallContext.setParameters(diMeParameters);
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Initialize interceptors
		List<ServerSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors();

		ArrayList __return = new ArrayList();

		diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVANT_CALL);
		for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
			InterceptorResponse interceptorResponse = interceptor.beforeServantCall(diMeCallContext, diMeInterceptionContext);
			switch(interceptorResponse.getCommand()){
			case ABORT:
				if (interceptorResponse.getException() instanceof RuntimeException)
					throw (RuntimeException) interceptorResponse.getException();
				throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
			case RETURN:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case OVERWRITE_RETURN_AND_CONTINUE:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case CONTINUE:
				break;
			} //...switch
		} //...for
		// Concurrency control, server side - 
		printStatusToLogInfoCCStrategy.notifyServerSideCallStarted(diMeCallContext);

		try{
			implementation.printStatusToLogInfo();
			__return.add(org.distributeme.core.util.VoidMarker.VOID);
			__return.add(diMeCallContext.getTransportableCallContext());
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVANT_CALL);
			for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServantCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case OVERWRITE_RETURN_AND_CONTINUE:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case CONTINUE:
					break;
				} //...switch
			} //...for
			return __return;
		}finally{
			printStatusToLogInfoCCStrategy.notifyServerSideCallFinished(diMeCallContext);
		}
	}

	public List getPublicServices(Map<?,?> __transportableCallContext){
		lastAccess = System.currentTimeMillis();
		ServerSideCallContext diMeCallContext = new ServerSideCallContext("getPublicServices", __transportableCallContext);
		diMeCallContext.setServiceId(LifecycleSupportServiceConstants.getServiceId());
		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeCallContext.setParameters(diMeParameters);
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Initialize interceptors
		List<ServerSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors();

		ArrayList __return = new ArrayList();

		diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVANT_CALL);
		for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
			InterceptorResponse interceptorResponse = interceptor.beforeServantCall(diMeCallContext, diMeInterceptionContext);
			switch(interceptorResponse.getCommand()){
			case ABORT:
				if (interceptorResponse.getException() instanceof RuntimeException)
					throw (RuntimeException) interceptorResponse.getException();
				throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
			case RETURN:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case OVERWRITE_RETURN_AND_CONTINUE:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case CONTINUE:
				break;
			} //...switch
		} //...for
		// Concurrency control, server side - 
		getPublicServicesCCStrategy.notifyServerSideCallStarted(diMeCallContext);

		try{
			Object __result = implementation.getPublicServices();
			__return.add(__result);
			diMeInterceptionContext.setReturnValue(__result);
			__return.add(diMeCallContext.getTransportableCallContext());
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVANT_CALL);
			for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServantCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case OVERWRITE_RETURN_AND_CONTINUE:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case CONTINUE:
					break;
				} //...switch
			} //...for
			return __return;
		}finally{
			getPublicServicesCCStrategy.notifyServerSideCallFinished(diMeCallContext);
		}
	}

	public List registerPublicService(java.lang.String arg0, org.distributeme.core.lifecycle.ServiceAdapter arg1, Map<?,?> __transportableCallContext){
		lastAccess = System.currentTimeMillis();
		ServerSideCallContext diMeCallContext = new ServerSideCallContext("registerPublicService", __transportableCallContext);
		diMeCallContext.setServiceId(LifecycleSupportServiceConstants.getServiceId());
		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeParameters.add(arg0);
		diMeParameters.add(arg1);
		diMeCallContext.setParameters(diMeParameters);
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Initialize interceptors
		List<ServerSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors();

		ArrayList __return = new ArrayList();

		diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVANT_CALL);
		for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
			InterceptorResponse interceptorResponse = interceptor.beforeServantCall(diMeCallContext, diMeInterceptionContext);
			switch(interceptorResponse.getCommand()){
			case ABORT:
				if (interceptorResponse.getException() instanceof RuntimeException)
					throw (RuntimeException) interceptorResponse.getException();
				throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
			case RETURN:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case OVERWRITE_RETURN_AND_CONTINUE:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case CONTINUE:
				break;
			} //...switch
		} //...for
		// Concurrency control, server side - 
		registerPublicServiceCCStrategy_javalangStringarg0_orgdistributemecorelifecycleServiceAdapterarg1.notifyServerSideCallStarted(diMeCallContext);

		try{
			implementation.registerPublicService(arg0, arg1);
			__return.add(org.distributeme.core.util.VoidMarker.VOID);
			__return.add(diMeCallContext.getTransportableCallContext());
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVANT_CALL);
			for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServantCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case OVERWRITE_RETURN_AND_CONTINUE:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case CONTINUE:
					break;
				} //...switch
			} //...for
			return __return;
		}finally{
			registerPublicServiceCCStrategy_javalangStringarg0_orgdistributemecorelifecycleServiceAdapterarg1.notifyServerSideCallFinished(diMeCallContext);
		}
	}

	public List getServiceInfo(java.lang.String arg0, Map<?,?> __transportableCallContext){
		lastAccess = System.currentTimeMillis();
		ServerSideCallContext diMeCallContext = new ServerSideCallContext("getServiceInfo", __transportableCallContext);
		diMeCallContext.setServiceId(LifecycleSupportServiceConstants.getServiceId());
		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeParameters.add(arg0);
		diMeCallContext.setParameters(diMeParameters);
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Initialize interceptors
		List<ServerSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors();

		ArrayList __return = new ArrayList();

		diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVANT_CALL);
		for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
			InterceptorResponse interceptorResponse = interceptor.beforeServantCall(diMeCallContext, diMeInterceptionContext);
			switch(interceptorResponse.getCommand()){
			case ABORT:
				if (interceptorResponse.getException() instanceof RuntimeException)
					throw (RuntimeException) interceptorResponse.getException();
				throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
			case RETURN:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case OVERWRITE_RETURN_AND_CONTINUE:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case CONTINUE:
				break;
			} //...switch
		} //...for
		// Concurrency control, server side - 
		getServiceInfoCCStrategy_javalangStringarg0.notifyServerSideCallStarted(diMeCallContext);

		try{
			Object __result = implementation.getServiceInfo(arg0);
			__return.add(__result);
			diMeInterceptionContext.setReturnValue(__result);
			__return.add(diMeCallContext.getTransportableCallContext());
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVANT_CALL);
			for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServantCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case OVERWRITE_RETURN_AND_CONTINUE:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case CONTINUE:
					break;
				} //...switch
			} //...for
			return __return;
		}finally{
			getServiceInfoCCStrategy_javalangStringarg0.notifyServerSideCallFinished(diMeCallContext);
		}
	}

	public List shutdown(java.lang.String arg0, Map<?,?> __transportableCallContext){
		lastAccess = System.currentTimeMillis();
		ServerSideCallContext diMeCallContext = new ServerSideCallContext("shutdown", __transportableCallContext);
		diMeCallContext.setServiceId(LifecycleSupportServiceConstants.getServiceId());
		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeParameters.add(arg0);
		diMeCallContext.setParameters(diMeParameters);
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Initialize interceptors
		List<ServerSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors();

		ArrayList __return = new ArrayList();

		diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVANT_CALL);
		for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
			InterceptorResponse interceptorResponse = interceptor.beforeServantCall(diMeCallContext, diMeInterceptionContext);
			switch(interceptorResponse.getCommand()){
			case ABORT:
				if (interceptorResponse.getException() instanceof RuntimeException)
					throw (RuntimeException) interceptorResponse.getException();
				throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
			case RETURN:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case OVERWRITE_RETURN_AND_CONTINUE:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case CONTINUE:
				break;
			} //...switch
		} //...for
		// Concurrency control, server side - 
		shutdownCCStrategy_javalangStringarg0.notifyServerSideCallStarted(diMeCallContext);

		try{
			implementation.shutdown(arg0);
			__return.add(org.distributeme.core.util.VoidMarker.VOID);
			__return.add(diMeCallContext.getTransportableCallContext());
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVANT_CALL);
			for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServantCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case OVERWRITE_RETURN_AND_CONTINUE:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case CONTINUE:
					break;
				} //...switch
			} //...for
			return __return;
		}finally{
			shutdownCCStrategy_javalangStringarg0.notifyServerSideCallFinished(diMeCallContext);
		}
	}

	public List getHealthStatus(java.lang.String arg0, Map<?,?> __transportableCallContext){
		lastAccess = System.currentTimeMillis();
		ServerSideCallContext diMeCallContext = new ServerSideCallContext("getHealthStatus", __transportableCallContext);
		diMeCallContext.setServiceId(LifecycleSupportServiceConstants.getServiceId());
		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeParameters.add(arg0);
		diMeCallContext.setParameters(diMeParameters);
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Initialize interceptors
		List<ServerSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors();

		ArrayList __return = new ArrayList();

		diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVANT_CALL);
		for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
			InterceptorResponse interceptorResponse = interceptor.beforeServantCall(diMeCallContext, diMeInterceptionContext);
			switch(interceptorResponse.getCommand()){
			case ABORT:
				if (interceptorResponse.getException() instanceof RuntimeException)
					throw (RuntimeException) interceptorResponse.getException();
				throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
			case RETURN:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case OVERWRITE_RETURN_AND_CONTINUE:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case CONTINUE:
				break;
			} //...switch
		} //...for
		// Concurrency control, server side - 
		getHealthStatusCCStrategy_javalangStringarg0.notifyServerSideCallStarted(diMeCallContext);

		try{
			Object __result = implementation.getHealthStatus(arg0);
			__return.add(__result);
			diMeInterceptionContext.setReturnValue(__result);
			__return.add(diMeCallContext.getTransportableCallContext());
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVANT_CALL);
			for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServantCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case OVERWRITE_RETURN_AND_CONTINUE:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case CONTINUE:
					break;
				} //...switch
			} //...for
			return __return;
		}finally{
			getHealthStatusCCStrategy_javalangStringarg0.notifyServerSideCallFinished(diMeCallContext);
		}
	}

	public List getHealthStatuses(Map<?,?> __transportableCallContext){
		lastAccess = System.currentTimeMillis();
		ServerSideCallContext diMeCallContext = new ServerSideCallContext("getHealthStatuses", __transportableCallContext);
		diMeCallContext.setServiceId(LifecycleSupportServiceConstants.getServiceId());
		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeCallContext.setParameters(diMeParameters);
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Initialize interceptors
		List<ServerSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors();

		ArrayList __return = new ArrayList();

		diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVANT_CALL);
		for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
			InterceptorResponse interceptorResponse = interceptor.beforeServantCall(diMeCallContext, diMeInterceptionContext);
			switch(interceptorResponse.getCommand()){
			case ABORT:
				if (interceptorResponse.getException() instanceof RuntimeException)
					throw (RuntimeException) interceptorResponse.getException();
				throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
			case RETURN:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case OVERWRITE_RETURN_AND_CONTINUE:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case CONTINUE:
				break;
			} //...switch
		} //...for
		// Concurrency control, server side - 
		getHealthStatusesCCStrategy.notifyServerSideCallStarted(diMeCallContext);

		try{
			Object __result = implementation.getHealthStatuses();
			__return.add(__result);
			diMeInterceptionContext.setReturnValue(__result);
			__return.add(diMeCallContext.getTransportableCallContext());
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVANT_CALL);
			for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServantCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case OVERWRITE_RETURN_AND_CONTINUE:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case CONTINUE:
					break;
				} //...switch
			} //...for
			return __return;
		}finally{
			getHealthStatusesCCStrategy.notifyServerSideCallFinished(diMeCallContext);
		}
	}

	// Service adapter methods
	public long getCreationTimestamp(){ return created; }
	public long getLastAccessTimestamp(){ return lastAccess; }

}
