package org.distributeme.support.lifecycle.generated;
//CHECKSTYLE:OFF

import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import java.rmi.RemoteException;
import java.rmi.NotBoundException;
import org.distributeme.core.RegistryUtil;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.core.ServiceDescriptor.Protocol;
import org.distributeme.core.DiscoveryMode;
import org.distributeme.core.failing.FailingStrategy;
import org.distributeme.core.concurrencycontrol.ConcurrencyControlStrategy;
import org.distributeme.core.failing.FailDecision;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.exception.DistributemeRuntimeException;
import org.distributeme.core.exception.NoConnectionToServerException;
import org.distributeme.core.exception.ServiceUnavailableException;
import org.distributeme.core.Defaults;
import org.distributeme.core.interceptor.ClientSideRequestInterceptor;
import org.distributeme.core.interceptor.InterceptorRegistry;
import org.distributeme.core.interceptor.InterceptorResponse;
import org.distributeme.core.interceptor.InterceptionContext;
import org.distributeme.core.interceptor.InterceptionPhase;
import org.distributeme.core.interceptor.FailedByInterceptorException;

public class RemoteLifecycleSupportServiceStub implements org.distributeme.support.lifecycle.LifecycleSupportService{


	private volatile ConcurrentMap<String,RemoteLifecycleSupportService> delegates = new ConcurrentHashMap<String,RemoteLifecycleSupportService>();

	private DiscoveryMode discoveryMode = DiscoveryMode.AUTO;

	// ROUTER DECL V2
	// No class-wide-router set, skipping.

	// Method wide routers if applicable 
	// Method wide routers END 

	// ROUTER DECL V2 end

	// Failing
	// Class wide failing strategy 
	private FailingStrategy clazzWideFailingStrategy = Defaults.getDefaultFailingStrategy();

	private FailingStrategy isOnlineFailingStrategy = clazzWideFailingStrategy;
	private FailingStrategy printStatusToSystemOutFailingStrategy = clazzWideFailingStrategy;
	private FailingStrategy printStatusToLogInfoFailingStrategy = clazzWideFailingStrategy;
	private FailingStrategy getPublicServicesFailingStrategy = clazzWideFailingStrategy;
	private FailingStrategy registerPublicServiceFailingStrategy_javalangStringarg0_orgdistributemecorelifecycleServiceAdapterarg1 = clazzWideFailingStrategy;
	private FailingStrategy getServiceInfoFailingStrategy_javalangStringarg0 = clazzWideFailingStrategy;
	private FailingStrategy shutdownFailingStrategy_javalangStringarg0 = clazzWideFailingStrategy;
	private FailingStrategy getHealthStatusFailingStrategy_javalangStringarg0 = clazzWideFailingStrategy;
	private FailingStrategy getHealthStatusesFailingStrategy = clazzWideFailingStrategy;
	// Failing end

	// CONCURRENCY CONTROL
	// Class wide concurrency control strategy 
	private ConcurrencyControlStrategy clazzWideCCStrategy = Defaults.getDefaultConcurrencyControlStrategy();

	private ConcurrencyControlStrategy isOnlineCCStrategy = clazzWideCCStrategy;
	private ConcurrencyControlStrategy printStatusToSystemOutCCStrategy = clazzWideCCStrategy;
	private ConcurrencyControlStrategy printStatusToLogInfoCCStrategy = clazzWideCCStrategy;
	private ConcurrencyControlStrategy getPublicServicesCCStrategy = clazzWideCCStrategy;
	private ConcurrencyControlStrategy registerPublicServiceCCStrategy_javalangStringarg0_orgdistributemecorelifecycleServiceAdapterarg1 = clazzWideCCStrategy;
	private ConcurrencyControlStrategy getServiceInfoCCStrategy_javalangStringarg0 = clazzWideCCStrategy;
	private ConcurrencyControlStrategy shutdownCCStrategy_javalangStringarg0 = clazzWideCCStrategy;
	private ConcurrencyControlStrategy getHealthStatusCCStrategy_javalangStringarg0 = clazzWideCCStrategy;
	private ConcurrencyControlStrategy getHealthStatusesCCStrategy = clazzWideCCStrategy;
	// CONCURRENCY CONTROL end

	public RemoteLifecycleSupportServiceStub(){
		discoveryMode = DiscoveryMode.AUTO;
	}

	private ServiceDescriptor manuallySetDescriptor;
	private RemoteLifecycleSupportService manuallySetTarget;

	public RemoteLifecycleSupportServiceStub(ServiceDescriptor target){
		discoveryMode = DiscoveryMode.MANUAL;
		manuallySetDescriptor = target;
		try{
			manuallySetTarget = lookup(manuallySetDescriptor);
		}catch(NoConnectionToServerException e){
			throw new IllegalStateException("Can not resolve manually set reference", e);
		}
	}

	public boolean isOnline(){
		return isOnline((ClientSideCallContext)null);
	} //...public boolean isOnline()

	private boolean isOnline(org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("isOnline");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(LifecycleSupportServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Concurrency control, client side - start
		isOnlineCCStrategy.notifyClientSideCallStarted(diMeCallContext);

		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeCallContext.setParameters(diMeParameters);
		try{
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return ((Boolean)interceptorResponse.getReturnValue()).booleanValue();
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).isOnline( __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return ((Boolean)__fromServerSide.get(0)).booleanValue();
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			isOnlineCCStrategy.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return ((Boolean)interceptorResponse.getReturnValue()).booleanValue();
				case OVERWRITE_RETURN_AND_CONTINUE:
					if (__fromServerSide == null)
						throw new AssertionError("Incorrect use of interceptor, there is no return value in this method or it is null");
					__fromServerSide.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					diMeReturnOverriden = true;
					break;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				isOnlineFailingStrategy.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// The next check for null of __fromServerSide is unneeded but for security reasons.
			if (diMeReturnOverriden && __fromServerSide!=null)
				return ((Boolean)__fromServerSide.get(0)).booleanValue();

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = isOnlineFailingStrategy.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					return isOnline(diMeCallContext.increaseCallCount());
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					return isOnline(diMeCallContext.increaseCallCount());
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public void printStatusToSystemOut(){
		printStatusToSystemOut((ClientSideCallContext)null);
	} //...public void printStatusToSystemOut()

	private void printStatusToSystemOut(org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("printStatusToSystemOut");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(LifecycleSupportServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Concurrency control, client side - start
		printStatusToSystemOutCCStrategy.notifyClientSideCallStarted(diMeCallContext);

		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeCallContext.setParameters(diMeParameters);
		try{
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).printStatusToSystemOut( __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return;
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			printStatusToSystemOutCCStrategy.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				printStatusToSystemOutFailingStrategy.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = printStatusToSystemOutFailingStrategy.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					printStatusToSystemOut(diMeCallContext.increaseCallCount());
					return;
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					printStatusToSystemOut(diMeCallContext.increaseCallCount());
					return;
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public void printStatusToLogInfo(){
		printStatusToLogInfo((ClientSideCallContext)null);
	} //...public void printStatusToLogInfo()

	private void printStatusToLogInfo(org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("printStatusToLogInfo");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(LifecycleSupportServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Concurrency control, client side - start
		printStatusToLogInfoCCStrategy.notifyClientSideCallStarted(diMeCallContext);

		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeCallContext.setParameters(diMeParameters);
		try{
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).printStatusToLogInfo( __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return;
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			printStatusToLogInfoCCStrategy.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				printStatusToLogInfoFailingStrategy.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = printStatusToLogInfoFailingStrategy.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					printStatusToLogInfo(diMeCallContext.increaseCallCount());
					return;
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					printStatusToLogInfo(diMeCallContext.increaseCallCount());
					return;
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public java.util.List<java.lang.String> getPublicServices(){
		return getPublicServices((ClientSideCallContext)null);
	} //...public java.util.List<java.lang.String> getPublicServices()

	private java.util.List<java.lang.String> getPublicServices(org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("getPublicServices");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(LifecycleSupportServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Concurrency control, client side - start
		getPublicServicesCCStrategy.notifyClientSideCallStarted(diMeCallContext);

		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeCallContext.setParameters(diMeParameters);
		try{
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return (java.util.List<java.lang.String>) interceptorResponse.getReturnValue();
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).getPublicServices( __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return (java.util.List<java.lang.String>) __fromServerSide.get(0);
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			getPublicServicesCCStrategy.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return (java.util.List<java.lang.String>) interceptorResponse.getReturnValue();
				case OVERWRITE_RETURN_AND_CONTINUE:
					if (__fromServerSide == null)
						throw new AssertionError("Incorrect use of interceptor, there is no return value in this method or it is null");
					__fromServerSide.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					diMeReturnOverriden = true;
					break;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				getPublicServicesFailingStrategy.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// The next check for null of __fromServerSide is unneeded but for security reasons.
			if (diMeReturnOverriden && __fromServerSide!=null)
				return (java.util.List<java.lang.String>) __fromServerSide.get(0);

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = getPublicServicesFailingStrategy.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					return getPublicServices(diMeCallContext.increaseCallCount());
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					return getPublicServices(diMeCallContext.increaseCallCount());
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public void registerPublicService(java.lang.String arg0, org.distributeme.core.lifecycle.ServiceAdapter arg1){
		registerPublicService(arg0, arg1, (ClientSideCallContext)null);
	} //...public void registerPublicService(java.lang.String arg0, org.distributeme.core.lifecycle.ServiceAdapter arg1)

	private void registerPublicService(java.lang.String arg0, org.distributeme.core.lifecycle.ServiceAdapter arg1, org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("registerPublicService");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(LifecycleSupportServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Concurrency control, client side - start
		registerPublicServiceCCStrategy_javalangStringarg0_orgdistributemecorelifecycleServiceAdapterarg1.notifyClientSideCallStarted(diMeCallContext);

		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeParameters.add(arg0);
		diMeParameters.add(arg1);
		diMeCallContext.setParameters(diMeParameters);
		try{
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			arg0 = (java.lang.String) diMeParameters.get(0);
			arg1 = (org.distributeme.core.lifecycle.ServiceAdapter) diMeParameters.get(1);
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).registerPublicService(arg0, arg1,  __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return;
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			registerPublicServiceCCStrategy_javalangStringarg0_orgdistributemecorelifecycleServiceAdapterarg1.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				registerPublicServiceFailingStrategy_javalangStringarg0_orgdistributemecorelifecycleServiceAdapterarg1.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = registerPublicServiceFailingStrategy_javalangStringarg0_orgdistributemecorelifecycleServiceAdapterarg1.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					registerPublicService(arg0, arg1, diMeCallContext.increaseCallCount());
					return;
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					registerPublicService(arg0, arg1, diMeCallContext.increaseCallCount());
					return;
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public org.distributeme.core.lifecycle.ServiceInfo getServiceInfo(java.lang.String arg0){
		return getServiceInfo(arg0, (ClientSideCallContext)null);
	} //...public org.distributeme.core.lifecycle.ServiceInfo getServiceInfo(java.lang.String arg0)

	private org.distributeme.core.lifecycle.ServiceInfo getServiceInfo(java.lang.String arg0, org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("getServiceInfo");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(LifecycleSupportServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Concurrency control, client side - start
		getServiceInfoCCStrategy_javalangStringarg0.notifyClientSideCallStarted(diMeCallContext);

		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeParameters.add(arg0);
		diMeCallContext.setParameters(diMeParameters);
		try{
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return (org.distributeme.core.lifecycle.ServiceInfo) interceptorResponse.getReturnValue();
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			arg0 = (java.lang.String) diMeParameters.get(0);
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).getServiceInfo(arg0,  __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return (org.distributeme.core.lifecycle.ServiceInfo) __fromServerSide.get(0);
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			getServiceInfoCCStrategy_javalangStringarg0.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return (org.distributeme.core.lifecycle.ServiceInfo) interceptorResponse.getReturnValue();
				case OVERWRITE_RETURN_AND_CONTINUE:
					if (__fromServerSide == null)
						throw new AssertionError("Incorrect use of interceptor, there is no return value in this method or it is null");
					__fromServerSide.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					diMeReturnOverriden = true;
					break;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				getServiceInfoFailingStrategy_javalangStringarg0.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// The next check for null of __fromServerSide is unneeded but for security reasons.
			if (diMeReturnOverriden && __fromServerSide!=null)
				return (org.distributeme.core.lifecycle.ServiceInfo) __fromServerSide.get(0);

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = getServiceInfoFailingStrategy_javalangStringarg0.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					return getServiceInfo(arg0, diMeCallContext.increaseCallCount());
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					return getServiceInfo(arg0, diMeCallContext.increaseCallCount());
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public void shutdown(java.lang.String arg0){
		shutdown(arg0, (ClientSideCallContext)null);
	} //...public void shutdown(java.lang.String arg0)

	private void shutdown(java.lang.String arg0, org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("shutdown");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(LifecycleSupportServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Concurrency control, client side - start
		shutdownCCStrategy_javalangStringarg0.notifyClientSideCallStarted(diMeCallContext);

		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeParameters.add(arg0);
		diMeCallContext.setParameters(diMeParameters);
		try{
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			arg0 = (java.lang.String) diMeParameters.get(0);
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).shutdown(arg0,  __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return;
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			shutdownCCStrategy_javalangStringarg0.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				shutdownFailingStrategy_javalangStringarg0.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = shutdownFailingStrategy_javalangStringarg0.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					shutdown(arg0, diMeCallContext.increaseCallCount());
					return;
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					shutdown(arg0, diMeCallContext.increaseCallCount());
					return;
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public org.distributeme.core.lifecycle.HealthStatus getHealthStatus(java.lang.String arg0){
		return getHealthStatus(arg0, (ClientSideCallContext)null);
	} //...public org.distributeme.core.lifecycle.HealthStatus getHealthStatus(java.lang.String arg0)

	private org.distributeme.core.lifecycle.HealthStatus getHealthStatus(java.lang.String arg0, org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("getHealthStatus");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(LifecycleSupportServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Concurrency control, client side - start
		getHealthStatusCCStrategy_javalangStringarg0.notifyClientSideCallStarted(diMeCallContext);

		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeParameters.add(arg0);
		diMeCallContext.setParameters(diMeParameters);
		try{
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return (org.distributeme.core.lifecycle.HealthStatus) interceptorResponse.getReturnValue();
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			arg0 = (java.lang.String) diMeParameters.get(0);
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).getHealthStatus(arg0,  __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return (org.distributeme.core.lifecycle.HealthStatus) __fromServerSide.get(0);
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			getHealthStatusCCStrategy_javalangStringarg0.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return (org.distributeme.core.lifecycle.HealthStatus) interceptorResponse.getReturnValue();
				case OVERWRITE_RETURN_AND_CONTINUE:
					if (__fromServerSide == null)
						throw new AssertionError("Incorrect use of interceptor, there is no return value in this method or it is null");
					__fromServerSide.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					diMeReturnOverriden = true;
					break;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				getHealthStatusFailingStrategy_javalangStringarg0.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// The next check for null of __fromServerSide is unneeded but for security reasons.
			if (diMeReturnOverriden && __fromServerSide!=null)
				return (org.distributeme.core.lifecycle.HealthStatus) __fromServerSide.get(0);

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = getHealthStatusFailingStrategy_javalangStringarg0.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					return getHealthStatus(arg0, diMeCallContext.increaseCallCount());
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					return getHealthStatus(arg0, diMeCallContext.increaseCallCount());
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	public java.util.Map<java.lang.String,org.distributeme.core.lifecycle.HealthStatus> getHealthStatuses(){
		return getHealthStatuses((ClientSideCallContext)null);
	} //...public java.util.Map<java.lang.String,org.distributeme.core.lifecycle.HealthStatus> getHealthStatuses()

	private java.util.Map<java.lang.String,org.distributeme.core.lifecycle.HealthStatus> getHealthStatuses(org.distributeme.core.ClientSideCallContext diMeCallContext){
		List __fromServerSide = null;
		Exception exceptionInMethod = null;
		// This flag is used by the interceptor logic to mark a request es failed, even it is not.
		boolean diMeForceFailing = false;
		boolean abortAndFail = false;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("getHealthStatuses");
		if (discoveryMode == DiscoveryMode.MANUAL) {
			diMeCallContext.setServiceId(manuallySetDescriptor.getServiceId());
		}
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(LifecycleSupportServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Concurrency control, client side - start
		getHealthStatusesCCStrategy.notifyClientSideCallStarted(diMeCallContext);

		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeCallContext.setParameters(diMeParameters);
		try{
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return (java.util.Map<java.lang.String,org.distributeme.core.lifecycle.HealthStatus>) interceptorResponse.getReturnValue();
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
					diMeForceFailing = true;
					exceptionInMethod = new FailedByInterceptorException();
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// parse parameters again in case an interceptor modified them
			if (!abortAndFail){
				__fromServerSide = getDelegate(diMeCallContext.getServiceId()).getHealthStatuses( __transportableCallContext);
				__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
				return (java.util.Map<java.lang.String,org.distributeme.core.lifecycle.HealthStatus>) __fromServerSide.get(0);
			}
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
			// Concurrency control, client side - end
			getHealthStatusesCCStrategy.notifyClientSideCallFinished(diMeCallContext);
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
			if (__fromServerSide!=null){
				diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
			}
			diMeInterceptionContext.setException(exceptionInMethod);
			boolean diMeReturnOverriden = false;
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return (java.util.Map<java.lang.String,org.distributeme.core.lifecycle.HealthStatus>) interceptorResponse.getReturnValue();
				case OVERWRITE_RETURN_AND_CONTINUE:
					if (__fromServerSide == null)
						throw new AssertionError("Incorrect use of interceptor, there is no return value in this method or it is null");
					__fromServerSide.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					diMeReturnOverriden = true;
					break;
				case CONTINUE:
					break;
				case ABORT_AND_FAIL:
					abortAndFail = true;
					break;
				case RETURN_AND_FAIL:
				// Force failing logic to work.
				getHealthStatusesFailingStrategy.callFailed(diMeCallContext);
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// The next check for null of __fromServerSide is unneeded but for security reasons.
			if (diMeReturnOverriden && __fromServerSide!=null)
				return (java.util.Map<java.lang.String,org.distributeme.core.lifecycle.HealthStatus>) __fromServerSide.get(0);

		} //...finally
		// Failing
		if (exceptionInMethod!=null || diMeForceFailing || abortAndFail){
			FailDecision failDecision = getHealthStatusesFailingStrategy.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					return getHealthStatuses(diMeCallContext.increaseCallCount());
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					return getHealthStatuses(diMeCallContext.increaseCallCount());
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		if (exceptionInMethod == null)
			throw new AssertionError("Exception must have been thrown before, but it wasn't, framework error!");
		throw mapException(exceptionInMethod);
	}

	// according to findbugs this method is never used, so we remove it for now reduce warnings.

	//private void notifyDelegateFailed(){
		//notifyDelegateFailed(LifecycleSupportServiceConstants.getServiceId());
	//}

	private void notifyDelegateFailed(String serviceId){
		if (discoveryMode==DiscoveryMode.MANUAL){
			manuallySetTarget = null;
			return;
		}
		if (serviceId!=null)
			delegates.remove(serviceId);
	} //...notifyDelegateFailed

	private RemoteLifecycleSupportService getDelegate() throws NoConnectionToServerException{
		if (discoveryMode==DiscoveryMode.MANUAL){
			if (manuallySetTarget!=null)
				return manuallySetTarget;
			manuallySetTarget = lookup(manuallySetDescriptor);
			return manuallySetTarget;
		} //...if (mode==MANUAL)
		return getDelegate(LifecycleSupportServiceConstants.getServiceId());
	}

	private RemoteLifecycleSupportService getDelegate(String serviceId) throws NoConnectionToServerException{
		// if no serviceId is provided, fallback to default resolve with manual mode
		if (serviceId==null || discoveryMode==DiscoveryMode.MANUAL)
			return getDelegate();
		RemoteLifecycleSupportService delegate = delegates.get(serviceId);
		if (delegate==null){
			try{
				delegate = lookup(serviceId);
				RemoteLifecycleSupportService existingDelegate = delegates.putIfAbsent(serviceId, delegate);
				if (existingDelegate!=null)
					delegate = existingDelegate;
			}catch(Exception e){
			// //TODO - generate and throw typed exception.
				throw new NoConnectionToServerException("Couldn't lookup delegate because: "+e.getMessage()+" at "+RegistryUtil.describeRegistry(), e);
			}//try
		} //...first if (del==null) 
		return delegate;
	} //...fun

	private RemoteLifecycleSupportService lookup(String serviceId) throws NoConnectionToServerException{
		// //first we need to lookup target host.
		ServiceDescriptor toLookup = new ServiceDescriptor(Protocol.RMI, serviceId);
		ServiceDescriptor targetService = RegistryUtil.resolve(toLookup);
		if (targetService==null)
			throw new RuntimeException("Can't resolve host for an instance of "+LifecycleSupportServiceConstants.getServiceId());
		Registry registry = null;
		try{
			registry = LocateRegistry.getRegistry(targetService.getHost(), targetService.getPort());
		}catch(Exception e){
			System.err.println("lookup - couldn't obtain rmi registry on "+targetService+", aborting lookup"); e.printStackTrace();
			throw new NoConnectionToServerException("Can't resolve rmi registry for an instance of "+LifecycleSupportServiceConstants.getServiceId());
		}
		try{
			return (RemoteLifecycleSupportService) registry.lookup(serviceId);
		}catch(RemoteException e){
			throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of "+serviceId, e);
		}catch(NotBoundException e){
			throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of "+serviceId, e);
		}
	}

	private RemoteLifecycleSupportService lookup(ServiceDescriptor serviceDescriptor) throws NoConnectionToServerException{
		Registry registry = null;
		try{
			registry = LocateRegistry.getRegistry(serviceDescriptor.getHost(), serviceDescriptor.getPort());
		}catch(Exception e){
			System.err.println("lookup - couldn't obtain rmi registry on "+serviceDescriptor+", aborting lookup"); e.printStackTrace();
			throw new NoConnectionToServerException("Can't resolve rmi registry for "+serviceDescriptor);
		}
		try{
			RemoteLifecycleSupportService ret = (RemoteLifecycleSupportService) registry.lookup(serviceDescriptor.getServiceId());
			return ret;
		}catch(RemoteException e){
			throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of "+serviceDescriptor, e);
		}catch(NotBoundException e){
			throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of "+serviceDescriptor, e);
		}
	}

	private DistributemeRuntimeException mapException(Exception in){
		if (in instanceof DistributemeRuntimeException)
			return (DistributemeRuntimeException) in;
		if (in instanceof RemoteException)
			return new ServiceUnavailableException ("Service unavailable due to rmi failure: "+in.getMessage(), in);
		return new ServiceUnavailableException("Unexpected exception: "+in.getMessage()+" " + in.getClass().getName(), in);
	}
}
