/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.extensions.producers;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.inspection.CreationInfo;
import net.anotheria.moskito.core.inspection.Inspectable;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingOnDemandStatsProducer<S extends IStats>
implements IStatsProducer<S>,
Inspectable {
    private static Logger log = LoggerFactory.getLogger(RollingOnDemandStatsProducer.class);
    private IOnDemandStatsFactory<S> factory;
    private List<S> _cachedStatsList;
    private final ConcurrentLinkedHashMap<String, S> stats;
    private S linkToDefaultStats;
    private String category;
    private String producerId;
    private String subsystem;
    private CreationInfo creationInfo;

    public RollingOnDemandStatsProducer(String aProducerId, String aCategory, String aSubsystem, IOnDemandStatsFactory<S> aStatsFactory, int maxEntries) {
        this(aProducerId, aCategory, aSubsystem, aStatsFactory, maxEntries, maxEntries, 32);
    }

    public RollingOnDemandStatsProducer(String aProducerId, String aCategory, String aSubsystem, IOnDemandStatsFactory<S> aStatsFactory, int minEntries, int maxEntries, int concurrencyLevel) {
        this.category = aCategory;
        this.producerId = aProducerId;
        this.subsystem = aSubsystem;
        this.factory = aStatsFactory;
        if (this.factory == null) {
            throw new IllegalArgumentException("Null factory is not allowed.");
        }
        this.stats = new ConcurrentLinkedHashMap.Builder().initialCapacity(minEntries).maximumWeightedCapacity((long)maxEntries).concurrencyLevel(concurrencyLevel).listener(new EvictionListener<String, S>(){

            public void onEviction(String statName, S statObject) {
                RollingOnDemandStatsProducer.this._cachedStatsList.remove(statObject);
                statObject.destroy();
            }
        }).build();
        this._cachedStatsList = new CopyOnWriteArrayList<S>();
        this.linkToDefaultStats = this.factory.createStatsObject("cumulated");
        this._cachedStatsList.add(this.linkToDefaultStats);
        Exception e = new Exception();
        e.fillInStackTrace();
        this.creationInfo = new CreationInfo(e.getStackTrace());
    }

    public S getStats(String name) {
        IStats stat = (IStats)this.stats.get((Object)name);
        if (stat == null) {
            stat = this.factory.createStatsObject(name);
            IStats old = (IStats)this.stats.putIfAbsent((Object)name, (Object)stat);
            if (old == null) {
                this._cachedStatsList.add(stat);
            } else {
                stat.destroy();
                stat = old;
            }
        }
        return (S)stat;
    }

    public String getCategory() {
        return this.category == null ? "default" : this.category;
    }

    public String getProducerId() {
        return this.producerId;
    }

    public List<S> getStats() {
        return this._cachedStatsList;
    }

    public String getSubsystem() {
        return this.subsystem == null ? "default" : this.subsystem;
    }

    public S getDefaultStats() {
        return this.linkToDefaultStats;
    }

    public String toString() {
        return "RollingOnDemandStatsProducer: " + this.getProducerId() + ":" + this.getSubsystem() + ":" + this.getCategory();
    }

    protected List<S> getCachedStatsList() {
        return this._cachedStatsList;
    }

    public CreationInfo getCreationInfo() {
        return this.creationInfo;
    }
}

