/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.aop.aspect;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.anotheria.moskito.aop.annotation.Accumulate;
import net.anotheria.moskito.aop.annotation.Accumulates;
import net.anotheria.moskito.aop.aspect.MoskitoAspectConfiguration;
import net.anotheria.moskito.aop.util.MoskitoUtils;
import net.anotheria.moskito.core.accumulation.AccumulatorDefinition;
import net.anotheria.moskito.core.accumulation.AccumulatorRepository;
import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducer;
import net.anotheria.moskito.core.helper.TieableDefinition;
import net.anotheria.moskito.core.logging.DefaultStatsLogger;
import net.anotheria.moskito.core.logging.ILogOutput;
import net.anotheria.moskito.core.logging.IntervalStatsLogger;
import net.anotheria.moskito.core.logging.SLF4JLogOutput;
import net.anotheria.moskito.core.predefined.AbstractStatsFactory;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.util.annotation.AnnotationUtils;
import net.anotheria.util.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractMoskitoAspect<S extends IStats> {
    private static final char DOT = '.';
    private final ConcurrentMap<String, OnDemandStatsProducer<S>> producers = new ConcurrentHashMap<String, OnDemandStatsProducer<S>>();
    private final MoskitoAspectConfiguration config = MoskitoAspectConfiguration.getInstance();
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    protected OnDemandStatsProducer<S> getProducer(ProceedingJoinPoint pjp, String aProducerId, String aCategory, String aSubsystem, boolean withMethod, IOnDemandStatsFactory<S> factory, boolean tracingSupported) {
        return this.getProducer(pjp, aProducerId, aCategory, aSubsystem, withMethod, factory, tracingSupported, this.config.isAttachDefaultStatLoggers());
    }

    protected OnDemandStatsProducer<S> getProducer(ProceedingJoinPoint pjp, String aProducerId, String aCategory, String aSubsystem, boolean withMethod, IOnDemandStatsFactory<S> factory, boolean tracingSupported, boolean attachDefaultStatsLoggers) {
        String producerId = this.getProducerId(pjp, aProducerId, withMethod);
        OnDemandStatsProducer producer = (OnDemandStatsProducer)this.producers.get(producerId);
        if (producer != null) {
            return producer;
        }
        producer = new OnDemandStatsProducer(producerId, this.getCategory(aCategory), this.getSubsystem(aSubsystem), factory);
        producer.setTracingSupported(tracingSupported);
        OnDemandStatsProducer p = this.producers.putIfAbsent(producerId, producer);
        if (p != null) {
            return p;
        }
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer((IStatsProducer)producer);
        Class producerClass = pjp.getSignature().getDeclaringType();
        this.createClassLevelAccumulators(producer, producerClass);
        Method[] methodArray = producerClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            this.createMethodLevelAccumulators(producer, method);
            ++n2;
        }
        if (attachDefaultStatsLoggers) {
            this.attachLoggers(producer, factory);
        }
        return producer;
    }

    protected String getMethodStatName(Signature signature) {
        if (signature == null) {
            return null;
        }
        if (signature instanceof MethodSignature) {
            return AnnotationUtils.getMethodStatName((Method)((MethodSignature)signature).getMethod());
        }
        return signature.getName();
    }

    private void attachLoggers(OnDemandStatsProducer<S> producer, IOnDemandStatsFactory<S> factory) {
        new DefaultStatsLogger(producer, (ILogOutput)new SLF4JLogOutput(LoggerFactory.getLogger((String)this.config.getDefaultMoskitoLoggerName())));
        if (!(factory instanceof AbstractStatsFactory)) {
            return;
        }
        AbstractStatsFactory common = (AbstractStatsFactory)AbstractStatsFactory.class.cast(factory);
        Interval[] intervalArray = common.getIntervals();
        int n = intervalArray.length;
        int n2 = 0;
        while (n2 < n) {
            Interval interval = intervalArray[n2];
            String loggerName = this.config.getMoskitoLoggerName(interval.getName());
            if (!StringUtils.isEmpty((String)loggerName)) {
                new IntervalStatsLogger(producer, interval, (ILogOutput)new SLF4JLogOutput(LoggerFactory.getLogger((String)loggerName)));
            }
            ++n2;
        }
    }

    private String getProducerId(ProceedingJoinPoint pjp, String aPId, boolean withMethod) {
        String res;
        block4: {
            if (!StringUtils.isEmpty((String)aPId)) {
                return aPId;
            }
            res = pjp.getSignature().getDeclaringTypeName();
            try {
                res = MoskitoUtils.producerName(res);
            }
            catch (RuntimeException e) {
                if (!this.logger.isTraceEnabled()) break block4;
                this.logger.trace(e.getMessage(), (Throwable)e);
            }
        }
        if (withMethod) {
            res = String.valueOf(res) + '.' + this.getMethodStatName(pjp.getSignature());
        }
        return res;
    }

    private void createMethodLevelAccumulators(OnDemandStatsProducer<S> producer, Method method) {
        Accumulates accAnnotationHolderMethods = method.getAnnotation(Accumulates.class);
        if (accAnnotationHolderMethods != null) {
            Accumulate[] accAnnotations;
            Accumulate[] accumulateArray = accAnnotations = accAnnotationHolderMethods.value();
            int n = accAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                Accumulate accAnnotation = accumulateArray[n2];
                this.createAccumulator(producer.getProducerId(), accAnnotation, this.formAccumulatorNameForMethod(producer, accAnnotation, method), AnnotationUtils.getMethodStatName((Method)method));
                ++n2;
            }
        }
        this.createAccumulator(producer.getProducerId(), method.getAnnotation(Accumulate.class), this.formAccumulatorNameForMethod(producer, method.getAnnotation(Accumulate.class), method), AnnotationUtils.getMethodStatName((Method)method));
    }

    private void createClassLevelAccumulators(OnDemandStatsProducer<S> producer, Class producerClass) {
        Accumulates accAnnotationHolder = (Accumulates)AnnotationUtils.findAnnotation((AnnotatedElement)producerClass, Accumulates.class);
        if (accAnnotationHolder != null) {
            Accumulate[] accAnnotations;
            Accumulate[] accumulateArray = accAnnotations = accAnnotationHolder.value();
            int n = accAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                Accumulate accAnnotation = accumulateArray[n2];
                this.createAccumulator(producer.getProducerId(), accAnnotation, this.formAccumulatorNameForClass(producer, accAnnotation), "cumulated");
                ++n2;
            }
        }
        Accumulate annotation = (Accumulate)AnnotationUtils.findAnnotation((AnnotatedElement)producerClass, Accumulate.class);
        this.createAccumulator(producer.getProducerId(), annotation, this.formAccumulatorNameForClass(producer, annotation), "cumulated");
    }

    private String formAccumulatorNameForMethod(OnDemandStatsProducer<S> producer, Accumulate annotation, Method m) {
        if (producer == null || annotation == null || m == null) {
            return "";
        }
        return String.valueOf(producer.getProducerId()) + '.' + AnnotationUtils.getMethodStatName((Method)m) + '.' + annotation.valueName() + '.' + annotation.intervalName();
    }

    private String formAccumulatorNameForClass(OnDemandStatsProducer<S> producer, Accumulate annotation) {
        if (producer == null || annotation == null) {
            return "";
        }
        return String.valueOf(producer.getProducerId()) + '.' + annotation.valueName() + '.' + annotation.intervalName();
    }

    private void createAccumulator(String producerId, Accumulate annotation, String accName, String statsName) {
        if (annotation == null || StringUtils.isEmpty((String)producerId) || StringUtils.isEmpty((String)accName) || StringUtils.isEmpty((String)statsName)) {
            return;
        }
        AccumulatorDefinition definition = new AccumulatorDefinition();
        definition.setName(StringUtils.isEmpty((String)annotation.name()) ? accName : annotation.name());
        definition.setIntervalName(annotation.intervalName());
        definition.setProducerName(producerId);
        definition.setStatName(statsName);
        definition.setValueName(annotation.valueName());
        definition.setTimeUnit(annotation.timeUnit());
        AccumulatorRepository.getInstance().createAccumulator((TieableDefinition)definition);
    }

    public String getCategory(String proposal) {
        return StringUtils.isEmpty((String)proposal) ? "annotated" : proposal;
    }

    public String getSubsystem(String proposal) {
        return StringUtils.isEmpty((String)proposal) ? "default" : proposal;
    }

    public void reset() {
        this.producers.clear();
    }
}

