/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.aop.aspect;

import java.lang.reflect.InvocationTargetException;
import net.anotheria.moskito.aop.annotation.Count;
import net.anotheria.moskito.aop.annotation.CountByParameter;
import net.anotheria.moskito.aop.aspect.AbstractMoskitoAspect;
import net.anotheria.moskito.core.counter.CounterStats;
import net.anotheria.moskito.core.counter.CounterStatsFactory;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducer;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class CounterAspect
extends AbstractMoskitoAspect<CounterStats> {
    private static final CounterStatsFactory FACTORY = new CounterStatsFactory();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ CounterAspect ajc$perSingletonInstance;

    static {
        try {
            CounterAspect.ajc$perSingletonInstance = new CounterAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Around(value="execution(* *(..)) && (@annotation(method))")
    public Object countMethod(ProceedingJoinPoint pjp, Count method) throws Throwable {
        return this.count(pjp, method.producerId(), method.subsystem(), method.category());
    }

    @Around(value="execution(* *(..)) && (@annotation(method))")
    public Object countByParameter(ProceedingJoinPoint pjp, CountByParameter method) throws Throwable {
        return this.countByParameter(pjp, method.producerId(), method.subsystem(), method.category());
    }

    @Around(value="execution(* *.*(..)) && (@within(clazz))")
    public Object countClass(ProceedingJoinPoint pjp, Count clazz) throws Throwable {
        return this.count(pjp, clazz.producerId(), clazz.subsystem(), clazz.category());
    }

    private Object countByParameter(ProceedingJoinPoint pjp, String aProducerId, String aSubsystem, String aCategory) throws Throwable {
        OnDemandStatsProducer producer = this.getProducer(pjp, aProducerId, aCategory, aSubsystem, true, FACTORY, false);
        Object[] args = pjp.getArgs();
        String caseName = null;
        if (args != null && args[0] != null) {
            caseName = args[0].toString();
        }
        CounterStats defaultStats = (CounterStats)producer.getDefaultStats();
        CounterStats methodStats = null;
        if (caseName != null) {
            methodStats = (CounterStats)producer.getStats(caseName);
        }
        defaultStats.inc();
        if (methodStats != null) {
            methodStats.inc();
        }
        try {
            return pjp.proceed();
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private Object count(ProceedingJoinPoint pjp, String aProducerId, String aSubsystem, String aCategory) throws Throwable {
        OnDemandStatsProducer producer = this.getProducer(pjp, aProducerId, aCategory, aSubsystem, false, FACTORY, false);
        String methodName = this.getMethodStatName(pjp.getSignature());
        CounterStats defaultStats = (CounterStats)producer.getDefaultStats();
        CounterStats methodStats = (CounterStats)producer.getStats(methodName);
        defaultStats.inc();
        if (methodStats != null) {
            methodStats.inc();
        }
        try {
            return pjp.proceed();
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public static CounterAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("net.anotheria.moskito.aop.aspect.CounterAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

