/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.aop.aspect;

import java.lang.reflect.InvocationTargetException;
import net.anotheria.moskito.aop.aspect.AbstractMoskitoAspect;
import net.anotheria.moskito.core.calltrace.CurrentlyTracedCall;
import net.anotheria.moskito.core.calltrace.RunningTraceContainer;
import net.anotheria.moskito.core.calltrace.TraceStep;
import net.anotheria.moskito.core.calltrace.TracedCall;
import net.anotheria.moskito.core.calltrace.TracingUtil;
import net.anotheria.moskito.core.context.MoSKitoContext;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducer;
import net.anotheria.moskito.core.journey.Journey;
import net.anotheria.moskito.core.journey.JourneyManagerFactory;
import net.anotheria.moskito.core.predefined.ServiceStats;
import net.anotheria.moskito.core.predefined.ServiceStatsFactory;
import net.anotheria.moskito.core.tracer.Trace;
import net.anotheria.moskito.core.tracer.TracerRepository;
import net.anotheria.moskito.core.tracer.Tracers;
import org.aspectj.lang.ProceedingJoinPoint;

public class MonitoringBaseAspect
extends AbstractMoskitoAspect<ServiceStats> {
    protected static final ServiceStatsFactory FACTORY = new ServiceStatsFactory();
    protected static final ThreadLocal<String> lastProducerId = new ThreadLocal();

    protected Object doProfiling(ProceedingJoinPoint pjp, String aProducerId, String aSubsystem, String aCategory) throws Throwable {
        OnDemandStatsProducer producer = this.getProducer(pjp, aProducerId, aCategory, aSubsystem, false, FACTORY, true);
        String producerId = producer.getProducerId();
        String prevProducerId = lastProducerId.get();
        lastProducerId.set(producerId);
        String methodName = this.getMethodStatName(pjp.getSignature());
        ServiceStats defaultStats = (ServiceStats)producer.getDefaultStats();
        ServiceStats methodStats = (ServiceStats)producer.getStats(methodName);
        Object[] args = pjp.getArgs();
        defaultStats.addRequest();
        if (methodStats != null) {
            methodStats.addRequest();
        }
        TracedCall aRunningTrace = RunningTraceContainer.getCurrentlyTracedCall();
        TraceStep currentStep = null;
        CurrentlyTracedCall currentTrace = aRunningTrace.callTraced() ? (CurrentlyTracedCall)aRunningTrace : null;
        MoSKitoContext context = MoSKitoContext.get();
        TracerRepository tracerRepository = TracerRepository.getInstance();
        boolean tracePassingOfThisProducer = context.hasTracerFired() ? false : tracerRepository.isTracingEnabledForProducer(producerId);
        Trace trace = null;
        boolean journeyStartedByMe = false;
        if (tracePassingOfThisProducer) {
            trace = new Trace();
            context.setTracerFired();
        }
        if (currentTrace == null && tracePassingOfThisProducer) {
            String journeyCallName = Tracers.getCallName((Trace)trace);
            RunningTraceContainer.startTracedCall((String)journeyCallName);
            journeyStartedByMe = true;
            currentTrace = (CurrentlyTracedCall)RunningTraceContainer.getCurrentlyTracedCall();
        }
        StringBuilder call = null;
        if (currentTrace != null || tracePassingOfThisProducer) {
            call = TracingUtil.buildCall((String)producerId, (String)methodName, (Object[])args, (String)(tracePassingOfThisProducer ? Tracers.getCallName((Trace)trace) : null));
        }
        if (currentTrace != null) {
            currentStep = currentTrace.startStep(call.toString(), producer);
        }
        long startTime = System.nanoTime();
        Object ret = null;
        try {
            Object object = ret = pjp.proceed();
            return object;
        }
        catch (InvocationTargetException e) {
            defaultStats.notifyError(e.getTargetException());
            if (methodStats != null) {
                methodStats.notifyError();
            }
            if (currentStep != null) {
                currentStep.setAborted();
            }
            throw e.getCause();
        }
        catch (Throwable t) {
            defaultStats.notifyError(t);
            if (methodStats != null) {
                methodStats.notifyError();
            }
            if (currentStep != null) {
                currentStep.setAborted();
            }
            if (tracePassingOfThisProducer) {
                call.append(" ERR ").append(t.getMessage());
            }
            throw t;
        }
        finally {
            long exTime = System.nanoTime() - startTime;
            if (!producerId.equals(prevProducerId)) {
                defaultStats.addExecutionTime(exTime);
            }
            if (methodStats != null) {
                methodStats.addExecutionTime(exTime);
            }
            lastProducerId.set(prevProducerId);
            defaultStats.notifyRequestFinished();
            if (methodStats != null) {
                methodStats.notifyRequestFinished();
            }
            if (currentStep != null) {
                currentStep.setDuration(exTime);
                try {
                    currentStep.appendToCall(" = " + TracingUtil.parameter2string((Object)ret));
                }
                catch (Throwable t) {
                    currentStep.appendToCall(" = ERR: " + t.getMessage() + " (" + t.getClass() + ')');
                }
            }
            if (currentTrace != null) {
                currentTrace.endStep();
            }
            if (tracePassingOfThisProducer) {
                call.append(" = ").append((CharSequence)TracingUtil.parameter2string((Object)ret));
                trace.setCall(call.toString());
                trace.setDuration(exTime);
                trace.setElements(Thread.currentThread().getStackTrace());
                if (journeyStartedByMe) {
                    Journey myJourney = JourneyManagerFactory.getJourneyManager().getOrCreateJourney(Tracers.getJourneyNameForTracers((String)producerId));
                    myJourney.addUseCase((CurrentlyTracedCall)RunningTraceContainer.endTrace());
                    RunningTraceContainer.cleanup();
                }
                tracerRepository.addTracedExecution(producerId, trace);
            }
        }
    }
}

