/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.aop.aspect;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.anotheria.util.StringUtils;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.configureme.annotations.DontConfigure;
import org.slf4j.LoggerFactory;

@ConfigureMe(name="moskito-aspect-config")
public final class MoskitoAspectConfiguration
implements Serializable {
    private static final long serialVersionUID = -7486675881930422282L;
    @Configure
    private AspectLoggerConfigHolder intervalLogger = new AspectLoggerConfigHolder();

    public static MoskitoAspectConfiguration getInstance() {
        return MoskitoConfigurationHolder.CONFIG.getInstance();
    }

    @AfterConfiguration
    public synchronized void init() {
        this.intervalLogger.init();
    }

    public String getDefaultMoskitoLoggerName() {
        return this.intervalLogger.getDefaultMoskitoLoggerName();
    }

    public boolean isAttachDefaultStatLoggers() {
        return this.intervalLogger.isAttachDefaultStatLoggers();
    }

    public String getMoskitoLoggerName(String intervalName) {
        return this.intervalLogger.getMoskitoLoggerName(intervalName);
    }

    public static long getSerialVersionUID() {
        return -7486675881930422282L;
    }

    public AspectLoggerConfigHolder getIntervalLogger() {
        return this.intervalLogger;
    }

    public void setIntervalLogger(AspectLoggerConfigHolder intervalLogger) {
        if (intervalLogger == null) {
            return;
        }
        this.intervalLogger = intervalLogger;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MoskitoAspectConfiguration{");
        sb.append("intervalLogger='").append(this.intervalLogger).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static class AspectLoggerConfigHolder
    implements Serializable {
        private static final long serialVersionUID = -7973226041037384967L;
        @DontConfigure
        private static final String DEFAULT_MOSKITO_LOG_PREFIX = "Moskito";
        @DontConfigure
        private static final String DEFAULT_INTERVAL_SUFFIX = "Default";
        @Configure
        private String defaultMoskitoLoggerName = "MoskitoDefault";
        @Configure
        private boolean attachDefaultStatLoggers = false;
        @Configure
        private LoggerConfig[] loggers;
        @DontConfigure
        private volatile Map<String, LoggerConfig> loggersStorage = new HashMap<String, LoggerConfig>();

        void init() {
            HashMap<String, LoggerConfig> data = new HashMap<String, LoggerConfig>();
            if (this.loggers == null || this.loggers.length == 0) {
                this.loggersStorage = data;
                return;
            }
            LoggerConfig[] loggerConfigArray = this.loggers;
            int n = this.loggers.length;
            int n2 = 0;
            while (n2 < n) {
                LoggerConfig cnf = loggerConfigArray[n2];
                if (cnf != null && !StringUtils.isEmpty((String)cnf.getIntervalName()) && !StringUtils.isEmpty((String)cnf.getLoggerName())) {
                    data.put(cnf.getIntervalName(), cnf);
                }
                ++n2;
            }
            this.loggersStorage = data;
        }

        public String getDefaultMoskitoLoggerName() {
            return this.defaultMoskitoLoggerName;
        }

        public void setDefaultMoskitoLoggerName(String defaultMoskitoLoggerName) {
            if (StringUtils.isEmpty((String)defaultMoskitoLoggerName)) {
                return;
            }
            this.defaultMoskitoLoggerName = defaultMoskitoLoggerName;
        }

        public boolean isAttachDefaultStatLoggers() {
            return this.attachDefaultStatLoggers;
        }

        public void setAttachDefaultStatLoggers(boolean attachDefaultStatLoggers) {
            this.attachDefaultStatLoggers = attachDefaultStatLoggers;
        }

        public LoggerConfig[] getLoggers() {
            return this.loggers;
        }

        public void setLoggers(LoggerConfig[] loggers) {
            if (loggers != null) {
                this.loggers = loggers;
            }
        }

        public String getMoskitoLoggerName(String intervalName) {
            if (StringUtils.isEmpty((String)intervalName)) {
                return null;
            }
            LoggerConfig config = this.loggersStorage.get(intervalName);
            return config == null ? DEFAULT_MOSKITO_LOG_PREFIX + intervalName : config.getLoggerName();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("AspectLoggerConfig{");
            sb.append("defaultMoskitoLoggerName='").append(this.defaultMoskitoLoggerName).append('\'');
            sb.append(", attachDefaultStatLoggers=").append(this.attachDefaultStatLoggers);
            sb.append(", intervalLogger=").append(Arrays.toString(this.loggers));
            sb.append(", loggersStorage=").append(this.loggersStorage);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class LoggerConfig
    implements Serializable {
        private static final long serialVersionUID = 5231263161891368289L;
        @Configure
        private String intervalName;
        @Configure
        private String loggerName;

        private LoggerConfig() {
        }

        public String getIntervalName() {
            return this.intervalName;
        }

        public void setIntervalName(String intervalName) {
            this.intervalName = intervalName;
        }

        public String getLoggerName() {
            return this.loggerName;
        }

        public void setLoggerName(String loggerName) {
            this.loggerName = loggerName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("LoggerConfig{");
            sb.append("intervalName='").append(this.intervalName).append('\'');
            sb.append(", loggerName='").append(this.loggerName).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    private static enum MoskitoConfigurationHolder {
        CONFIG;

        private final MoskitoAspectConfiguration instance = new MoskitoAspectConfiguration();

        private MoskitoConfigurationHolder() {
            try {
                ConfigurationManager.INSTANCE.configure((Object)this.instance);
            }
            catch (RuntimeException e) {
                LoggerFactory.getLogger(MoskitoConfigurationHolder.class).info("Failed to configure! Relying on defaults! [" + e.getMessage() + "]");
            }
        }

        public MoskitoAspectConfiguration getInstance() {
            return this.instance;
        }
    }
}

