package net.anotheria.moskito.central.endpoints.rmi.generated;
//CHECKSTYLE:OFF

import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import java.rmi.server.UnicastRemoteObject;
import java.security.Permission;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.distributeme.core.RegistryUtil;
import org.distributeme.core.RegistryLocation;
import java.rmi.server.ExportException;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.core.ServiceDescriptor.Protocol;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.FactoryNotFoundException;
import net.anotheria.anoprise.metafactory.Extension;
import net.anotheria.util.PidTools;
import net.anotheria.util.IdCodeGenerator;
import org.distributeme.core.RMIRegistryUtil;
import java.rmi.RemoteException;
import net.anotheria.anoprise.metafactory.ServiceFactory;
import org.distributeme.core.lifecycle.LifecycleComponentImpl;
import org.distributeme.core.Verbosity;
import org.distributeme.core.SystemPropertyNames;
import org.distributeme.core.ServerShutdownHook;
import org.distributeme.core.conventions.SystemProperties;
import java.util.List;

import org.distributeme.support.lifecycle.generated.LifecycleSupportServer;
import org.distributeme.support.eventservice.generated.EventServiceRMIBridgeServer;
public class RMIEndpointServer{

	private static Logger log;

	public static void main(String a[]) throws Exception{
		DOMConfigurator.configureAndWatch("/log4j.xml");
		if (System.getSecurityManager()==null)
			System.setSecurityManager(new SecurityManager(){
				public void checkPermission(Permission perm) { }
			});
		try {
			init();
			// Log current server PID (Process Id)
			PidTools.logPid();
			// force verbosity to configure itself
			Verbosity.logServerSideExceptions();
			createSupportServicesAndRegisterLocally();
			createServiceAndRegisterLocally();
			startService();
			notifyListenersAboutStart();
		} catch (Throwable e) {
			log.fatal("Unhandled exception caught", e);
			System.err.println(e.getMessage());
			System.exit(-4);
		}
	} //...main

	private static final List<org.distributeme.core.listener.ServerLifecycleListener> serverListeners = new java.util.ArrayList<org.distributeme.core.listener.ServerLifecycleListener>(0);
	private static void notifyListenersAboutStart(){
		// configured listeners
		List<org.distributeme.core.listener.ServerLifecycleListener> configuredListeners = org.distributeme.core.listener.ListenerRegistry.getInstance().getServerLifecycleListeners();
		if (configuredListeners!=null && configuredListeners.size()>0){
			for (org.distributeme.core.listener.ServerLifecycleListener listener : configuredListeners){
				try{
					listener.afterStart();
				}catch(Exception e){
					log.error("Couldn't call afterStart on  listener " + listener, e);
				}
			} //...for
		} //...if
	} //...notifyListenersAboutStart

	public static void init() throws Exception{
		log = Logger.getLogger(RMIEndpointServer.class);
		// // CUSTOM CODE STARTED
		// // CUSTOM CODE ENDED
	} //...init

	// Have to keep local reference to the rmiServant and skeleton to prevent gc removal
	private static RemoteRMIEndpointService skeleton = null;
	private static RemoteRMIEndpointService rmiServant = null;
	private static String serviceId = null;

	public static void createServiceAndRegisterLocally() throws Exception{
		// creating impl
		// No factory specified
		try{
			Class<ServiceFactory<net.anotheria.moskito.central.endpoints.rmi.RMIEndpointService>> factoryClazz = (Class<ServiceFactory<net.anotheria.moskito.central.endpoints.rmi.RMIEndpointService>>)Class.forName("net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceFactory");
			MetaFactory.addFactoryClass(net.anotheria.moskito.central.endpoints.rmi.RMIEndpointService.class, Extension.LOCAL, factoryClazz);
		}catch(ClassNotFoundException factoryNotFound){
			try{
				// Even more convinient - try to instantiate the implementation directly
				Class<? extends net.anotheria.moskito.central.endpoints.rmi.RMIEndpointService> implClazz = (Class<? extends net.anotheria.moskito.central.endpoints.rmi.RMIEndpointService>)Class.forName("net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceImpl");
				MetaFactory.createOnTheFlyFactory(net.anotheria.moskito.central.endpoints.rmi.RMIEndpointService.class, Extension.LOCAL, implClazz.newInstance());
			}catch(ClassNotFoundException implNotFound){
				log.info("Giving up trying to find an impl instance, tried net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceFactory and net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceImpl, expect start to fail since init code were empty too and no factory has been supplied explicitely");
			} //...inner catch
		} //...outer catch
		net.anotheria.moskito.central.endpoints.rmi.RMIEndpointService impl = null;
		try{
			impl = MetaFactory.get(net.anotheria.moskito.central.endpoints.rmi.RMIEndpointService.class, Extension.LOCAL);
		}catch (FactoryNotFoundException factoryNotFound){
			throw new AssertionError("Un- or mis-configured, can't instantiate service instance for net.anotheria.moskito.central.endpoints.rmi.RMIEndpointService tried initcode, submitted factory, autoguessed factory (net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceFactory) and impl class (net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceImpl)");
		}
		skeleton = new RemoteRMIEndpointServiceSkeleton(impl);
		rmiServant = (RemoteRMIEndpointService) UnicastRemoteObject.exportObject(skeleton, 0);
		serviceId = RMIEndpointServiceConstants.getServiceId();

		String regNameProviderClass = System.getProperty(SystemPropertyNames.REGISTRATION_NAME_PROVIDER);
		if (regNameProviderClass!=null){
			org.distributeme.core.routing.RegistrationNameProvider suppliedNameProvider = (org.distributeme.core.routing.RegistrationNameProvider)Class.forName(regNameProviderClass).newInstance();
			serviceId = suppliedNameProvider.getRegistrationName(serviceId);
		} //...if (regNameProviderClass!=null)

		log.info("Getting local registry");
		Registry registry = null;
		try{
			registry = RMIRegistryUtil.findOrCreateRegistry();
		}catch(RemoteException e){
			log.fatal("Couldn't obtain free port for a local rmi registry", e);
			System.err.println("Couldn't obtain a free port for local rmi registry");
			System.exit(-1);
		}

		log.info("Registering "+serviceId+" locally.");

		try{
			registry.rebind(serviceId, rmiServant);
		}catch(Exception e){;
			log.fatal("Coulnd't rebind myself at the local registry", e);
			System.err.println("Coulnd't rebind myself at the local registry");
			e.printStackTrace();
			System.exit(-2);
		} //...local registry bind.

		LifecycleComponentImpl.INSTANCE.registerPublicService(serviceId, skeleton);
	}

	public static ServiceDescriptor createDescriptor(String instanceId) throws Exception{
		return RegistryUtil.createLocalServiceDescription(Protocol.RMI,  serviceId, instanceId, RMIRegistryUtil.getRmiRegistryPort());
	}
	public static void startService() throws Exception{
		String instanceId = IdCodeGenerator.generateCode(10);
		boolean registerCentrally = !SystemProperties.SKIP_CENTRAL_REGISTRY.getAsBoolean();
		if (registerCentrally){
			ServiceDescriptor descriptor = createDescriptor(instanceId);

			if (!RegistryUtil.bind(descriptor)){
				log.fatal("Coulnd't bind myself to the central registry at "+RegistryUtil.describeRegistry());
				System.err.println("Coulnd't bind myself at the central registry at "+RegistryUtil.describeRegistry());
				System.exit(-3);
			} //...central registry bind
			Runtime.getRuntime().addShutdownHook(new ServerShutdownHook(descriptor));

		}else{
			System.out.println("skipping registration for "+serviceId);
		}
		System.out.println("Server "+serviceId+" is up and ready.");
		Runtime.getRuntime().addShutdownHook(new org.distributeme.core.listener.ServerLifecycleListenerShutdownHook(serverListeners));
	} //...startService

	public static void createSupportServicesAndRegisterLocally() throws Exception{
		org.distributeme.support.lifecycle.generated.LifecycleSupportServer.init();
		org.distributeme.support.lifecycle.generated.LifecycleSupportServer.createServiceAndRegisterLocally();
		org.distributeme.support.eventservice.generated.EventServiceRMIBridgeServer.init();
		org.distributeme.support.eventservice.generated.EventServiceRMIBridgeServer.createServiceAndRegisterLocally();
	} //...createSupportServicesAndRegisterLocally

}
