package net.anotheria.moskito.central.endpoints.rmi.generated;
//CHECKSTYLE:OFF

import org.apache.log4j.Logger;
import java.util.List;
import java.util.Map;
import java.util.ArrayList;
import org.distributeme.core.Verbosity;
import org.distributeme.core.Defaults;
import org.distributeme.core.ServerSideCallContext;
import org.distributeme.core.interceptor.ServerSideRequestInterceptor;
import org.distributeme.core.interceptor.InterceptorResponse;
import org.distributeme.core.interceptor.InterceptionContext;
import org.distributeme.core.interceptor.InterceptorRegistry;
import org.distributeme.core.interceptor.InterceptionPhase;
import org.distributeme.core.concurrencycontrol.ConcurrencyControlStrategy;

public class RemoteRMIEndpointServiceSkeleton implements RemoteRMIEndpointService {

	private static Logger log = Logger.getLogger(RemoteRMIEndpointServiceSkeleton.class);

	private net.anotheria.moskito.central.endpoints.rmi.RMIEndpointService implementation;

	private long lastAccess;
	private long created;

	// CONCURRENCY CONTROL
	// Class wide concurrency control strategy 
	private ConcurrencyControlStrategy clazzWideCCStrategy = Defaults.getDefaultConcurrencyControlStrategy();

	private ConcurrencyControlStrategy processIncomingSnapshotCCStrategy_netanotheriamoskitocentralSnapshotsnapshot = clazzWideCCStrategy;
	// CONCURRENCY CONTROL end

	public RemoteRMIEndpointServiceSkeleton(){
		this(null);
	}

	public RemoteRMIEndpointServiceSkeleton(net.anotheria.moskito.central.endpoints.rmi.RMIEndpointService anImplementation){
		created = System.currentTimeMillis();
		implementation = anImplementation;
	}

	public List processIncomingSnapshot(net.anotheria.moskito.central.Snapshot snapshot, Map<?,?> __transportableCallContext) throws net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceException{
		lastAccess = System.currentTimeMillis();
		ServerSideCallContext diMeCallContext = new ServerSideCallContext("processIncomingSnapshot", __transportableCallContext);
		diMeCallContext.setServiceId(RMIEndpointServiceConstants.getServiceId());
		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeParameters.add(snapshot);
		diMeCallContext.setParameters(diMeParameters);
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Initialize interceptors
		List<ServerSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getServerSideRequestInterceptors();

		ArrayList __return = new ArrayList();

		diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVANT_CALL);
		for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
			InterceptorResponse interceptorResponse = interceptor.beforeServantCall(diMeCallContext, diMeInterceptionContext);
			switch(interceptorResponse.getCommand()){
			case ABORT:
				if (interceptorResponse.getException() instanceof RuntimeException)
					throw (RuntimeException) interceptorResponse.getException();
				if (interceptorResponse.getException() instanceof net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceException)
					throw (net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceException) interceptorResponse.getException();
				throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
			case RETURN:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case OVERWRITE_RETURN_AND_CONTINUE:
				__return.set(0, interceptorResponse.getReturnValue());
				diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
				break;
			case CONTINUE:
				break;
			} //...switch
		} //...for
		// Concurrency control, server side - 
		processIncomingSnapshotCCStrategy_netanotheriamoskitocentralSnapshotsnapshot.notifyServerSideCallStarted(diMeCallContext);

		try{
			implementation.processIncomingSnapshot(snapshot);
			__return.add(org.distributeme.core.util.VoidMarker.VOID);
			__return.add(diMeCallContext.getTransportableCallContext());
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVANT_CALL);
			for (ServerSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.afterServantCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					if (interceptorResponse.getException() instanceof net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceException)
						throw (net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case OVERWRITE_RETURN_AND_CONTINUE:
					__return.set(0, interceptorResponse.getReturnValue());
					diMeInterceptionContext.setReturnValue(interceptorResponse.getReturnValue());
					break;
				case CONTINUE:
					break;
				} //...switch
			} //...for
			return __return;
		}catch(net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceException e){
			if (Verbosity.logServerSideExceptions())
				log.error("processIncomingSnapshot()", e);
			throw(e);
		}finally{
			processIncomingSnapshotCCStrategy_netanotheriamoskitocentralSnapshotsnapshot.notifyServerSideCallFinished(diMeCallContext);
		}
	}

	// Service adapter methods
	public long getCreationTimestamp(){ return created; }
	public long getLastAccessTimestamp(){ return lastAccess; }

}
