package net.anotheria.moskito.central.endpoints.rmi.generated;
//CHECKSTYLE:OFF

import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import java.rmi.RemoteException;
import java.rmi.NotBoundException;
import org.distributeme.core.RegistryUtil;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.core.ServiceDescriptor.Protocol;
import org.distributeme.core.DiscoveryMode;
import org.distributeme.core.failing.FailingStrategy;
import org.distributeme.core.concurrencycontrol.ConcurrencyControlStrategy;
import org.distributeme.core.failing.FailDecision;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.exception.DistributemeRuntimeException;
import org.distributeme.core.exception.NoConnectionToServerException;
import org.distributeme.core.exception.ServiceUnavailableException;
import org.distributeme.core.Defaults;
import org.distributeme.core.interceptor.ClientSideRequestInterceptor;
import org.distributeme.core.interceptor.InterceptorRegistry;
import org.distributeme.core.interceptor.InterceptorResponse;
import org.distributeme.core.interceptor.InterceptionContext;
import org.distributeme.core.interceptor.InterceptionPhase;

public class RemoteRMIEndpointServiceStub implements net.anotheria.moskito.central.endpoints.rmi.RMIEndpointService{


	private volatile ConcurrentMap<String,RemoteRMIEndpointService> delegates = new ConcurrentHashMap<String,RemoteRMIEndpointService>();

	private DiscoveryMode discoveryMode = DiscoveryMode.AUTO;

	// ROUTER DECL V2
	// No class-wide-router set, skipping.

	// Method wide routers if applicable 
	// Method wide routers END 

	// ROUTER DECL V2 end

	// Failing
	// Class wide failing strategy 
	private FailingStrategy clazzWideFailingStrategy = Defaults.getDefaultFailingStrategy();

	private FailingStrategy processIncomingSnapshotFailingStrategy_netanotheriamoskitocentralSnapshotsnapshot = clazzWideFailingStrategy;
	// Failing end

	// CONCURRENCY CONTROL
	// Class wide concurrency control strategy 
	private ConcurrencyControlStrategy clazzWideCCStrategy = Defaults.getDefaultConcurrencyControlStrategy();

	private ConcurrencyControlStrategy processIncomingSnapshotCCStrategy_netanotheriamoskitocentralSnapshotsnapshot = clazzWideCCStrategy;
	// CONCURRENCY CONTROL end

	public RemoteRMIEndpointServiceStub(){
		discoveryMode = DiscoveryMode.AUTO;
	}

	private ServiceDescriptor manuallySetDescriptor;
	private RemoteRMIEndpointService manuallySetTarget;

	public RemoteRMIEndpointServiceStub(ServiceDescriptor target){
		discoveryMode = DiscoveryMode.MANUAL;
		manuallySetDescriptor = target;
		try{
			manuallySetTarget = lookup(manuallySetDescriptor);
		}catch(NoConnectionToServerException e){
			throw new IllegalStateException("Can not resolve manually set reference", e);
		}
	}

	public void processIncomingSnapshot(net.anotheria.moskito.central.Snapshot snapshot) throws net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceException{
		processIncomingSnapshot(snapshot, (ClientSideCallContext)null);
	} //...public void processIncomingSnapshot(net.anotheria.moskito.central.Snapshot snapshot) throws net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceException

	private void processIncomingSnapshot(net.anotheria.moskito.central.Snapshot snapshot, org.distributeme.core.ClientSideCallContext diMeCallContext) throws net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceException{
		List __fromServerSide = null;;
		Exception exceptionInMethod = null;
		if (diMeCallContext == null)
			diMeCallContext = new ClientSideCallContext("processIncomingSnapshot");
		if (discoveryMode==DiscoveryMode.AUTO && diMeCallContext.getServiceId()==null)
			diMeCallContext.setServiceId(RMIEndpointServiceConstants.getServiceId());

		HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
		// Initialize interceptors
		List<ClientSideRequestInterceptor> diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
		InterceptionContext diMeInterceptionContext = new InterceptionContext();
		// Concurrency control, client side - start
		processIncomingSnapshotCCStrategy_netanotheriamoskitocentralSnapshotsnapshot.notifyClientSideCallStarted(diMeCallContext);

		ArrayList<Object> diMeParameters = new ArrayList<Object>();
		diMeParameters.add(snapshot);
		diMeCallContext.setParameters(diMeParameters);
		try{
			diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
			for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
				InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
				switch(interceptorResponse.getCommand()){
				case ABORT:
					if (interceptorResponse.getException() instanceof RuntimeException)
						throw (RuntimeException) interceptorResponse.getException();
					if (interceptorResponse.getException() instanceof net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceException)
						throw (net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceException) interceptorResponse.getException();
					throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
				case RETURN:
					return;
				case CONTINUE:
					break;
				default:
					throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
				} //...switch
			} //...for
			// Reparse parameters in case an interceptor modified them
			snapshot = (net.anotheria.moskito.central.Snapshot) diMeParameters.get(0);
			__fromServerSide = getDelegate(diMeCallContext.getServiceId()).processIncomingSnapshot(snapshot,  __transportableCallContext);
			__transportableCallContext.putAll(((HashMap)__fromServerSide.get(1)));
			return;
		}catch(RemoteException e){
			// handle exceptions properly
			e.printStackTrace();
			notifyDelegateFailed(diMeCallContext.getServiceId());
			exceptionInMethod = e;
		}catch(NoConnectionToServerException e){
			exceptionInMethod = e;
		}finally{
		// Concurrency control, client side - end
			processIncomingSnapshotCCStrategy_netanotheriamoskitocentralSnapshotsnapshot.notifyClientSideCallFinished(diMeCallContext);
		diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
		if (__fromServerSide!=null){
			diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
		}
		diMeInterceptionContext.setException(exceptionInMethod);
		boolean diMeReturnOverriden = false;
		for (ClientSideRequestInterceptor interceptor : diMeInterceptors){
			InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
			switch(interceptorResponse.getCommand()){
			case ABORT:
				if (interceptorResponse.getException() instanceof RuntimeException)
					throw (RuntimeException) interceptorResponse.getException();
				if (interceptorResponse.getException() instanceof net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceException)
					throw (net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceException) interceptorResponse.getException();
				throw new RuntimeException("Interceptor exception",interceptorResponse.getException());
			case RETURN:
				return;
			case CONTINUE:
				break;
			default:
				throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand()+ " in phase:"+diMeInterceptionContext.getCurrentPhase());
			} //...switch
		} //...for
		}
		// Failing
		if (exceptionInMethod!=null){
			FailDecision failDecision = processIncomingSnapshotFailingStrategy_netanotheriamoskitocentralSnapshotsnapshot.callFailed(diMeCallContext);
			if (failDecision.getTargetService()!=null)
				diMeCallContext.setServiceId(failDecision.getTargetService());
			switch(failDecision.getReaction()){
				case RETRY:
					processIncomingSnapshot(snapshot, diMeCallContext.increaseCallCount());
					return;
				case RETRYONCE:
					// Only retry if its the first call
					if (!diMeCallContext.isFirstCall())
						break;
					processIncomingSnapshot(snapshot, diMeCallContext.increaseCallCount());
					return;
				case FAIL:
				default:
				// Fail or default is to do nothing at all and let the request fail
			} //...switch(failDecision)
		}
		// fail through, if we are here, we must have had an exception before.
		throw mapException(exceptionInMethod);
	}


	private void notifyDelegateFailed(){
		notifyDelegateFailed(RMIEndpointServiceConstants.getServiceId());
	}

	private void notifyDelegateFailed(String serviceId){
		if (serviceId!=null)
			delegates.remove(serviceId);
	}

	private RemoteRMIEndpointService getDelegate() throws NoConnectionToServerException{
		if (discoveryMode==DiscoveryMode.MANUAL)
			return manuallySetTarget;
		return getDelegate(RMIEndpointServiceConstants.getServiceId());
	}

	private RemoteRMIEndpointService getDelegate(String serviceId) throws NoConnectionToServerException{
		// if no serviceid is provided, fallback to default resolve with manual mode
		if (serviceId==null)
			return getDelegate();
		RemoteRMIEndpointService delegate = delegates.get(serviceId);
		if (delegate==null){
			try{
				delegate = lookup(serviceId);
				delegates.putIfAbsent(serviceId, delegate);
			}catch(Exception e){
			// //TODO - generate and throw typed exception.
				throw new NoConnectionToServerException("Couldn't lookup delegate because: "+e.getMessage()+" at "+RegistryUtil.describeRegistry(), e);
			}//try
		} //...first if (del==null) 
		return delegate;
	} //...fun

	private RemoteRMIEndpointService lookup(String serviceId) throws NoConnectionToServerException{
		// //first we need to lookup target host.
		ServiceDescriptor toLookup = new ServiceDescriptor(Protocol.RMI, serviceId);
		ServiceDescriptor targetService = RegistryUtil.resolve(toLookup);
		if (targetService==null)
			throw new RuntimeException("Can't resolve host for an instance of "+RMIEndpointServiceConstants.getServiceId());
		Registry registry = null;
		try{
			registry = LocateRegistry.getRegistry(targetService.getHost(), targetService.getPort());
		}catch(Exception e){
			System.err.println("lookup - couldn't obtain rmi registry on "+targetService+", aborting lookup"); e.printStackTrace();
			throw new NoConnectionToServerException("Can't resolve rmi registry for an instance of "+RMIEndpointServiceConstants.getServiceId());
		}
		try{
			return (RemoteRMIEndpointService) registry.lookup(serviceId);
		}catch(RemoteException e){
			throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of "+serviceId, e);
		}catch(NotBoundException e){
			throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of "+serviceId, e);
		}
	}

	private RemoteRMIEndpointService lookup(ServiceDescriptor serviceDescriptor) throws NoConnectionToServerException{
		Registry registry = null;
		try{
			registry = LocateRegistry.getRegistry(serviceDescriptor.getHost(), serviceDescriptor.getPort());
		}catch(Exception e){
			System.err.println("lookup - couldn't obtain rmi registry on "+serviceDescriptor+", aborting lookup"); e.printStackTrace();
			throw new NoConnectionToServerException("Can't resolve rmi registry for "+serviceDescriptor);
		}
		try{
			return (RemoteRMIEndpointService) registry.lookup(serviceDescriptor.getServiceId());
		}catch(RemoteException e){
			throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of "+serviceDescriptor, e);
		}catch(NotBoundException e){
			throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of "+serviceDescriptor, e);
		}
	}

	private DistributemeRuntimeException mapException(Exception in){
		if (in instanceof DistributemeRuntimeException)
			return (DistributemeRuntimeException) in;
		if (in instanceof RemoteException)
			return new ServiceUnavailableException ("Service unavailable due to rmi failure: "+in.getMessage(), in);
		return new ServiceUnavailableException("Unexpected exception: "+in.getMessage()+" " + in.getClass().getName(), in);
	}
}
