/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.central;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.central.Snapshot;
import net.anotheria.moskito.central.config.Configuration;
import net.anotheria.moskito.central.config.StorageConfigEntry;
import net.anotheria.moskito.central.storage.Storage;
import org.apache.log4j.Logger;
import org.configureme.ConfigurationManager;

public class Central {
    private ConcurrentMap<String, Storage> storages = new ConcurrentHashMap<String, Storage>();
    private List<Storage> cachedList = new CopyOnWriteArrayList<Storage>();
    private Configuration configuration;
    private static Logger log = Logger.getLogger(Central.class);

    public static Central getInstance() {
        return CentralInstanceHolder.instance;
    }

    public static Central getConfiguredInstance(Configuration config) {
        Central instance = new Central();
        instance.setConfiguration(config);
        instance.setup();
        return instance;
    }

    private void setup() {
        this.storages.clear();
        this.cachedList.clear();
        for (StorageConfigEntry storageConfigEntry : this.configuration.getStorages()) {
            try {
                Storage storage = (Storage)Storage.class.cast(Class.forName(storageConfigEntry.getClazz()).newInstance());
                try {
                    storage.configure(storageConfigEntry.getConfigName());
                    this.storages.put(storageConfigEntry.getName(), storage);
                    this.cachedList.add(storage);
                }
                catch (Exception e) {
                    log.warn((Object)("Storage " + storage + " for " + storageConfigEntry + " couldn't be configured properly."));
                }
            }
            catch (ClassNotFoundException cnf) {
                log.warn((Object)("Couldn't instantiate StorageConfigEntry " + storageConfigEntry + " due "), (Throwable)cnf);
            }
            catch (InstantiationException e) {
                log.warn((Object)("Couldn't instantiate StorageConfigEntry " + storageConfigEntry + " due "), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn((Object)("Couldn't instantiate StorageConfigEntry " + storageConfigEntry + " due "), (Throwable)e);
            }
        }
    }

    public void processIncomingSnapshot(Snapshot snapshot) {
        for (Storage s : this.cachedList) {
            try {
                s.processSnapshot(snapshot);
            }
            catch (Exception any) {
                log.warn((Object)("Exception caught during snapshot processing in storage " + s + ", snapshot: " + snapshot), (Throwable)any);
            }
        }
    }

    private void setConfiguration(Configuration aConfiguration) {
        this.configuration = aConfiguration;
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    private static class CentralInstanceHolder {
        static final Central instance = new Central();

        private CentralInstanceHolder() {
        }

        static {
            Configuration configuration = new Configuration();
            try {
                ConfigurationManager.INSTANCE.configure((Object)configuration);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            CentralInstanceHolder.instance.setConfiguration(configuration);
            CentralInstanceHolder.instance.setup();
        }
    }
}

