/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.central.connectors;

import java.util.HashMap;
import java.util.Map;
import net.anotheria.moskito.central.Snapshot;
import net.anotheria.moskito.central.SnapshotMetaData;
import net.anotheria.moskito.core.plugins.AbstractMoskitoPlugin;
import net.anotheria.moskito.core.snapshot.ProducerSnapshot;
import net.anotheria.moskito.core.snapshot.SnapshotConsumer;
import net.anotheria.moskito.core.snapshot.SnapshotRepository;
import net.anotheria.moskito.core.snapshot.StatSnapshot;
import net.anotheria.net.util.NetUtils;
import org.apache.log4j.Logger;

public abstract class AbstractCentralConnector
extends AbstractMoskitoPlugin
implements SnapshotConsumer {
    private String componentName = System.getProperty("component", this.componentName);
    private String host;
    private static final Logger log = Logger.getLogger(AbstractCentralConnector.class);

    public AbstractCentralConnector() {
        try {
            this.host = NetUtils.getShortComputerName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.host == null) {
            this.host = "unknown";
        }
        this.host = System.getProperty("hostname", this.host);
    }

    public void initialize() {
        super.initialize();
        SnapshotRepository.getInstance().addConsumer((SnapshotConsumer)this);
    }

    public void deInitialize() {
        SnapshotRepository.getInstance().removeConsumer((SnapshotConsumer)this);
        super.deInitialize();
    }

    public void consumeSnapshot(ProducerSnapshot coreSnapshot) {
        Snapshot centralSnapshot = this.makeSnapshot(coreSnapshot);
        log.debug((Object)(((Object)((Object)this)).getClass().getName() + ": \r\n" + centralSnapshot));
        try {
            this.sendData(centralSnapshot);
        }
        catch (Exception e) {
            log.error((Object)(((Object)((Object)this)).getClass().getSimpleName() + ".sendData() failed"), (Throwable)e);
        }
    }

    private Snapshot makeSnapshot(ProducerSnapshot coreSnapshot) {
        Snapshot centralSnapshot = new Snapshot();
        SnapshotMetaData metaData = new SnapshotMetaData();
        metaData.setProducerId(coreSnapshot.getProducerId());
        metaData.setCategory(coreSnapshot.getCategory());
        metaData.setSubsystem(coreSnapshot.getSubsystem());
        metaData.setComponentName(this.componentName);
        metaData.setHostName(this.host);
        metaData.setIntervalName(coreSnapshot.getIntervalName());
        metaData.setCreationTimestamp(coreSnapshot.getTimestamp());
        metaData.setStatClassName(coreSnapshot.getStatClassName());
        centralSnapshot.setMetaData(metaData);
        Map coreStatSnapshots = coreSnapshot.getStatSnapshots();
        for (Map.Entry coreStatSnapshot : coreStatSnapshots.entrySet()) {
            centralSnapshot.addSnapshotData((String)coreStatSnapshot.getKey(), new HashMap<String, String>(((StatSnapshot)coreStatSnapshot.getValue()).getValues()));
        }
        return centralSnapshot;
    }

    protected abstract void sendData(Snapshot var1);

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " " + this.componentName + "@" + this.host;
    }
}

