/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.central.connectors.dime;

import net.anotheria.moskito.central.Snapshot;
import net.anotheria.moskito.central.connectors.AbstractCentralConnector;
import net.anotheria.moskito.central.connectors.dime.DiMeCentralConnectorConfig;
import net.anotheria.moskito.central.endpoints.rmi.RMIEndpointService;
import net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceException;
import net.anotheria.moskito.central.endpoints.rmi.generated.RemoteRMIEndpointServiceStub;
import net.anotheria.util.IdCodeGenerator;
import org.apache.log4j.Logger;
import org.configureme.ConfigurationManager;
import org.distributeme.core.ServiceDescriptor;

public class DiMeCentralConnector
extends AbstractCentralConnector {
    private static final Logger log = Logger.getLogger(DiMeCentralConnector.class);
    private RMIEndpointService centralService;
    private DiMeCentralConnectorConfig config;

    public void setConfigurationName(String configurationName) {
        this.config = new DiMeCentralConnectorConfig();
        ConfigurationManager.INSTANCE.configureAs((Object)this.config, configurationName);
        log.debug((Object)this.config);
        ServiceDescriptor.Protocol aProtocol = ServiceDescriptor.Protocol.RMI;
        String aServiceId = RMIEndpointService.class.getName().replaceAll("[.]", "_");
        String anInstanceId = IdCodeGenerator.generateCode((int)10);
        String aHost = this.config.getConnectorHost();
        int aPort = this.config.getConnectorPort();
        ServiceDescriptor remote = new ServiceDescriptor(aProtocol, aServiceId, anInstanceId, aHost, aPort);
        this.centralService = new RemoteRMIEndpointServiceStub(remote);
    }

    @Override
    protected void sendData(Snapshot snapshot) {
        if (this.centralService != null) {
            try {
                this.centralService.processIncomingSnapshot(snapshot);
            }
            catch (RMIEndpointServiceException e) {
                throw new RuntimeException("centralService.processIncomingSnapshot failed...", e);
            }
        }
    }
}

