/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.central.connectors.rest;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import net.anotheria.moskito.central.Snapshot;
import net.anotheria.moskito.central.connectors.AbstractCentralConnector;
import net.anotheria.moskito.central.connectors.rest.RESTCentralConnectorConfig;
import org.apache.log4j.Logger;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;
import org.configureme.ConfigurationManager;

public class RESTConnector
extends AbstractCentralConnector {
    private static final Logger log = Logger.getLogger(RESTConnector.class);
    private RESTCentralConnectorConfig restConfig;

    private Client getClient() {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getClasses().add(JacksonJaxbJsonProvider.class);
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        Client client = Client.create((ClientConfig)clientConfig);
        return client;
    }

    public void setConfigurationName(String configurationName) {
        this.restConfig = new RESTCentralConnectorConfig();
        ConfigurationManager.INSTANCE.configureAs((Object)this.restConfig, configurationName);
        log.debug((Object)this.restConfig);
    }

    @Override
    protected void sendData(Snapshot snapshot) {
        WebResource resource = this.getClient().resource(this.getBaseURI());
        ((WebResource.Builder)resource.accept(new String[]{"application/json"}).type("application/json")).post((Object)snapshot);
    }

    private URI getBaseURI() {
        return UriBuilder.fromUri((String)("http://" + this.restConfig.getHost() + this.restConfig.getResourcePath())).port(this.restConfig.getPort()).build(new Object[0]);
    }
}

