/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.central.endpoints.rmi.generated;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import net.anotheria.anoprise.metafactory.Extension;
import net.anotheria.anoprise.metafactory.FactoryNotFoundException;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.Service;
import net.anotheria.moskito.central.endpoints.rmi.RMIEndpointService;
import net.anotheria.moskito.central.endpoints.rmi.generated.RMIEndpointServiceConstants;
import net.anotheria.moskito.central.endpoints.rmi.generated.RemoteRMIEndpointService;
import net.anotheria.moskito.central.endpoints.rmi.generated.RemoteRMIEndpointServiceSkeleton;
import net.anotheria.util.IdCodeGenerator;
import net.anotheria.util.PidTools;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.distributeme.core.RMIRegistryUtil;
import org.distributeme.core.RegistryUtil;
import org.distributeme.core.ServerShutdownHook;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.core.Verbosity;
import org.distributeme.core.conventions.SystemProperties;
import org.distributeme.core.lifecycle.LifecycleComponentImpl;
import org.distributeme.core.lifecycle.ServiceAdapter;
import org.distributeme.core.listener.ListenerRegistry;
import org.distributeme.core.listener.ServerLifecycleListener;
import org.distributeme.core.listener.ServerLifecycleListenerShutdownHook;
import org.distributeme.core.routing.RegistrationNameProvider;
import org.distributeme.support.eventservice.generated.EventServiceRMIBridgeServer;
import org.distributeme.support.lifecycle.generated.LifecycleSupportServer;

public class RMIEndpointServer {
    private static Logger log;
    private static final List<ServerLifecycleListener> serverListeners;
    private static RemoteRMIEndpointService skeleton;
    private static RemoteRMIEndpointService rmiServant;
    private static String serviceId;

    public static void main(String[] a) throws Exception {
        DOMConfigurator.configureAndWatch((String)"/log4j.xml");
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPermission(Permission perm) {
                }
            });
        }
        try {
            RMIEndpointServer.init();
            PidTools.logPid();
            Verbosity.logServerSideExceptions();
            RMIEndpointServer.createSupportServicesAndRegisterLocally();
            RMIEndpointServer.createServiceAndRegisterLocally();
            RMIEndpointServer.startService();
            RMIEndpointServer.notifyListenersAboutStart();
        }
        catch (Throwable e) {
            log.fatal((Object)"Unhandled exception caught", e);
            System.err.println(e.getMessage());
            System.exit(-4);
        }
    }

    private static void notifyListenersAboutStart() {
        List configuredListeners = ListenerRegistry.getInstance().getServerLifecycleListeners();
        if (configuredListeners != null && configuredListeners.size() > 0) {
            for (ServerLifecycleListener listener : configuredListeners) {
                try {
                    listener.afterStart();
                }
                catch (Exception e) {
                    log.error((Object)("Couldn't call afterStart on  listener " + listener), (Throwable)e);
                }
            }
        }
    }

    public static void init() throws Exception {
        log = Logger.getLogger(RMIEndpointServer.class);
    }

    public static void createServiceAndRegisterLocally() throws Exception {
        try {
            Class<?> factoryClazz = Class.forName("net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceFactory");
            MetaFactory.addFactoryClass(RMIEndpointService.class, (Extension)Extension.LOCAL, factoryClazz);
        }
        catch (ClassNotFoundException factoryNotFound) {
            try {
                Class<?> implClazz = Class.forName("net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceImpl");
                MetaFactory.createOnTheFlyFactory(RMIEndpointService.class, (Extension)Extension.LOCAL, (Service)((Service)implClazz.newInstance()));
            }
            catch (ClassNotFoundException implNotFound) {
                log.info((Object)"Giving up trying to find an impl instance, tried net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceFactory and net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceImpl, expect start to fail since init code were empty too and no factory has been supplied explicitely");
            }
        }
        RMIEndpointService impl = null;
        try {
            impl = (RMIEndpointService)MetaFactory.get(RMIEndpointService.class, (Extension)Extension.LOCAL);
        }
        catch (FactoryNotFoundException factoryNotFound) {
            throw new AssertionError((Object)"Un- or mis-configured, can't instantiate service instance for net.anotheria.moskito.central.endpoints.rmi.RMIEndpointService tried initcode, submitted factory, autoguessed factory (net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceFactory) and impl class (net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceImpl)");
        }
        skeleton = new RemoteRMIEndpointServiceSkeleton(impl);
        rmiServant = (RemoteRMIEndpointService)UnicastRemoteObject.exportObject((Remote)skeleton, 0);
        serviceId = RMIEndpointServiceConstants.getServiceId();
        String regNameProviderClass = System.getProperty("dimeRegistrationNameProvider");
        if (regNameProviderClass != null) {
            RegistrationNameProvider suppliedNameProvider = (RegistrationNameProvider)Class.forName(regNameProviderClass).newInstance();
            serviceId = suppliedNameProvider.getRegistrationName(serviceId);
        }
        log.info((Object)"Getting local registry");
        Registry registry = null;
        try {
            registry = RMIRegistryUtil.findOrCreateRegistry();
        }
        catch (RemoteException e) {
            log.fatal((Object)"Couldn't obtain free port for a local rmi registry", (Throwable)e);
            System.err.println("Couldn't obtain a free port for local rmi registry");
            System.exit(-1);
        }
        log.info((Object)("Registering " + serviceId + " locally."));
        try {
            registry.rebind(serviceId, rmiServant);
        }
        catch (Exception e) {
            log.fatal((Object)"Coulnd't rebind myself at the local registry", (Throwable)e);
            System.err.println("Coulnd't rebind myself at the local registry");
            e.printStackTrace();
            System.exit(-2);
        }
        LifecycleComponentImpl.INSTANCE.registerPublicService(serviceId, (ServiceAdapter)skeleton);
    }

    public static ServiceDescriptor createDescriptor(String instanceId) throws Exception {
        return RegistryUtil.createLocalServiceDescription((ServiceDescriptor.Protocol)ServiceDescriptor.Protocol.RMI, (String)serviceId, (String)instanceId, (int)RMIRegistryUtil.getRmiRegistryPort());
    }

    public static void startService() throws Exception {
        boolean registerCentrally;
        String instanceId = IdCodeGenerator.generateCode((int)10);
        boolean bl = registerCentrally = !SystemProperties.SKIP_CENTRAL_REGISTRY.getAsBoolean();
        if (registerCentrally) {
            ServiceDescriptor descriptor = RMIEndpointServer.createDescriptor(instanceId);
            if (!RegistryUtil.bind((ServiceDescriptor)descriptor)) {
                log.fatal((Object)("Coulnd't bind myself to the central registry at " + RegistryUtil.describeRegistry()));
                System.err.println("Coulnd't bind myself at the central registry at " + RegistryUtil.describeRegistry());
                System.exit(-3);
            }
            Runtime.getRuntime().addShutdownHook((Thread)new ServerShutdownHook(descriptor));
        } else {
            System.out.println("skipping registration for " + serviceId);
        }
        System.out.println("Server " + serviceId + " is up and ready.");
        Runtime.getRuntime().addShutdownHook((Thread)new ServerLifecycleListenerShutdownHook(serverListeners));
    }

    public static void createSupportServicesAndRegisterLocally() throws Exception {
        LifecycleSupportServer.init();
        LifecycleSupportServer.createServiceAndRegisterLocally();
        EventServiceRMIBridgeServer.init();
        EventServiceRMIBridgeServer.createServiceAndRegisterLocally();
    }

    static {
        serverListeners = new ArrayList<ServerLifecycleListener>(0);
        skeleton = null;
        rmiServant = null;
        serviceId = null;
    }
}

