/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.central.endpoints.rmi.generated;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.anotheria.moskito.central.Snapshot;
import net.anotheria.moskito.central.endpoints.rmi.RMIEndpointService;
import net.anotheria.moskito.central.endpoints.rmi.RMIEndpointServiceException;
import net.anotheria.moskito.central.endpoints.rmi.generated.RMIEndpointServiceConstants;
import net.anotheria.moskito.central.endpoints.rmi.generated.RemoteRMIEndpointService;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.Defaults;
import org.distributeme.core.DiscoveryMode;
import org.distributeme.core.RegistryUtil;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.core.concurrencycontrol.ConcurrencyControlStrategy;
import org.distributeme.core.exception.DistributemeRuntimeException;
import org.distributeme.core.exception.NoConnectionToServerException;
import org.distributeme.core.exception.ServiceUnavailableException;
import org.distributeme.core.failing.FailDecision;
import org.distributeme.core.failing.FailingStrategy;
import org.distributeme.core.interceptor.ClientSideRequestInterceptor;
import org.distributeme.core.interceptor.InterceptionContext;
import org.distributeme.core.interceptor.InterceptionPhase;
import org.distributeme.core.interceptor.InterceptorRegistry;
import org.distributeme.core.interceptor.InterceptorResponse;

public class RemoteRMIEndpointServiceStub
implements RMIEndpointService {
    private volatile ConcurrentMap<String, RemoteRMIEndpointService> delegates = new ConcurrentHashMap<String, RemoteRMIEndpointService>();
    private DiscoveryMode discoveryMode = DiscoveryMode.AUTO;
    private FailingStrategy clazzWideFailingStrategy;
    private FailingStrategy processIncomingSnapshotFailingStrategy_netanotheriamoskitocentralSnapshotsnapshot = this.clazzWideFailingStrategy = Defaults.getDefaultFailingStrategy();
    private ConcurrencyControlStrategy clazzWideCCStrategy;
    private ConcurrencyControlStrategy processIncomingSnapshotCCStrategy_netanotheriamoskitocentralSnapshotsnapshot = this.clazzWideCCStrategy = Defaults.getDefaultConcurrencyControlStrategy();
    private ServiceDescriptor manuallySetDescriptor;
    private RemoteRMIEndpointService manuallySetTarget;

    public RemoteRMIEndpointServiceStub() {
        this.discoveryMode = DiscoveryMode.AUTO;
    }

    public RemoteRMIEndpointServiceStub(ServiceDescriptor target) {
        this.discoveryMode = DiscoveryMode.MANUAL;
        this.manuallySetDescriptor = target;
        try {
            this.manuallySetTarget = this.lookup(this.manuallySetDescriptor);
        }
        catch (NoConnectionToServerException e) {
            throw new IllegalStateException("Can not resolve manually set reference", e);
        }
    }

    @Override
    public void processIncomingSnapshot(Snapshot snapshot) throws RMIEndpointServiceException {
        this.processIncomingSnapshot(snapshot, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIncomingSnapshot(Snapshot snapshot, ClientSideCallContext diMeCallContext) throws RMIEndpointServiceException {
        List __fromServerSide = null;
        Throwable exceptionInMethod = null;
        if (diMeCallContext == null) {
            diMeCallContext = new ClientSideCallContext("processIncomingSnapshot");
        }
        if (this.discoveryMode == DiscoveryMode.AUTO && diMeCallContext.getServiceId() == null) {
            diMeCallContext.setServiceId(RMIEndpointServiceConstants.getServiceId());
        }
        HashMap __transportableCallContext = diMeCallContext.getTransportableCallContext();
        List diMeInterceptors = InterceptorRegistry.getInstance().getClientSideRequestInterceptors();
        InterceptionContext diMeInterceptionContext = new InterceptionContext();
        this.processIncomingSnapshotCCStrategy_netanotheriamoskitocentralSnapshotsnapshot.notifyClientSideCallStarted(diMeCallContext);
        ArrayList<Snapshot> diMeParameters = new ArrayList<Snapshot>();
        diMeParameters.add(snapshot);
        diMeCallContext.setParameters(diMeParameters);
        try {
            diMeInterceptionContext.setCurrentPhase(InterceptionPhase.BEFORE_SERVICE_CALL);
            block42: for (ClientSideRequestInterceptor interceptor : diMeInterceptors) {
                InterceptorResponse interceptorResponse = interceptor.beforeServiceCall(diMeCallContext, diMeInterceptionContext);
                switch (interceptorResponse.getCommand()) {
                    case ABORT: {
                        if (interceptorResponse.getException() instanceof RuntimeException) {
                            throw (RuntimeException)interceptorResponse.getException();
                        }
                        if (interceptorResponse.getException() instanceof RMIEndpointServiceException) {
                            throw (RMIEndpointServiceException)interceptorResponse.getException();
                        }
                        throw new RuntimeException("Interceptor exception", interceptorResponse.getException());
                    }
                    case RETURN: {
                        return;
                    }
                    case CONTINUE: {
                        continue block42;
                    }
                }
                throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand() + " in phase:" + diMeInterceptionContext.getCurrentPhase());
            }
            snapshot = (Snapshot)diMeParameters.get(0);
            __fromServerSide = this.getDelegate(diMeCallContext.getServiceId()).processIncomingSnapshot(snapshot, __transportableCallContext);
            __transportableCallContext.putAll((HashMap)__fromServerSide.get(1));
            return;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            this.notifyDelegateFailed(diMeCallContext.getServiceId());
            exceptionInMethod = e;
        }
        catch (NoConnectionToServerException e) {
            exceptionInMethod = e;
        }
        finally {
            this.processIncomingSnapshotCCStrategy_netanotheriamoskitocentralSnapshotsnapshot.notifyClientSideCallFinished(diMeCallContext);
            diMeInterceptionContext.setCurrentPhase(InterceptionPhase.AFTER_SERVICE_CALL);
            if (__fromServerSide != null) {
                diMeInterceptionContext.setReturnValue(__fromServerSide.get(0));
            }
            diMeInterceptionContext.setException((Exception)exceptionInMethod);
            boolean diMeReturnOverriden = false;
            block43: for (ClientSideRequestInterceptor interceptor : diMeInterceptors) {
                InterceptorResponse interceptorResponse = interceptor.afterServiceCall(diMeCallContext, diMeInterceptionContext);
                switch (interceptorResponse.getCommand()) {
                    case ABORT: {
                        if (interceptorResponse.getException() instanceof RuntimeException) {
                            throw (RuntimeException)interceptorResponse.getException();
                        }
                        if (interceptorResponse.getException() instanceof RMIEndpointServiceException) {
                            throw (RMIEndpointServiceException)interceptorResponse.getException();
                        }
                        throw new RuntimeException("Interceptor exception", interceptorResponse.getException());
                    }
                    case RETURN: {
                        return;
                    }
                    case CONTINUE: {
                        continue block43;
                    }
                }
                throw new IllegalStateException("Unsupported or unexpected command from interceptor " + interceptorResponse.getCommand() + " in phase:" + diMeInterceptionContext.getCurrentPhase());
            }
        }
        if (exceptionInMethod != null) {
            FailDecision failDecision = this.processIncomingSnapshotFailingStrategy_netanotheriamoskitocentralSnapshotsnapshot.callFailed(diMeCallContext);
            if (failDecision.getTargetService() != null) {
                diMeCallContext.setServiceId(failDecision.getTargetService());
            }
            switch (failDecision.getReaction()) {
                case RETRY: {
                    this.processIncomingSnapshot(snapshot, diMeCallContext.increaseCallCount());
                    return;
                }
                case RETRYONCE: {
                    if (!diMeCallContext.isFirstCall()) break;
                    this.processIncomingSnapshot(snapshot, diMeCallContext.increaseCallCount());
                    return;
                }
            }
        }
        throw this.mapException((Exception)exceptionInMethod);
    }

    private void notifyDelegateFailed() {
        this.notifyDelegateFailed(RMIEndpointServiceConstants.getServiceId());
    }

    private void notifyDelegateFailed(String serviceId) {
        if (serviceId != null) {
            this.delegates.remove(serviceId);
        }
    }

    private RemoteRMIEndpointService getDelegate() throws NoConnectionToServerException {
        if (this.discoveryMode == DiscoveryMode.MANUAL) {
            return this.manuallySetTarget;
        }
        return this.getDelegate(RMIEndpointServiceConstants.getServiceId());
    }

    private RemoteRMIEndpointService getDelegate(String serviceId) throws NoConnectionToServerException {
        if (serviceId == null) {
            return this.getDelegate();
        }
        RemoteRMIEndpointService delegate = (RemoteRMIEndpointService)this.delegates.get(serviceId);
        if (delegate == null) {
            try {
                delegate = this.lookup(serviceId);
                this.delegates.putIfAbsent(serviceId, delegate);
            }
            catch (Exception e) {
                throw new NoConnectionToServerException("Couldn't lookup delegate because: " + e.getMessage() + " at " + RegistryUtil.describeRegistry(), e);
            }
        }
        return delegate;
    }

    private RemoteRMIEndpointService lookup(String serviceId) throws NoConnectionToServerException {
        ServiceDescriptor toLookup = new ServiceDescriptor(ServiceDescriptor.Protocol.RMI, serviceId);
        ServiceDescriptor targetService = RegistryUtil.resolve((ServiceDescriptor)toLookup);
        if (targetService == null) {
            throw new RuntimeException("Can't resolve host for an instance of " + RMIEndpointServiceConstants.getServiceId());
        }
        Registry registry = null;
        try {
            registry = LocateRegistry.getRegistry(targetService.getHost(), targetService.getPort());
        }
        catch (Exception e) {
            System.err.println("lookup - couldn't obtain rmi registry on " + targetService + ", aborting lookup");
            e.printStackTrace();
            throw new NoConnectionToServerException("Can't resolve rmi registry for an instance of " + RMIEndpointServiceConstants.getServiceId());
        }
        try {
            return (RemoteRMIEndpointService)registry.lookup(serviceId);
        }
        catch (RemoteException e) {
            throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of " + serviceId, (Exception)e);
        }
        catch (NotBoundException e) {
            throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of " + serviceId, (Exception)e);
        }
    }

    private RemoteRMIEndpointService lookup(ServiceDescriptor serviceDescriptor) throws NoConnectionToServerException {
        Registry registry = null;
        try {
            registry = LocateRegistry.getRegistry(serviceDescriptor.getHost(), serviceDescriptor.getPort());
        }
        catch (Exception e) {
            System.err.println("lookup - couldn't obtain rmi registry on " + serviceDescriptor + ", aborting lookup");
            e.printStackTrace();
            throw new NoConnectionToServerException("Can't resolve rmi registry for " + serviceDescriptor);
        }
        try {
            return (RemoteRMIEndpointService)registry.lookup(serviceDescriptor.getServiceId());
        }
        catch (RemoteException e) {
            throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of " + serviceDescriptor, (Exception)e);
        }
        catch (NotBoundException e) {
            throw new NoConnectionToServerException("Can't lookup service in the target rmi registry for an instance of " + serviceDescriptor, (Exception)e);
        }
    }

    private DistributemeRuntimeException mapException(Exception in) {
        if (in instanceof DistributemeRuntimeException) {
            return (DistributemeRuntimeException)in;
        }
        if (in instanceof RemoteException) {
            return new ServiceUnavailableException("Service unavailable due to rmi failure: " + in.getMessage(), in);
        }
        return new ServiceUnavailableException("Unexpected exception: " + in.getMessage() + " " + in.getClass().getName(), in);
    }
}

