/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.central.storage;

import net.anotheria.moskito.central.Snapshot;
import net.anotheria.util.NumberUtils;
import net.anotheria.util.StringUtils;

public final class StorageUtils {
    private StorageUtils() {
    }

    public static String convertPathPattern(String path, Snapshot target, String statName) {
        path = StorageUtils.convertPathPattern(path, target);
        return StringUtils.replace((String)path, (String)"{stat}", (String)statName);
    }

    public static String convertPathPattern(String path, Snapshot target) {
        path = StringUtils.replace((String)path, (String)"{host}", (String)target.getMetaData().getHostName());
        path = StringUtils.replace((String)path, (String)"{component}", (String)target.getMetaData().getComponentName());
        path = StringUtils.replace((String)path, (String)"{producer}", (String)target.getMetaData().getProducerId());
        path = StringUtils.replace((String)path, (String)"{date}", (String)StringUtils.replace((String)NumberUtils.makeDigitalDateString((long)target.getMetaData().getCreationTimestamp()), (char)'.', (char)'_'));
        path = StringUtils.replace((String)path, (String)"{time}", (String)StringUtils.replace((String)NumberUtils.makeTimeString((long)target.getMetaData().getCreationTimestamp()), (char)':', (char)'_'));
        path = StringUtils.replace((String)path, (String)"{category}", (String)target.getMetaData().getCategory());
        path = StringUtils.replace((String)path, (String)"{subsystem}", (String)target.getMetaData().getSubsystem());
        path = StringUtils.replace((String)path, (String)"{interval}", (String)target.getMetaData().getIntervalName());
        return path;
    }
}

