/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.central.storage.fs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.anotheria.moskito.central.storage.fs.CSVFileStorageConfigEntry;
import net.anotheria.moskito.central.storage.fs.IncludeExcludeList;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;

@ConfigureMe
public class CSVFileStorageConfig {
    @Configure
    private CSVFileStorageConfigEntry[] entries;
    @Configure
    private String pattern;
    private List<CSVFileStorageConfigElement> elements;
    @Configure
    private String includeIntervals = "*";
    @Configure
    private String excludeIntervals = "";

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getIncludeIntervals() {
        return this.includeIntervals;
    }

    public void setIncludeIntervals(String includeIntervals) {
        this.includeIntervals = includeIntervals;
    }

    public String getExcludeIntervals() {
        return this.excludeIntervals;
    }

    public void setExcludeIntervals(String excludeIntervals) {
        this.excludeIntervals = excludeIntervals;
    }

    public CSVFileStorageConfigEntry[] getEntries() {
        return this.entries;
    }

    public void setEntries(CSVFileStorageConfigEntry[] entries) {
        this.entries = entries;
    }

    public String toString() {
        return "Pattern: " + this.getPattern() + ", Entries: " + Arrays.toString(this.entries) + ", InclIntervals: " + this.includeIntervals + ", ExclIntervals: " + this.excludeIntervals;
    }

    public boolean include(String producer, String stat, String interval) {
        List<CSVFileStorageConfigElement> listCopy = this.elements;
        if (listCopy == null) {
            return false;
        }
        for (CSVFileStorageConfigElement e : listCopy) {
            if (!e.include(producer, stat, interval)) continue;
            return true;
        }
        return false;
    }

    @AfterConfiguration
    public void afterConfig() {
        IncludeExcludeList intervals = new IncludeExcludeList(this.includeIntervals, this.excludeIntervals);
        ArrayList<CSVFileStorageConfigElement> newElements = new ArrayList<CSVFileStorageConfigElement>();
        for (CSVFileStorageConfigEntry entry : this.entries) {
            CSVFileStorageConfigElement element = new CSVFileStorageConfigElement(entry, intervals);
            newElements.add(element);
        }
        this.elements = newElements;
    }

    private static class CSVFileStorageConfigElement {
        private IncludeExcludeList intervals;
        private IncludeExcludeList producers;
        private IncludeExcludeList stats;

        public CSVFileStorageConfigElement(CSVFileStorageConfigEntry entry, IncludeExcludeList outerIntervals) {
            this.stats = new IncludeExcludeList(entry.getIncludedStats(), entry.getExcludedStats());
            this.producers = new IncludeExcludeList(entry.getIncludedProducers(), entry.getExcludedProducers());
            this.intervals = !(entry.getIncludedIntervals() != null && entry.getIncludedIntervals().length() != 0 || entry.getExcludedIntervals() != null && entry.getExcludedIntervals().length() != 0) ? outerIntervals : new IncludeExcludeList(entry.getIncludedIntervals(), entry.getExcludedIntervals());
        }

        public boolean include(String producer, String stat, String interval) {
            return this.producers.include(producer) && this.stats.include(stat) && this.intervals.include(interval);
        }

        public String toString() {
            return "CSVFileStorageConfigElement{intervals=" + this.intervals + ", producers=" + this.producers + ", stats=" + this.stats + '}';
        }
    }
}

